/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.conjecture.controller.api;

import com.ejianc.business.zdscost.api.IBudgetPorjectDetailApi;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureApiVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/materialConjectureApi/"})
public class MaterialConjectureApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialConjectureService service;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private IBudgetPorjectDetailApi budgetPorjectDetailApi;

    @PostMapping(value={"materialConjecture"})
    @ResponseBody
    public CommonResponse<List<MaterialConjectureVO>> materialConjecture(@RequestBody List<MaterialConjectureVO> list) {
        String authority = this.request.getHeader("authority");
        this.logger.info("authority:{}", (Object)authority);
        Long billId = list.get(0).getBillId();
        String identificationId = list.get(0).getIdentificationId();
        this.logger.info("==============MaterialConjectureApi=={}==={}\u5f00\u59cb", (Object)billId, (Object)identificationId);
        List materialConjectureEntities = BeanMapper.mapList(list, MaterialConjectureEntity.class);
        this.service.saveOrUpdateBatch(materialConjectureEntities, list.size(), false);
        long startTime = System.nanoTime();
        List<MaterialConjectureVO> result = this.service.materialConjecture(materialConjectureEntities, authority);
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        long seconds = TimeUnit.NANOSECONDS.toSeconds(duration);
        this.logger.info("==============MaterialConjectureApi=={}==={}\u8017\u65f6 {} \u79d2", new Object[]{billId, identificationId, seconds});
        this.budgetPorjectDetailApi.updateMaterialConjecture(result);
        return CommonResponse.success(result);
    }

    @GetMapping(value={"getConjectureProgress"})
    @ResponseBody
    public CommonResponse<MaterialConjectureApiVO> getConjectureProgress(@RequestParam String identificationId) {
        MaterialConjectureApiVO resp = new MaterialConjectureApiVO();
        List<MaterialConjectureEntity> identifyList = this.service.getAllByIdentifyId(identificationId, null, null, null, null, null, null, null);
        Integer completeMatch = 0;
        Integer partialMatch = 0;
        Integer misMatch = 0;
        ArrayList<MaterialConjectureEntity> respList = new ArrayList<MaterialConjectureEntity>();
        for (MaterialConjectureEntity m : identifyList) {
            switch (m.getMateType()) {
                case "0": {
                    Integer n = misMatch;
                    Integer n2 = misMatch = Integer.valueOf(misMatch + 1);
                    break;
                }
                case "1": {
                    Integer n = partialMatch;
                    Integer n2 = partialMatch = Integer.valueOf(partialMatch + 1);
                    break;
                }
                case "2": {
                    Integer n = completeMatch;
                    Integer n2 = completeMatch = Integer.valueOf(completeMatch + 1);
                    break;
                }
            }
            respList.add(m);
        }
        resp.setCompleteMatch(completeMatch);
        resp.setPartialMatch(partialMatch);
        resp.setMisMatch(misMatch);
        resp.setIdentifyList(CollectionUtils.isNotEmpty(respList) ? BeanMapper.mapList(respList, MaterialConjectureVO.class) : new ArrayList());
        return CommonResponse.success((Object)resp);
    }
}

