/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.conjecture.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.plan.conjecture.ConjectureEnum;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.handler.ConjectureManageFactory;
import com.ejianc.business.zdsmaterial.plan.conjecture.mapper.MaterialConjectureMapper;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="materialConjectureService")
public class MaterialConjectureServiceImpl
extends BaseServiceImpl<MaterialConjectureMapper, MaterialConjectureEntity>
implements IMaterialConjectureService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ConjectureManageFactory factory;
    @Value(value="${material.ai.handlerName:CJYT}")
    private String handlerName;
    @Value(value="${material.ai.handleBatchSize:10}")
    private Integer handleBatchSize;

    @Override
    public List<MaterialConjectureVO> materialConjecture(List<MaterialConjectureEntity> saveList, String authority) {
        ArrayList<MaterialConjectureVO> resp = new ArrayList<MaterialConjectureVO>();
        try {
            if ("batch".equals(ConjectureEnum.getHandlerModeByCode(this.handlerName))) {
                ArrayList futureList = new ArrayList();
                List handleList = BeanMapper.mapList(saveList, MaterialConjectureVO.class);
                int totalElements = handleList.size();
                IntStream.range(0, (totalElements + this.handleBatchSize - 1) / this.handleBatchSize).mapToObj(i -> handleList.stream().skip(i * this.handleBatchSize).limit(this.handleBatchSize.intValue()).collect(Collectors.toList())).forEach(batch -> futureList.add(this.factory.handle((List<MaterialConjectureVO>)batch, this.handlerName, authority)));
                for (Future f : futureList) {
                    resp.addAll((Collection)f.get());
                }
                List<MaterialConjectureEntity> retryList = this.getAllByIdentifyId(saveList.get(0).getIdentificationId(), "0");
                if (CollectionUtils.isNotEmpty(retryList)) {
                    this.materialConjecture(retryList, authority);
                }
            } else {
                ArrayList futureList = new ArrayList();
                BeanMapper.mapList(saveList, MaterialConjectureVO.class).parallelStream().forEach(c -> futureList.add(this.factory.handleSingle((MaterialConjectureVO)c, this.handlerName, authority)));
                for (Future f : futureList) {
                    try {
                        resp.add((MaterialConjectureVO)f.get());
                    }
                    catch (Exception e) {
                        this.logger.error("\u7269\u6599\u8bc6\u522bmaterialConjecture Future\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u7269\u6599\u63cf\u8ff0\uff1a{}  AI\u8bc6\u522b\u5f02\u5e38\uff1a", (Object)JSONObject.toJSONString(saveList));
            this.logger.error("\u7269\u6599\u8bc6\u522b\u5f02\u5e38", (Throwable)e);
        }
        return resp;
    }

    @Override
    @Async(value="maCommonTask")
    public void startConjecture(String identificationId, String authority, String mode) {
        String conjectureMode;
        List<MaterialConjectureEntity> list = this.getAllByIdentifyId(identificationId, null);
        String string = conjectureMode = StringUtils.isNotBlank((CharSequence)mode) ? mode : this.handlerName;
        if ("batch".equals(ConjectureEnum.getHandlerModeByCode(conjectureMode))) {
            ArrayList futureList = new ArrayList();
            List handleList = BeanMapper.mapList(list, MaterialConjectureVO.class);
            int totalElements = handleList.size();
            List batchList = IntStream.range(0, (totalElements + this.handleBatchSize - 1) / this.handleBatchSize).mapToObj(i -> handleList.stream().skip(i * this.handleBatchSize).limit(this.handleBatchSize.intValue()).collect(Collectors.toList())).collect(Collectors.toList());
            batchList.parallelStream().forEach(batch -> this.factory.handle((List<MaterialConjectureVO>)batch, conjectureMode, authority));
        } else {
            ArrayList futureList = new ArrayList();
            BeanMapper.mapList(list, MaterialConjectureVO.class).parallelStream().forEach(c -> futureList.add(this.factory.handleSingle((MaterialConjectureVO)c, conjectureMode, authority)));
        }
    }

    public List<MaterialConjectureEntity> getAllByIdentifyId(String identificationId, String mateType) {
        return this.getAllByIdentifyId(identificationId, mateType, null, null, null, null, null, null);
    }

    @Override
    public List<MaterialConjectureEntity> getAllByIdentifyId(String identificationId, String mateType, String actualCategoryName, String actualMaterialCode, String actualMaterialName, String actualMaterialSpec, String actualUnitName, BigDecimal actualNum) {
        return this.getAllByIdentifyId(identificationId, mateType, actualCategoryName, actualMaterialCode, actualMaterialName, actualMaterialSpec, actualUnitName, actualNum, null);
    }

    @Override
    public List<MaterialConjectureEntity> getAllByIdentifyId(String identificationId, String mateType, String actualCategoryName, String actualMaterialCode, String actualMaterialName, String actualMaterialSpec, String actualUnitName, BigDecimal actualNum, String loadState) {
        return this.getAllByIdentifyId(identificationId, mateType, actualCategoryName, actualMaterialCode, actualMaterialName, actualMaterialSpec, actualUnitName, actualNum, loadState, null);
    }

    @Override
    public List<MaterialConjectureEntity> getAllByIdentifyId(String identificationId, String mateType, String actualCategoryName, String actualMaterialCode, String actualMaterialName, String actualMaterialSpec, String actualUnitName, BigDecimal actualNum, String loadState, List<Long> categoryIds) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"identification_id", (Object)identificationId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"del_flag", (Object)BaseVO.DR_UNDELETE);
        if (StringUtils.isNotBlank((CharSequence)mateType) && !"-1".equals(mateType)) {
            query.eq((Object)"mate_type", (Object)mateType);
        }
        if (StringUtils.isNotBlank((CharSequence)actualCategoryName)) {
            query.like((Object)"actual_category_name", (Object)actualCategoryName);
        }
        if (StringUtils.isNotBlank((CharSequence)actualMaterialCode)) {
            query.like((Object)"actual_material_code", (Object)actualMaterialCode);
        }
        if (StringUtils.isNotBlank((CharSequence)actualMaterialName)) {
            query.like((Object)"actual_category_name", (Object)actualMaterialName);
        }
        if (StringUtils.isNotBlank((CharSequence)actualMaterialSpec)) {
            query.like((Object)"actual_material_spec", (Object)actualMaterialSpec);
        }
        if (StringUtils.isNotBlank((CharSequence)actualUnitName)) {
            query.like((Object)"actual_unit_name", (Object)actualUnitName);
        }
        if (null != actualNum) {
            query.eq((Object)"actual_num", (Object)actualNum);
        }
        if (StringUtils.isNotBlank((CharSequence)loadState)) {
            query.eq((Object)"load_state", (Object)loadState);
        }
        if (CollectionUtils.isNotEmpty(categoryIds)) {
            query.in((Object)"actual_category_id", categoryIds);
        }
        return super.list((Wrapper)query);
    }

    @Override
    public void fillBillInfo(Set<String> identifyIds, Long billId, String billCode, String billType) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"identification_id", identifyIds);
        update.isNull((Object)"bill_id");
        update.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        update.set((Object)"bill_id", (Object)billId);
        update.set((Object)"bill_code", (Object)billCode);
        update.set((Object)"bill_type", (Object)billType);
        update.set((Object)"update_time", (Object)new Date());
        update.set((Object)"update_user_code", (Object)InvocationInfoProxy.getUsercode());
        super.update((Wrapper)update);
    }

    @Override
    public List<MaterialConjectureVO> getAllByBillId(Long billId) {
        ArrayList<MaterialConjectureVO> resp = new ArrayList<MaterialConjectureVO>();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"bill_id", (Object)billId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List dbList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            return BeanMapper.mapList((Iterable)dbList, MaterialConjectureVO.class);
        }
        return resp;
    }

    @Override
    public void delConjectureByIds(List<Long> detailIds) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"id", detailIds);
        update.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        update.set((Object)"del_flag", (Object)BaseVO.DR_DELETED);
        update.set((Object)"update_time", (Object)new Date());
        update.set((Object)"update_user_code", (Object)InvocationInfoProxy.getUsercode());
        super.update((Wrapper)update);
    }
}

