/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.purchase.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialSourceVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanService;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purchasePlan")
public class PurchasePlanBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IPurchasePlanService service;
    @Autowired
    private IPurchasePlanDetailService purchasePlanDetailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private IMaterialService materialService;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        PurchasePlanEntity entity = (PurchasePlanEntity)((Object)this.service.selectById(billId));
        if (CollectionUtils.isEmpty(entity.getDetailList())) {
            return CommonResponse.error((String)"\u660e\u7ec6\u4e3a\u7a7a\uff0c\u5f53\u524d\u5355\u636e\u4e0d\u80fd\u63d0\u4ea4\uff01");
        }
        List<PurchasePlanDetailEntity> detailList = entity.getDetailList();
        List collect = detailList.stream().filter(e -> 1 == e.getWorkPlanFlag()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            List<Long> collect1 = collect.stream().map(e -> e.getMaterialId()).collect(Collectors.toList());
            this.service.checkMaterialSumPlan(collect1, entity.getProjectId());
        }
        this.service.validatePlanNum(entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        PurchasePlanEntity purchasePlanEntity = (PurchasePlanEntity)((Object)this.service.selectById(billId));
        purchasePlanEntity.setCommitDate(new Date());
        CommonResponse employeeVOCommonResponse = this.employeeApi.queryEmployeByUserId(this.sessionManager.getUserContext().getUserId());
        purchasePlanEntity.setCommitUserId(this.sessionManager.getUserContext().getUserId());
        purchasePlanEntity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        purchasePlanEntity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
        this.service.saveOrUpdate((Object)purchasePlanEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PurchasePlanEntity purchasePlanEntity = (PurchasePlanEntity)((Object)this.service.selectById(billId));
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
            this.service.validatePlanNum(purchasePlanEntity);
            if (CollectionUtils.isEmpty(purchasePlanEntity.getDetailList())) {
                return CommonResponse.error((String)"\u660e\u7ec6\u4e3a\u7a7a\uff0c\u5f53\u524d\u5355\u636e\u4e0d\u80fd\u63d0\u4ea4\uff01");
            }
            List emptyPropertyValueList = purchasePlanEntity.getDetailList().stream().filter(detail -> StringUtils.isBlank((CharSequence)detail.getPropertyValue())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(emptyPropertyValueList)) {
                StringBuffer sp = new StringBuffer("\u7f16\u7801\u4e3a\u3010");
                sp.append(emptyPropertyValueList.stream().map(PurchasePlanDetailEntity::getMaterialCode).collect(Collectors.joining(",")));
                sp.append("\u3011\u7684\u7269\u6599\u6863\u6848\u89c4\u683c\u578b\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\uff01");
                return CommonResponse.error((String)sp.toString());
            }
        }
        this.service.planToSum(purchasePlanEntity, true);
        List<PurchasePlanDetailEntity> detailList = purchasePlanEntity.getDetailList();
        List collect = detailList.stream().filter(e -> 1 == e.getWorkPlanFlag()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            List<Long> collect1 = collect.stream().map(e -> e.getMaterialId()).collect(Collectors.toList());
            this.service.checkMaterialSumPlan(collect1, purchasePlanEntity.getProjectId());
        }
        purchasePlanEntity.setEffectDate(new Date());
        purchasePlanEntity.setApproveUserId(this.sessionManager.getUserContext().getUserId());
        purchasePlanEntity.setApproveUserName(this.sessionManager.getUserContext().getUserName());
        purchasePlanEntity.setApproveUserCode(this.sessionManager.getUserContext().getUserCode());
        this.service.setSid(purchasePlanEntity);
        this.service.saveOrUpdate((Object)purchasePlanEntity, false);
        this.pushToMaterial(purchasePlanEntity);
        return CommonResponse.success((String)"\u7ec8\u5ba1\u5ba1\u6838\u6210\u529f");
    }

    private void pushToMaterial(PurchasePlanEntity entity) {
        List<PurchasePlanDetailEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isEmpty(detailList = detailList.stream().filter(x -> PlanConstant.SOURCE_TYPE_NEW.equals(x.getSourceType())).collect(Collectors.toList()))) {
            return;
        }
        List typeIds = detailList.stream().map(PurchasePlanDetailEntity::getMaterialTypeId).distinct().collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", typeIds));
        List typeList = this.categoryService.queryList(param);
        Map<Long, MaterialCategoryEntity> typeMap = typeList.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        ArrayList<MaterialVO> saveList = new ArrayList<MaterialVO>();
        detailList.forEach(data -> {
            MaterialVO vo = new MaterialVO();
            vo.setId(data.getMaterialId());
            vo.setCode(data.getMaterialCode());
            vo.setName(data.getMaterialName());
            vo.setCategoryId(data.getMaterialTypeId());
            vo.setCategoryCode(((MaterialCategoryEntity)((Object)((Object)typeMap.get(data.getMaterialTypeId())))).getCode());
            vo.setCategoryName(data.getMaterialTypeName());
            vo.setUnitId(data.getUnitId());
            vo.setUnitName(data.getUnitName());
            vo.setProductCode(data.getProductCode());
            vo.setEnabled(ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
            vo.setBlockedFlag(ZDSMaterialCommonEnums.\u5c01\u5b58_\u6b63\u5e38.getCode());
            vo.setSystemId("sys");
            vo.setSourceId(String.valueOf(data.getId()));
            vo.setPropertyShowName(data.getPropertyValue());
            vo.setRelationList(JSONArray.parseArray((String)data.getProperty(), MaterialPropertyRelationVO.class));
            ArrayList<MaterialSourceVO> sourceList = new ArrayList<MaterialSourceVO>();
            MaterialSourceVO materialSourceVO = new MaterialSourceVO();
            materialSourceVO.setMaterialId(data.getMaterialId());
            materialSourceVO.setBillType("EJCBT202311000006");
            materialSourceVO.setBillTypeName("\u7269\u8d44\u91c7\u8d2d\u8ba1\u5212");
            materialSourceVO.setSourceBillCode(entity.getBillCode());
            materialSourceVO.setSourcePid(entity.getId());
            materialSourceVO.setSourceDetailId(data.getId());
            materialSourceVO.setSourceBillPcUrl(this.baseHost + "ejc-zdsmaterial-frontend/#/purchasePlan/card");
            materialSourceVO.setSourceCreateUserCode(entity.getCreateUserCode());
            materialSourceVO.setSourceCreateUserName(entity.getCreateUserName());
            materialSourceVO.setSourceCreateTime(entity.getCreateTime());
            materialSourceVO.setSourceCreateTime(entity.getCreateTime());
            materialSourceVO.setSourceOrgName(entity.getOrgName());
            sourceList.add(materialSourceVO);
            vo.setSourceList(sourceList);
            saveList.add(vo);
        });
        List<MaterialVO> materialVOS = this.materialService.addNewMaterialsFromBill(saveList);
        Map<String, List<MaterialVO>> map = materialVOS.stream().collect(Collectors.groupingBy(s -> s.getName() + '-' + (StringUtils.isNotBlank((CharSequence)s.getPropertyShowName()) ? s.getPropertyShowName() : "") + '-' + s.getUnitId()));
        for (PurchasePlanDetailEntity controlPlanDetailEntity : detailList) {
            String key = controlPlanDetailEntity.getMaterialName() + "-" + (StringUtils.isNotBlank((CharSequence)controlPlanDetailEntity.getPropertyValue()) ? controlPlanDetailEntity.getPropertyValue() : "") + "-" + controlPlanDetailEntity.getUnitId();
            if (!map.containsKey(key)) continue;
            MaterialVO materialVOS1 = map.get(key).get(0);
            controlPlanDetailEntity.setMaterialId(materialVOS1.getId());
            controlPlanDetailEntity.setMaterialCode(materialVOS1.getCode());
        }
        this.purchasePlanDetailService.saveOrUpdateBatch(detailList);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PurchasePlanEntity entity = (PurchasePlanEntity)((Object)this.service.selectById(billId));
        List<PurchasePlanDetailEntity> detailList = entity.getDetailList();
        List<Long> sourceIds = detailList.stream().filter(x -> PlanConstant.SOURCE_TYPE_NEW.equals(x.getSourceType())).map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(sourceIds)) {
            this.materialService.deleteMaterialsFromBill(sourceIds);
        }
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        PurchasePlanEntity purchasePlanEntity = (PurchasePlanEntity)((Object)this.service.selectById(billId));
        this.service.planToSum(purchasePlanEntity, false);
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

