/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pricelib.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.pricelib.bean.MaterialPriceCalcEntity;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcService;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"materialPriceCalc"})
public class MaterialPriceCalcController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialPriceCalcService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMaterialCategoryService categoryService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialPriceCalcVO> saveOrUpdate(@RequestBody MaterialPriceCalcVO saveOrUpdateVO) {
        MaterialPriceCalcEntity entity = (MaterialPriceCalcEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialPriceCalcEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        MaterialPriceCalcVO vo = (MaterialPriceCalcVO)BeanMapper.map((Object)((Object)entity), MaterialPriceCalcVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialPriceCalcVO> queryDetail(Long id) {
        MaterialPriceCalcEntity entity = (MaterialPriceCalcEntity)((Object)this.service.selectById(id));
        MaterialPriceCalcVO vo = (MaterialPriceCalcVO)BeanMapper.map((Object)((Object)entity), MaterialPriceCalcVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialPriceCalcVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialPriceCalcVO materialPriceCalcVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/changeBaseMaterial"})
    public CommonResponse<MaterialPriceCalcVO> changeBaseMaterial(@RequestBody MaterialPriceCalcVO materialPriceCalcVO) {
        MaterialPriceCalcEntity calc = this.service.selectByCategoryId(materialPriceCalcVO.getId());
        if (null != materialPriceCalcVO.getEnabled()) {
            calc.setEnabled(materialPriceCalcVO.getEnabled());
        } else {
            calc.setMaterialTypeId(materialPriceCalcVO.getMaterialTypeId());
            calc.setMaterialTypeName(materialPriceCalcVO.getMaterialTypeName());
            calc.setMaterialTypeName(materialPriceCalcVO.getMaterialTypeName());
        }
        this.service.saveOrUpdate((Object)calc, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)calc), MaterialPriceCalcVO.class));
    }

    @GetMapping(value={"/getCategoryTree"})
    public CommonResponse<List<Map<String, Object>>> getCategoryTree(@RequestParam(required=false) String categoryCode, @RequestParam(required=false) String categoryName) {
        List dataList;
        QueryParam query = new QueryParam();
        if (StringUtils.isNotBlank((CharSequence)categoryCode)) {
            query.getParams().put("categoryCode", new Parameter("like", (Object)categoryCode));
        }
        if (StringUtils.isNotBlank((CharSequence)categoryName)) {
            query.getParams().put("categoryName", new Parameter("like", (Object)categoryName));
        }
        if (CollectionUtils.isNotEmpty((Collection)(dataList = this.service.queryList(query)))) {
            Map detailMap = dataList.stream().collect(Collectors.toMap(MaterialPriceCalcEntity::getCategoryId, Function.identity()));
            List<Long> categoryIds = dataList.stream().map(MaterialPriceCalcEntity::getCategoryId).collect(Collectors.toList());
            List<MaterialCategoryVO> categoryVOS = this.categoryService.queryCategoryListByChildren(categoryIds);
            categoryVOS.stream().filter(item -> detailMap.containsKey(item.getId())).forEach(item -> {
                item.setMaterialType(((MaterialPriceCalcEntity)((Object)((Object)detailMap.get(item.getId())))).getMaterialType());
                item.setMaterialTypeId(((MaterialPriceCalcEntity)((Object)((Object)detailMap.get(item.getId())))).getMaterialTypeId());
                item.setMaterialTypeName(((MaterialPriceCalcEntity)((Object)((Object)detailMap.get(item.getId())))).getMaterialTypeName());
                item.setEnabled(((MaterialPriceCalcEntity)((Object)((Object)detailMap.get(item.getId())))).getEnabled());
                item.setCalcFields(((MaterialPriceCalcEntity)((Object)((Object)detailMap.get(item.getId())))).getCalcFields());
            });
            return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)ResultAsTree.createTreeData((List)BeanMapper.mapList(categoryVOS, Map.class)));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", new ArrayList());
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialPriceCalcVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialPriceCalcVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialPriceCalc-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaterialPriceCalcData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialPriceCalcVO>> refMaterialPriceCalcData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialPriceCalcVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

