/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pricelib.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.handler.ConjectureManageFactory;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.pricelib.bean.MaterialPriceCalcFormulaEntity;
import com.ejianc.business.zdsmaterial.pricelib.bean.MaterialPriceCalcSubConditionEntity;
import com.ejianc.business.zdsmaterial.pricelib.bean.MaterialPriceSubConditionDetailEntity;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcFormulaService;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcService;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcSubConditionService;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceSubConditionDetailService;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceSubConditionDetailVO;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierApi;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.foundation.share.api.IUnitApi;
import com.ejianc.foundation.share.vo.UnitShareVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"materialPriceCalcSubCondition"})
public class MaterialPriceCalcSubConditionController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialPriceCalcSubConditionService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMaterialPriceCalcService calcService;
    @Autowired
    private IMaterialConjectureService materialConjectureService;
    @Autowired
    private IMaterialPriceSubConditionDetailService conditionDetailService;
    @Autowired
    private ConjectureManageFactory factory;
    @Value(value="${material.ai.handlerName:CJYT}")
    private String handlerName;
    @Autowired
    private IUnitApi unitApi;
    @Autowired
    private IBrandService brandService;
    @Autowired
    private IMatSupplierApi matSupplierApi;
    @Autowired
    private IMaterialPriceCalcFormulaService formulaService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialPriceCalcSubConditionVO> saveOrUpdate(@RequestBody MaterialPriceCalcSubConditionVO saveOrUpdateVO) {
        MaterialPriceCalcSubConditionEntity entity = null;
        MaterialPriceCalcFormulaEntity formula = null;
        if (null == saveOrUpdateVO.getId() || null == saveOrUpdateVO.getPid()) {
            MaterialPriceCalcVO calcVO = this.calcService.getOneByCategoryId(saveOrUpdateVO.getCategoryId());
            saveOrUpdateVO.setPid(calcVO.getId());
            List<MaterialPriceCalcSubConditionVO> conditions = this.service.getAllByPids(Collections.singletonList(calcVO.getId()), null, false);
            if (null == saveOrUpdateVO.getId()) {
                entity = (MaterialPriceCalcSubConditionEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialPriceCalcSubConditionEntity.class));
                MaterialPriceCalcSubConditionVO max = null;
                if (CollectionUtils.isNotEmpty(conditions)) {
                    max = conditions.stream().max(Comparator.comparingInt(MaterialPriceCalcSubConditionVO::getSequence)).get();
                }
                entity.setSequence(null != max ? max.getSequence() + 1 : 0);
            } else {
                Set repeatList;
                entity = (MaterialPriceCalcSubConditionEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()));
                entity.setCalcId(saveOrUpdateVO.getCalcId());
                entity.setCalcParams(saveOrUpdateVO.getCalcParams());
                if (StringUtils.isNotBlank((CharSequence)saveOrUpdateVO.getCalcDisplayContent())) {
                    entity.setCalcDisplayContent(saveOrUpdateVO.getCalcDisplayContent());
                }
                if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getDetailList())) {
                    entity.setDetailList(BeanMapper.mapList((Iterable)saveOrUpdateVO.getDetailList(), MaterialPriceSubConditionDetailEntity.class));
                }
                if (StringUtils.isNotBlank((CharSequence)saveOrUpdateVO.getCalcCode())) {
                    entity.setCalcCode(saveOrUpdateVO.getCalcCode());
                }
                if (CollectionUtils.isNotEmpty(repeatList = conditions.stream().filter(item -> !item.getId().equals(saveOrUpdateVO.getId()) && item.getSequence() == saveOrUpdateVO.getSequence()).collect(Collectors.toSet()))) {
                    return CommonResponse.error((String)("\u64cd\u4f5c\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u6392\u5e8f\u4e3a\uff1a" + saveOrUpdateVO.getSequence() + "\u7684\u6761\u4ef6\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u4fdd\u5b58\uff01"));
                }
            }
        }
        if (null != entity.getCalcId() && StringUtils.isNotBlank((CharSequence)entity.getCalcParams())) {
            formula = (MaterialPriceCalcFormulaEntity)((Object)this.formulaService.getById(entity.getCalcId()));
            Map calcParams = (Map)JSONObject.parseObject((String)entity.getCalcParams(), Map.class);
            String calcContent = formula.getCalcDisplayContent();
            for (String key : calcParams.keySet()) {
                if (!calcContent.contains(key)) continue;
                calcContent = calcContent.replaceAll(key, (String)calcParams.get(key));
            }
            entity.setCalcDisplayContent(calcContent);
        }
        this.service.saveOrUpdate((Object)entity, false);
        MaterialPriceCalcSubConditionVO vo = (MaterialPriceCalcSubConditionVO)BeanMapper.map((Object)((Object)entity), MaterialPriceCalcSubConditionVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialPriceCalcSubConditionVO> update(@RequestBody MaterialPriceCalcSubConditionVO saveOrUpdateVO) {
        MaterialPriceCalcSubConditionEntity entity = (MaterialPriceCalcSubConditionEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()));
        if (null != saveOrUpdateVO.getSequence()) {
            entity.setSequence(saveOrUpdateVO.getSequence());
        }
        if (null != saveOrUpdateVO.getEnabled()) {
            entity.setEnabled(saveOrUpdateVO.getEnabled());
        }
        this.service.saveOrUpdate((Object)entity, false);
        MaterialPriceCalcSubConditionVO vo = (MaterialPriceCalcSubConditionVO)BeanMapper.map((Object)((Object)entity), MaterialPriceCalcSubConditionVO.class);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialPriceCalcSubConditionVO> queryDetail(Long id) {
        MaterialPriceCalcSubConditionEntity entity = (MaterialPriceCalcSubConditionEntity)((Object)this.service.selectById(id));
        MaterialPriceCalcSubConditionVO vo = (MaterialPriceCalcSubConditionVO)BeanMapper.map((Object)((Object)entity), MaterialPriceCalcSubConditionVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialPriceCalcSubConditionVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialPriceCalcSubConditionVO materialPriceCalcSubConditionVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialPriceCalcSubConditionVO>> queryList(@RequestBody QueryParam param) {
        Page resp = new Page();
        resp.setCurrent((long)param.getPageIndex());
        resp.setSize((long)param.getPageSize());
        param.getOrderMap().put("sequence", "asc");
        if (param.getParams().containsKey("categoryId") || param.getParams().containsKey("materialType")) {
            List calcList;
            QueryWrapper query = new QueryWrapper();
            if (param.getParams().containsKey("categoryId")) {
                query.eq((Object)"category_id", (Object)Long.valueOf(((Parameter)param.getParams().get("categoryId")).getValue().toString()));
                param.getParams().remove("categoryId");
            }
            if (param.getParams().containsKey("materialType")) {
                query.eq((Object)"material_type", (Object)((Parameter)param.getParams().get("materialType")).getValue().toString());
                param.getParams().remove("materialType");
            }
            if (CollectionUtils.isEmpty((Collection)(calcList = this.calcService.list((Wrapper)query)))) {
                resp.setTotal(0L);
                resp.setRecords(new ArrayList());
                return CommonResponse.success((Object)resp);
            }
            param.getParams().put("pid", Parameter.getInInstance(calcList.stream().map(BaseEntity::getId).collect(Collectors.toList())));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), MaterialPriceCalcSubConditionVO.class);
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            Map<Long, List<MaterialPriceSubConditionDetailVO>> detailMap = this.conditionDetailService.getAllByConditionIds(records.stream().map(BaseVO::getId).collect(Collectors.toList()));
            for (MaterialPriceCalcSubConditionVO m : records) {
                if (!detailMap.containsKey(m.getId())) continue;
                m.setDetailList(detailMap.get(m.getId()));
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialPriceCalcSubCondition-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaterialPriceCalcSubConditionData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialPriceCalcSubConditionVO>> refMaterialPriceCalcSubConditionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialPriceCalcSubConditionVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"materialPriceCalc-import.xlsx", (String)"\u4ef7\u683c\u67e5\u8be2\u5bfc\u5165\u6a21\u677f");
    }

    @PostMapping(value={"/saveImport"})
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<MaterialConjectureVO> saveList, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        this.materialConjectureService.saveOrUpdateBatch(BeanMapper.mapList(saveList, MaterialConjectureEntity.class), saveList.size(), false);
        this.materialConjectureService.startConjecture(saveList.get(0).getIdentificationId(), authority, saveList.get(0).getMode());
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f,\u7269\u6599\u8bc6\u522b\u4e2d\uff01");
    }

    @PostMapping(value={"/excelImport"})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        String conjectureId = request.getParameter("identificationId");
        String mode = request.getParameter("mode");
        if (StringUtils.isBlank((CharSequence)mode)) {
            mode = "CJYT";
        }
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        ArrayList<MaterialConjectureVO> successList = new ArrayList<MaterialConjectureVO>();
        ArrayList<MaterialConjectureVO> processList = new ArrayList<MaterialConjectureVO>();
        ArrayList<MaterialConjectureVO> errorList = new ArrayList<MaterialConjectureVO>();
        HashSet<String> unitNames = new HashSet<String>();
        HashSet<String> brandNames = new HashSet<String>();
        HashSet<String> matSupplierNames = new HashSet<String>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            MaterialConjectureVO vo = null;
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                vo = new MaterialConjectureVO();
                vo.setMode(mode);
                vo.setIdentificationId(conjectureId);
                vo.setMateType("4");
                vo.setConjectureMateType("4");
                vo.setDelFlag("0");
                vo.setIgnoreFlag("0");
                vo.setLoadState("0");
                vo.setIdentificationDate(new Date());
                vo.setId(Long.valueOf(IdWorker.getId()));
                vo.setImportSeq((String)datas.get(0));
                vo.setSourceMaterialName((String)datas.get(1));
                vo.setSourceMaterialSpec((String)datas.get(2));
                vo.setSourceUnitName((String)datas.get(3));
                try {
                    vo.setSourceNum(ComputeUtil.toBigDecimal((String)((String)datas.get(4))));
                }
                catch (Exception e) {
                    vo.setErrorMsg("\u3010\u6570\u91cf\u3011\u9700\u586b\u5199\u6570\u503c\uff01");
                    errorList.add(vo);
                    continue;
                }
                vo.setBrandName((String)datas.get(5));
                vo.setSupplierName((String)datas.get(6));
                if (datas.size() >= 8) {
                    vo.setExtParam1((String)datas.get(7));
                }
                if (datas.size() >= 9) {
                    vo.setExtParam2((String)datas.get(8));
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setErrorMsg("\u3010\u7269\u6599\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setErrorMsg("\u3010\u7279\u5f81\u63cf\u8ff0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    vo.setErrorMsg("\u3010\u5355\u4f4d\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)vo.getBrandName())) {
                    vo.setErrorMsg("\u3010\u54c1\u724c\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                unitNames.add(vo.getSourceUnitName());
                brandNames.add(vo.getBrandName());
                matSupplierNames.add(vo.getSupplierName());
                vo.setRowState("add");
                processList.add(vo);
            }
        }
        if (CollectionUtils.isNotEmpty(processList)) {
            CommonResponse unitListResp = this.unitApi.findAllEnabledList(new ArrayList(unitNames));
            if (!unitListResp.isSuccess()) {
                this.logger.error("\u7269\u6599ai\u5bfc\u5165\u8bc6\u522b\u5931\u8d25\uff0c\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u5931\u8d25,names:{}, \u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(unitNames), (Object)JSONObject.toJSONString((Object)unitListResp));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5339\u914d\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)unitListResp.getData()))) {
                this.logger.error("\u7269\u6599ai\u5bfc\u5165\u8bc6\u522b\u5931\u8d25\uff0c\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a, names:{}", (Object)JSONObject.toJSONString(unitNames));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5339\u914d\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff01");
            }
            Map<String, BrandEntity> brandMap = this.brandService.getAllByNames(new ArrayList<String>(brandNames));
            HashMap<String, MatSupplierVO> supplierMap = new HashMap<String, MatSupplierVO>();
            if (CollectionUtils.isNotEmpty(matSupplierNames)) {
                CommonResponse matSupResp = this.matSupplierApi.getAllByNames(new ArrayList(matSupplierNames));
                if (!matSupResp.isSuccess()) {
                    this.logger.error("\u64cd\u4f5c\u5931\u8d25\uff0c\u6839\u636e\u540d\u79f0names-{}\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25,{}", (Object)JSONObject.toJSONString(matSupplierNames), (Object)JSONObject.toJSONString((Object)matSupResp));
                    return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6839\u636e\u540d\u79f0\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
                }
                if (CollectionUtils.isNotEmpty((Collection)((Collection)matSupResp.getData()))) {
                    supplierMap.putAll(((List)matSupResp.getData()).stream().collect(Collectors.toMap(item -> item.getName(), item -> item, (v1, v2) -> v1)));
                }
            }
            HashMap<String, Long> unitNameIdMap = new HashMap<String, Long>();
            HashMap<String, Long> unitAliasNameIdMap = new HashMap<String, Long>();
            unitNameIdMap.putAll(((List)unitListResp.getData()).stream().collect(Collectors.toMap(UnitShareVO::getUnitName, BaseVO::getId, (k1, k2) -> k1)));
            unitAliasNameIdMap.putAll(((List)unitListResp.getData()).stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getAliasName())).collect(Collectors.toMap(item -> item.getAliasName(), BaseVO::getId, (k1, k2) -> k1)));
            for (MaterialConjectureVO m : processList) {
                m.setActualUnitName(m.getSourceUnitName());
                if (unitNameIdMap.containsKey(m.getSourceUnitName())) {
                    m.setActualUnitId((Long)unitNameIdMap.get(m.getSourceUnitName()));
                }
                for (String key : unitAliasNameIdMap.keySet()) {
                    if (!key.contains("," + m.getSourceUnitName() + ",")) continue;
                    m.setActualUnitId((Long)unitAliasNameIdMap.get(key));
                }
                if (null == m.getActualUnitId()) {
                    m.setErrorMsg("\u8ba1\u91cf\u5355\u4f4d\u3010" + m.getActualUnitName() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01");
                    errorList.add(m);
                    continue;
                }
                if (!brandMap.containsKey(m.getBrandName())) {
                    m.setErrorMsg("\u54c1\u724c\u3010" + m.getBrandName() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01");
                    errorList.add(m);
                    continue;
                }
                m.setBrandId(brandMap.get(m.getBrandName()).getId());
                if (!supplierMap.containsKey(m.getSupplierName())) {
                    m.setErrorMsg("\u4f9b\u5e94\u5546\u3010" + m.getSupplierName() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01");
                    errorList.add(m);
                    continue;
                }
                m.setSupplierId(((MatSupplierVO)supplierMap.get(m.getSupplierName())).getId());
                m.setSupplierCode(((MatSupplierVO)supplierMap.get(m.getSupplierName())).getCode());
                successList.add(m);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", (Object)successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

