/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pricelib.processor;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.pricelib.processor.BaseCalcProcessor;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceSubConditionDetailVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceLibVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import java.math.BigDecimal;
import java.util.Collection;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class C0301BrandAndPropertyProcessor
implements BaseCalcProcessor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean calcBeforeCheck(PriceLibVO priceLibVO, MaterialPriceCalcSubConditionVO calcFormula) {
        if (null == priceLibVO.getBaseMaterialNetPrice()) {
            this.logger.error("\u4e0d\u9508\u94a2\u65e0\u7f1d\u7ba1\u516c\u5f0f\uff1aC0301BrandAndPropertyProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c\u539f\u6750\u6599\u7f51\u4ef7\u4e3a\u7a7a, {}", (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u539f\u6750\u6599\u7f51\u4ef7\u4e3a\u7a7a");
            return false;
        }
        if (null == priceLibVO.getBaseMaterialUnitPrice()) {
            this.logger.error("\u4e0d\u9508\u94a2\u65e0\u7f1d\u7ba1\u516c\u5f0f\uff1aC0301BrandAndPropertyProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c\u539f\u6750\u6599\u57fa\u7840\u4ef7\u4e3a\u7a7a, {}", (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u539f\u6750\u6599\u57fa\u7840\u4ef7\u4e3a\u7a7a");
            return false;
        }
        if (null == priceLibVO.getBaseMaterialPrice()) {
            this.logger.error("\u4e0d\u9508\u94a2\u65e0\u7f1d\u7ba1\u516c\u5f0f\uff1aC0301BrandAndPropertyProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c\u57fa\u7840\u5355\u4ef7\u4e3a\u7a7a, {}", (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u57fa\u7840\u5355\u4ef7\u4e3a\u7a7a");
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)calcFormula.getDetailList())) {
            this.logger.error("\u4e0d\u9508\u94a2\u65e0\u7f1d\u7ba1\u516c\u5f0f\uff1aC0301BrandAndPropertyProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c \u8ba1\u7b97\u89c4\u5219\u5143\u7d20\u6e05\u5355\u4e3a\u7a7a, {}", (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u8ba1\u7b97\u89c4\u5219\u5143\u7d20\u6e05\u5355\u4e3a\u7a7a");
            return false;
        }
        if (StringUtil.isBlank((CharSequence)priceLibVO.getExtParam1())) {
            this.logger.error("\u4e0d\u9508\u94a2\u65e0\u7f1d\u7ba1\u516c\u5f0f\uff1aC0301BrandAndPropertyProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c \u91cd\u91cf\u4e3a\u7a7a, {}", (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u8ba1\u7b97\u56e0\u7d20[\u91cd\u91cf]\u4e3a\u7a7a");
            return false;
        }
        return true;
    }

    @Override
    public BigDecimal calc(PriceLibVO priceLibVO, MaterialPriceCalcSubConditionVO calcFormula) {
        if (!this.calcBeforeCheck(priceLibVO, calcFormula)) {
            return BigDecimal.ZERO;
        }
        priceLibVO.setCalcContent(calcFormula.getCalcDisplayContent());
        MaterialPriceSubConditionDetailVO calcElem = (MaterialPriceSubConditionDetailVO)calcFormula.getDetailList().get(0);
        JSONObject params = JSONObject.parseObject((String)calcFormula.getCalcParams());
        BigDecimal result = BigDecimal.ZERO;
        result = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(priceLibVO.getBaseMaterialPrice(), new BigDecimal(priceLibVO.getExtParam1())), new BigDecimal("1000"));
        result = ComputeUtil.safeAdd(ComputeUtil.safeSub(result, priceLibVO.getBaseMaterialUnitPrice()), priceLibVO.getBaseMaterialNetPrice());
        result = ComputeUtil.safeMultiply(result, ComputeUtil.safeMultiply(new BigDecimal(priceLibVO.getExtParam1()), new BigDecimal("0.001")));
        priceLibVO.setAdjustedPrice(result);
        priceLibVO.setAdjustedFirstPrice(result);
        priceLibVO.setCalcMny(ComputeUtil.safeMultiply(result, priceLibVO.getSourceNum()));
        return result;
    }
}

