/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pricelib.processor;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.pricelib.processor.BaseCalcProcessor;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceLibVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import java.math.BigDecimal;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class D1101SingleBrandProcessor
implements BaseCalcProcessor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean calcBeforeCheck(PriceLibVO priceLibVO, MaterialPriceCalcSubConditionVO calcFormula) {
        if (null == priceLibVO.getBaseMaterialNetPrice()) {
            this.logger.error("\u7535\u529b\u7535\u7f06/\u63a7\u5236\u7535\u7f06\u516c\u5f0f\uff1aD1101SingleBrandProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c\u539f\u6750\u6599\u7f51\u4ef7\u4e3a\u7a7a, {}", (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u539f\u6750\u6599\u7f51\u4ef7\u4e3a\u7a7a");
            return false;
        }
        if (null == priceLibVO.getBaseMaterialUnitPrice()) {
            this.logger.error("\u7535\u529b\u7535\u7f06/\u63a7\u5236\u7535\u7f06\uff1aD1101SingleBrandProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c\u539f\u6750\u6599\u57fa\u7840\u4ef7\u4e3a\u7a7a, {}", (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u539f\u6750\u6599\u57fa\u7840\u4ef7\u4e3a\u7a7a");
            return false;
        }
        if (null == priceLibVO.getBaseMaterialPrice()) {
            this.logger.error("\u7535\u529b\u7535\u7f06/\u63a7\u5236\u7535\u7f06\uff1aD1101SingleBrandProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c\u57fa\u7840\u5355\u4ef7\u4e3a\u7a7a, {}", (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u57fa\u7840\u5355\u4ef7\u4e3a\u7a7a");
            return false;
        }
        if (StringUtil.isBlank((CharSequence)calcFormula.getCalcParams())) {
            this.logger.error("\u7535\u529b\u7535\u7f06/\u63a7\u5236\u7535\u7f06\uff1aD1101SingleBrandProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c \u8f85\u52a9\u8ba1\u7b97\u53c2\u6570\u4e3a\u7a7a, {}", (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u8f85\u52a9\u8ba1\u7b97\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        return true;
    }

    @Override
    public BigDecimal calc(PriceLibVO priceLibVO, MaterialPriceCalcSubConditionVO calcFormula) {
        if (!this.calcBeforeCheck(priceLibVO, calcFormula)) {
            return BigDecimal.ZERO;
        }
        priceLibVO.setCalcContent(calcFormula.getCalcDisplayContent());
        JSONObject params = JSONObject.parseObject((String)calcFormula.getCalcParams());
        BigDecimal result = BigDecimal.ZERO;
        result = ComputeUtil.safeSub(priceLibVO.getBaseMaterialNetPrice(), priceLibVO.getBaseMaterialUnitPrice());
        result = ComputeUtil.safeDiv(result, new BigDecimal(params.getString("\u53c2\u65701")));
        result = ComputeUtil.safeAdd(ComputeUtil.safeMultiply(result, new BigDecimal(params.getString("\u53c2\u65702"))), BigDecimal.ONE);
        result = ComputeUtil.safeMultiply(result, priceLibVO.getBaseMaterialPrice());
        priceLibVO.setAdjustedPrice(result);
        priceLibVO.setAdjustedFirstPrice(result);
        priceLibVO.setCalcMny(ComputeUtil.safeMultiply(result, priceLibVO.getSourceNum()));
        return result;
    }
}

