/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pricelib.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.pricelib.bean.MaterialPriceCalcEntity;
import com.ejianc.business.zdsmaterial.pricelib.mapper.MaterialPriceCalcMapper;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcService;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcSubConditionService;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceSubConditionDetailService;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceSubConditionDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialPriceCalcService")
public class MaterialPriceCalcServiceImpl
extends BaseServiceImpl<MaterialPriceCalcMapper, MaterialPriceCalcEntity>
implements IMaterialPriceCalcService {
    @Autowired
    private IMaterialPriceCalcSubConditionService conditionService;
    @Autowired
    private IMaterialPriceSubConditionDetailService conditionDetailService;

    @Override
    public MaterialPriceCalcVO getOneByCategoryId(Long categoryId) {
        return (MaterialPriceCalcVO)BeanMapper.map((Object)((Object)this.selectByCategoryId(categoryId)), MaterialPriceCalcVO.class);
    }

    @Override
    public MaterialPriceCalcEntity selectByCategoryId(Long categoryId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"category_id", (Object)categoryId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return (MaterialPriceCalcEntity)((Object)super.getOne((Wrapper)query));
    }

    @Override
    public List<MaterialPriceCalcVO> getAllByCategoryIds(List<Long> categoryIds) {
        ArrayList<MaterialPriceCalcVO> resp = new ArrayList<MaterialPriceCalcVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"category_id", categoryIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List list = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return BeanMapper.mapList((Iterable)list, MaterialPriceCalcVO.class);
        }
        return resp;
    }

    @Override
    public Map<Long, List<MaterialPriceCalcSubConditionVO>> getConditionMapByCategoryIds(List<Long> categoryIds) {
        Map<Long, Long> categoryPidMap;
        List<MaterialPriceCalcSubConditionVO> conList;
        HashMap<Long, List<MaterialPriceCalcSubConditionVO>> resp = new HashMap<Long, List<MaterialPriceCalcSubConditionVO>>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"category_id", categoryIds);
        query.eq((Object)"enabled", (Object)"1");
        List list = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list) && CollectionUtils.isNotEmpty(conList = this.conditionService.getAllByPids(new ArrayList<Long>((categoryPidMap = list.stream().collect(Collectors.toMap(item -> item.getId(), item -> item.getCategoryId()))).keySet()), "1", true))) {
            Map<Long, List<MaterialPriceSubConditionDetailVO>> detailMap = this.conditionDetailService.getAllByConditionIds(conList.stream().map(BaseVO::getId).collect(Collectors.toList()));
            conList.stream().filter(c -> detailMap.containsKey(c.getId())).forEach(c -> c.setDetailList((List)detailMap.get(c.getId())));
            return conList.stream().collect(Collectors.groupingBy(c -> (Long)categoryPidMap.get(c.getPid())));
        }
        return resp;
    }
}

