/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pricelib.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsmaterial.pricelib.bean.PriceGuideEntity;
import com.ejianc.business.zdsmaterial.pricelib.mapper.PriceGuideMapper;
import com.ejianc.business.zdsmaterial.pricelib.service.IPriceGuideService;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceGuideDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="priceGuideService")
public class PriceGuideServiceImpl
extends BaseServiceImpl<PriceGuideMapper, PriceGuideEntity>
implements IPriceGuideService {
    @Autowired
    private IMaterialService materialService;

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<PriceGuideDetailVO> successList = new ArrayList<PriceGuideDetailVO>();
        ArrayList<PriceGuideDetailVO> errorList = new ArrayList<PriceGuideDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList<String> materialCodeList = new ArrayList<String>();
            Map<Object, Object> map = new HashMap();
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                materialCodeList.add((String)datas.get(0));
            }
            List<MaterialVO> list = this.materialService.getByCodes(materialCodeList);
            map = list.stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                PriceGuideDetailVO detailVO = new PriceGuideDetailVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                String materialCode = (String)datas.get(0);
                if (!map.containsKey(materialCode)) {
                    detailVO.setErrorMsg("\u6750\u6599\u7f16\u7801\u4e0d\u5339\u914d\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                MaterialVO materialVO = (MaterialVO)map.get(materialCode);
                detailVO.setMaterialTypeId(materialVO.getCategoryId());
                detailVO.setMaterialTypeName(materialVO.getCategoryName());
                detailVO.setMaterialId(materialVO.getId());
                detailVO.setMaterialName(materialVO.getName());
                detailVO.setSpec(materialVO.getPropertyShowName());
                detailVO.setUnitId(materialVO.getUnitId());
                detailVO.setUnitName(materialVO.getUnitName());
                try {
                    String minMny = (String)datas.get(1);
                    detailVO.setMinMny(StringUtils.isNotBlank((CharSequence)minMny) ? new BigDecimal(minMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u6700\u4f4e\u4ef7\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String maxMny = (String)datas.get(2);
                    detailVO.setMaxMny(StringUtils.isNotBlank((CharSequence)maxMny) ? new BigDecimal(maxMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u6700\u9ad8\u4ef7\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

