/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.fee.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractDetailEntity;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractDetailService;
import com.ejianc.business.zdsmaterial.sub.fee.bean.SubFeeApplyDetailEntity;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyDetailService;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyService;
import com.ejianc.business.zdssupplier.sub.api.ISubSupplierApi;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"subFeeApply/erp"})
public class SubFeeApplyErpController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISubSupplierApi subSupplierApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private ISubFeeApplyService service;
    @Autowired
    private ISubFeeApplyDetailService detailService;
    @Autowired
    private ISubContractDetailService contractDetailService;

    @PostMapping(value={"/pageList"})
    public CommonResponse<JSONObject> pageSyncList(@RequestBody JSONObject param) {
        JSONObject resp = new JSONObject();
        this.logger.info("ERP\u67e5\u8be2\u5206\u5305\u8d39\u7528\u7533\u8bf7\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        Integer pageSize = null != param && null != param.getInteger("PageSize") ? param.getInteger("PageSize") : 10;
        Integer pageNum = null != param && null != param.getInteger("PageNum") ? param.getInteger("PageNum") : 1;
        String BeginDateTime = null != param && null != param.getString("BeginDateTime") ? param.getString("BeginDateTime") : null;
        String EndDateTime = null != param && null != param.getString("EndDateTime") ? param.getString("EndDateTime") : null;
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)BeginDateTime)) {
            queryParam.put("beginDateTime", BeginDateTime);
        }
        if (StringUtils.isNotBlank((CharSequence)EndDateTime)) {
            queryParam.put("endDateTime", EndDateTime);
        }
        int count = this.service.pageCount(queryParam);
        resp.put("total", (Object)count);
        resp.put("pageSize", (Object)pageSize);
        resp.put("pageNum", (Object)pageNum);
        if (count == 0) {
            resp.put("records", new ArrayList());
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
        }
        Integer startLine = pageNum - 1 < 0 ? pageSize : (pageNum - 1) * pageSize;
        queryParam.put("startLine", startLine);
        queryParam.put("pageSize", pageSize);
        List<JSONObject> pageList = this.service.pageList(queryParam);
        ArrayList projectIds = new ArrayList();
        ArrayList<Long> pIds = new ArrayList<Long>();
        ArrayList supplierIds = new ArrayList();
        ArrayList syncContractVO = new ArrayList();
        ArrayList empIds = new ArrayList();
        pageList.stream().forEach(item -> {
            if (!projectIds.contains(item.getLong("projectId"))) {
                projectIds.add(item.getLong("projectId"));
            }
            if (!pIds.contains(item.getLong("YQL_SID"))) {
                pIds.add(item.getLong("YQL_SID"));
            }
            if (!supplierIds.contains(item.getLong("supplierId"))) {
                supplierIds.add(item.getLong("supplierId"));
            }
            if (StringUtils.isNotBlank((CharSequence)item.getString("ApprHumanCode")) && !syncContractVO.contains(item.getString("ApprHumanCode"))) {
                syncContractVO.add(item.getString("ApprHumanCode"));
            }
            if (!empIds.contains(item.getLong("EngineerId"))) {
                empIds.add(item.getLong("EngineerId"));
            }
        });
        CommonResponse projectResp = this.projectPoolApi.queryProjectByIds(projectIds);
        if (!projectResp.isSuccess()) {
            this.logger.error("\u5206\u5305\u8d39\u7528\u7533\u8bf7\u67e5\u8be2\u5931\u8d25\uff0c\u6839\u636e\u9879\u76eeId\u5217\u8868-{}\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString(projectIds), (Object)JSONObject.toJSONString((Object)projectResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        HashMap<Long, String> projectSidMap = new HashMap<Long, String>();
        List projectList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)projectResp.getData()), ProjectPoolSetVO.class);
        if (CollectionUtils.isNotEmpty((Collection)projectList)) {
            projectSidMap.putAll(projectList.stream().collect(Collectors.toMap(BaseVO::getId, ProjectPoolSetVO::getSourceId)));
        }
        HashMap supplierMap = new HashMap();
        CommonResponse supplierResp = this.subSupplierApi.getAllByIds(supplierIds);
        if (!supplierResp.isSuccess()) {
            this.logger.error("\u5206\u5305\u8d39\u7528\u7533\u8bf7\u67e5\u8be2\u5931\u8d25\uff0c\u6839\u636e\u4f9b\u5e94\u5546\u5217\u8868-{}\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString(supplierIds), (Object)JSONObject.toJSONString((Object)supplierResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        supplierMap.putAll(((List)supplierResp.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())));
        HashMap empMap = new HashMap();
        HashMap empIdMap = new HashMap();
        CommonResponse empResp = this.employeeApi.getAllByEmployeeCodes(syncContractVO);
        if (!empResp.isSuccess()) {
            this.logger.error("\u5206\u5305\u8d39\u7528\u7533\u8bf7\u67e5\u8be2\u5931\u8d25\uff0c\u6839\u636e\u4eba\u5458\u5de5\u53f7\u5217\u8868-{}\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString(syncContractVO), (Object)JSONObject.toJSONString((Object)empResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List empList = (List)empResp.getData();
        if (CollectionUtils.isNotEmpty((Collection)empList)) {
            empMap.putAll(empList.stream().collect(Collectors.toMap(EmployeeVO::getCode, Function.identity())));
        }
        if (CollectionUtils.isNotEmpty(empIds)) {
            empResp = this.employeeApi.getByIds(empIds);
            if (!empResp.isSuccess()) {
                this.logger.error("\u5206\u5305\u8d39\u7528\u7533\u8bf7\u67e5\u8be2\u5931\u8d25\uff0c\u6839\u636e\u4eba\u5458id\u5217\u8868-{}\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString(empIds), (Object)JSONObject.toJSONString((Object)empResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff01");
            }
            empList = (List)empResp.getData();
            if (CollectionUtils.isNotEmpty((Collection)empList)) {
                empIdMap.putAll(empList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())));
            }
        }
        Map<Long, List<SubFeeApplyDetailEntity>> subDetailMap = this.detailService.getAllBySettleIds(pIds);
        JSONObject params = new JSONObject();
        params.put("sourceIds", new ArrayList<Long>(pIds));
        CommonResponse attachResp = this.attachmentApi.queryAllBySourceIdList(params);
        if (!attachResp.isSuccess()) {
            this.logger.error("\u6839\u636esourceId\u5217\u8868-{}\u67e5\u8be2\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c", (Object)JSONObject.toJSONString(pIds), (Object)JSONObject.toJSONString((Object)attachResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5b50\u8868\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List fileData = (List)attachResp.getData();
        HashMap<Long, List<AttachmentVO>> fileMap = new HashMap<Long, List<AttachmentVO>>();
        fileMap.putAll(fileData.stream().collect(Collectors.groupingBy(AttachmentVO::getSourceId)));
        ArrayList<Long> contractDetailIds = new ArrayList<Long>(subDetailMap.values().stream().flatMap(Collection::stream).map(SubFeeApplyDetailEntity::getInfoId).collect(Collectors.toSet()));
        Map<Object, Object> contractDetailMap = new HashMap();
        if (CollectionUtils.isNotEmpty(contractDetailIds)) {
            contractDetailMap = this.contractDetailService.getAllByIds(contractDetailIds);
        }
        EmployeeVO emp = null;
        Object project = null;
        SupplierVO supplier = null;
        Object attach = null;
        SubContractDetailEntity tmpDetail = null;
        for (JSONObject settle : pageList) {
            emp = (EmployeeVO)empIdMap.get(settle.getLong("EngineerId"));
            settle.put("Engineer_Sid", (Object)emp.getSourceId());
            settle.put("Engineer", (Object)emp.getName());
            emp = (EmployeeVO)empMap.get(settle.getString("ApprHumanCode"));
            settle.put("ApprHuman_sid", (Object)emp.getSourceId());
            settle.put("ApprHuman", (Object)emp.getName());
            settle.put("Account_Project_Sid", projectSidMap.get(settle.getLong("projectId")));
            settle.remove((Object)"projectId");
            supplier = (SupplierVO)supplierMap.get(settle.getLong("supplierId"));
            settle.put("Company_Sid", (Object)supplier.getThirdSourceId());
            settle.put("Company_Name", (Object)supplier.getName());
            settle.remove((Object)"supplierId");
            settle.put("ApprDate", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)settle.getDate("ApprDate")));
            JSONArray detailArr = new JSONArray();
            settle.put("SubDetails", (Object)detailArr);
            JSONObject detailJson = null;
            for (SubFeeApplyDetailEntity detail : subDetailMap.get(settle.getLong("YQL_SID"))) {
                tmpDetail = (SubContractDetailEntity)((Object)contractDetailMap.get(detail.getInfoId()));
                detailJson = new JSONObject();
                detailJson.put("YQL_SID", (Object)detail.getId());
                detailJson.put("SpeModel", (Object)detail.getPropertyValue());
                detailJson.put("Unit", (Object)detail.getUnitName());
                detailJson.put("Number", (Object)detail.getNum().toPlainString());
                detailJson.put("MaterialPrice", null != detail.getMaterialTaxPrice() ? detail.getMaterialTaxPrice().toPlainString() : BigDecimal.ZERO);
                detailJson.put("ManPrice", null != detail.getHumanTaxPrice() ? detail.getHumanTaxPrice().toPlainString() : BigDecimal.ZERO);
                detailJson.put("ComprePrice", (Object)detail.getCompareTaxPrice().toPlainString());
                detailJson.put("SumMoney", (Object)detail.getTaxMny().toPlainString());
                detailJson.put("Brand", (Object)detail.getBrandName());
                detailJson.put("Memo", (Object)detail.getMemo());
                detailJson.put("PacketCode", (Object)(null != tmpDetail ? tmpDetail.getCostCodingName() : ""));
                detailJson.put("SubConMoney", (Object)(null != tmpDetail && null != tmpDetail.getSumTaxConMoney() ? tmpDetail.getSumTaxConMoney().toPlainString() : ""));
                detailJson.put("ProjectContent", (Object)(null != tmpDetail ? tmpDetail.getProjectContent() : ""));
                detailArr.add((Object)detailJson);
            }
            JSONArray subFileArr = new JSONArray();
            settle.put("ArchivesList", (Object)subFileArr);
            if (null == fileMap.get(settle.getLong("YQL_SID"))) continue;
            JSONObject subF = null;
            for (AttachmentVO file : (List)fileMap.get(settle.getLong("YQL_SID"))) {
                subF = new JSONObject();
                subF.put("Attach_Name", (Object)file.getFileName());
                subF.put("Attach_Extension", (Object)file.getFileName().substring(file.getFileName().indexOf(".")));
                subF.put("Attach_Type", (Object)file.getFileName().substring(file.getFileName().indexOf(".") + 1));
                subF.put("AttachBase64", (Object)(this.BASE_HOST + "filepreview/" + file.getFilePath()));
                subF.put("YQL_SID", (Object)file.getId());
                subFileArr.add((Object)subF);
            }
        }
        resp.put("records", pageList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }
}

