/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.fee.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractService;
import com.ejianc.business.zdsmaterial.sub.fee.bean.AuditorContractDetailEntity;
import com.ejianc.business.zdsmaterial.sub.fee.bean.AuditorSetEntity;
import com.ejianc.business.zdsmaterial.sub.fee.mapper.AuditorSetMapper;
import com.ejianc.business.zdsmaterial.sub.fee.service.IAuditorContractDetailService;
import com.ejianc.business.zdsmaterial.sub.fee.service.IAuditorSetService;
import com.ejianc.business.zdsmaterial.sub.fee.vo.AuditorContractDetailVO;
import com.ejianc.business.zdsmaterial.sub.fee.vo.AuditorSetVO;
import com.ejianc.business.zdsmaterial.sub.fee.vo.AuditorUserDetailVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="auditorSetService")
public class AuditorSetServiceImpl
extends BaseServiceImpl<AuditorSetMapper, AuditorSetEntity>
implements IAuditorSetService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IAuditorContractDetailService contractDetailService;
    @Autowired
    private ISubContractService contractService;

    @Override
    public CommonResponse<AuditorSetVO> saveOrUpdate(AuditorSetVO saveOrUpdateVO) {
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getContractDetailList())) {
            this.contractService.AuditorSetStatus(saveOrUpdateVO);
        }
        AuditorSetEntity entity = (AuditorSetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AuditorSetEntity.class));
        super.saveOrUpdate((Object)entity, false);
        CommonResponse<AuditorSetVO> proPickSettingVOCommonResponse = this.auditorSetByProjectId(entity.getProjectId());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)proPickSettingVOCommonResponse.getData());
    }

    @Override
    public CommonResponse<Boolean> queryContract(AuditorContractDetailVO detailVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)detailVO.getContractId());
        queryWrapper.eq((Object)"station_id", (Object)detailVO.getStationId());
        queryWrapper.eq((Object)"dr", (Object)0);
        int count = this.contractDetailService.count((Wrapper)queryWrapper);
        if (count > 0) {
            return CommonResponse.success((String)"\u8be5\u5408\u540c\u5728\u8be5\u5c97\u4f4d\u4e0b\u5df2\u5206\u914d\u4eba\u5458\uff01", (Object)false);
        }
        return CommonResponse.success((String)"\u8be5\u5408\u540c\u5728\u8be5\u5c97\u4f4d\u4e0b\u672a\u5206\u914d\u4eba\u5458\uff01", (Object)true);
    }

    @Override
    public List<Long> queryNotInContractId(AuditorContractDetailVO detailVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"station_id", (Object)detailVO.getStationId());
        queryWrapper.eq((Object)"user_id", (Object)detailVO.getStationId());
        queryWrapper.eq((Object)"dr", (Object)0);
        return null;
    }

    @Override
    public CommonResponse<AuditorSetVO> auditorSetByProjectId(Long projectId) {
        AuditorSetEntity entity = new AuditorSetEntity();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        List list = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            entity = (AuditorSetEntity)((Object)super.selectById((Serializable)((AuditorSetEntity)((Object)list.get(0))).getId()));
        } else {
            CommonResponse projectResp = this.projectPoolApi.queryProjectPoolById(projectId);
            this.logger.error("\u6839\u636e\u9879\u76eeId-{}\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u7ed3\u679c\uff0c{}", (Object)projectId, (Object)JSONObject.toJSONString((Object)projectResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            if (!projectResp.isSuccess() || ((JSONArray)projectResp.getData()).size() == 0) {
                return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38,\u672a\u67e5\u8be2\u5230\u5f53\u524d\u9879\u76ee\u4fe1\u606f\uff01");
            }
            ProjectPoolSetVO p = (ProjectPoolSetVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((JSONArray)projectResp.getData()).get(0)), ProjectPoolSetVO.class);
            entity.setProjectId(p.getId());
            entity.setProjectName(p.getName());
            entity.setProjectCode(p.getCode());
            entity.setOrgId(p.getProjectDepartmentId());
            entity.setOrgName(p.getProjectDepartmentName());
            entity.setOrgCode(p.getProjectDepartmentCode());
            entity.setParentOrgId(p.getOrgId());
            entity.setParentOrgName(p.getOrgName());
            entity.setParentOrgCode(p.getOrgCode());
            boolean bl = super.saveOrUpdate((Object)entity);
        }
        AuditorSetVO map = (AuditorSetVO)BeanMapper.map((Object)((Object)entity), AuditorSetVO.class);
        if (CollectionUtils.isNotEmpty((Collection)map.getUserDetailList())) {
            List userDetailList = map.getUserDetailList();
            List contractList = map.getContractDetailList();
            Map<Long, List<AuditorContractDetailVO>> collect = contractList.stream().collect(Collectors.groupingBy(e -> e.getUserDetailId()));
            for (AuditorUserDetailVO vo : userDetailList) {
                if (!CollectionUtils.isNotEmpty((Collection)contractList) || !collect.containsKey(vo.getRelationId())) continue;
                vo.getContractDetailList().addAll((Collection)collect.get(vo.getRelationId()));
            }
            map.setContractDetailList(null);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f!", (Object)map);
    }

    @Override
    public List<AuditorContractDetailEntity> subContractList(Long contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"station_code", (Object)"001");
        List list = this.contractDetailService.list((Wrapper)queryWrapper);
        return list;
    }
}

