/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.fee.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractEntity;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractService;
import com.ejianc.business.zdsmaterial.sub.fee.bean.SubFeeApplyDetailEntity;
import com.ejianc.business.zdsmaterial.sub.fee.bean.SubFeeApplyEntity;
import com.ejianc.business.zdsmaterial.sub.fee.mapper.SubFeeApplyMapper;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyService;
import com.ejianc.business.zdsmaterial.sub.fee.vo.SubFeeApplyVO;
import com.ejianc.business.zdsmaterial.util.BillLockUtil;
import com.ejianc.business.zdsmaterial.util.CommonUtils;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import com.ejianc.business.zdsmaterial.util.MsgSendUtil;
import com.ejianc.business.zdssupplier.sub.api.ISubLinkerApi;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="subFeeApplyService")
public class SubFeeApplyServiceImpl
extends BaseServiceImpl<SubFeeApplyMapper, SubFeeApplyEntity>
implements ISubFeeApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE = "EJCBT202403000001";
    private static final String BILL_NAME = "\u5206\u5305\u8d39\u7528\u7533\u8bf7";
    private static final String supSignFileSourceType = "signature";
    private static final String PUSH_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/subFeeApply/saveSyncBill";
    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/subFeeApply/supSignSync";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISubContractService contractService;
    @Autowired
    private ISubLinkerApi linkerApi;
    @Autowired
    private MsgSendUtil msgSendUtil;
    @Autowired
    private SubFeeApplyMapper mapper;
    @Autowired
    private IEmployeeApi employeeApi;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long pushBillToSupCenter(SubFeeApplyEntity entity) {
        Long sourceId = null;
        try {
            BillLockUtil.getLock(BILL_TYPE, entity.getId());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            SubFeeApplyVO vo = (SubFeeApplyVO)BeanMapper.map((Object)((Object)entity), SubFeeApplyVO.class);
            paramMap.put("transData", JSONObject.toJSONString((Object)vo));
            paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(new HashMap()));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, null, null);
            HashMap files = new HashMap();
            if (fileResp.isSuccess()) {
                List fileList = (List)fileResp.getData();
                HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }
            } else {
                this.logger.error("\u83b7\u53d6\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)entity.getId(), (Object)fileResp.getMsg());
            }
            this.logger.info("\u5411\u4f9b\u65b9-{}\u63a8\u9001\u5355\u636e\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
            CommonResponse syncResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL, paramMap, String.valueOf(entity.getSupplierId()), files);
            if (syncResp.isSuccess()) {
                CommonResponse resp = (CommonResponse)JSONObject.parseObject((String)((String)syncResp.getData()), CommonResponse.class);
                if (resp.isSuccess()) {
                    sourceId = Long.valueOf((String)resp.getData());
                    return sourceId;
                }
                this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), resp.getMsg()});
                throw new BusinessException(resp.getMsg());
            }
            this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{entity.getId(), entity.getSupplierId(), syncResp.getMsg()});
            return sourceId;
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{entity.getId(), entity.getSupplierId(), e});
            throw new BusinessException(e.getMessage());
        }
        finally {
            BillLockUtil.releaseLock(BILL_TYPE, entity.getId());
        }
    }

    @Override
    public Long saveSyncBill(HttpServletRequest request) {
        this.logger.info("\u8fdb\u5165\u4fdd\u5b58\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>");
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        this.logger.info("\u63a5\u6536\u5230\u6570\u636etransData\uff1a{}\uff0cnameSourceTypeMapping\uff1a{}", (Object)transData, (Object)nameSourceTypeMapping);
        SubFeeApplyVO vo = (SubFeeApplyVO)JSONObject.parseObject((String)transData, SubFeeApplyVO.class);
        if (vo == null || vo.getId() == null) {
            throw new BusinessException("\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("sourceId", new Parameter("eq", (Object)vo.getId()));
        param.getParams().put("billState", new Parameter("not_in", (Object)"1,3"));
        param.getParams().put("applyType", new Parameter("ne", (Object)String.valueOf(PlanConstant.APPLY_TYPE_BACK)));
        List list = super.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.logger.info("\u5b58\u5728\u76f8\u540csourceID\u7684\u6570\u636e\uff0c\u539f\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)list));
        }
        this.validateApplying(vo);
        this.validateApplyMny(vo);
        SubFeeApplyEntity saveEntity = (SubFeeApplyEntity)((Object)BeanMapper.map((Object)vo, SubFeeApplyEntity.class));
        saveEntity.setSourceId(saveEntity.getId());
        saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        saveEntity.setApplyType(String.valueOf(PlanConstant.APPLY_TYPE_UN_PROJECT));
        EmployeeVO craetor = null;
        if (null != saveEntity.getAuditWorkerId()) {
            CommonResponse creatorResp = this.employeeApi.getById(saveEntity.getAuditWorkerId());
            if (!creatorResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u5206\u5305\u8d39\u7528\u7533\u8bf7\u4eba-{}\u4fe1\u606f\u5931\u8d25,{}", (Object)saveEntity.getAuditWorkerId(), (Object)JSONObject.toJSONString((Object)creatorResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u67e5\u8be2\u8d39\u7528\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25!");
            }
            if (null == creatorResp.getData()) {
                this.logger.error("\u67e5\u8be2\u5206\u5305\u8d39\u7528\u7533\u8bf7\u4eba-{}\u4fe1\u606f\u4e3a\u7a7a,{}", (Object)saveEntity.getAuditWorkerId(), (Object)JSONObject.toJSONString((Object)creatorResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u67e5\u8be2\u8d39\u7528\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25!");
            }
            craetor = (EmployeeVO)creatorResp.getData();
        }
        CommonUtils.clearInvalidData(saveEntity);
        saveEntity.setCreateUserId(craetor.getId());
        saveEntity.setCreateUserCode(craetor.getCode());
        for (SubFeeApplyDetailEntity detail : saveEntity.getDetailList()) {
            detail.setSourceId(detail.getApplyId());
            detail.setSourceDetailId(detail.getId());
            CommonUtils.clearInvalidData(detail);
            detail.setCreateUserCode(craetor.getCode());
        }
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)saveEntity.getSourceId(), (Object)ejcCloudSystemCode.getMsg());
        }
        saveEntity.setSystemId((String)ejcCloudSystemCode.getData());
        Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, null);
        ArrayList attchIdsList = new ArrayList();
        for (List attachIds : attachIdsMap.values()) {
            if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
            attchIdsList.addAll(attachIds);
        }
        saveEntity.setAttachIds(attchIdsList);
        super.saveOrUpdate((Object)saveEntity, false);
        this.sendEmail(saveEntity);
        this.logger.info("\u4fdd\u5b58\u63a5\u53e3\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return saveEntity.getId();
    }

    private void sendEmail(SubFeeApplyEntity entity) {
        if (null == entity.getCompileId()) {
            return;
        }
        StringBuilder content = new StringBuilder();
        content.append("\u3010" + entity.getBillCode() + "\u3011\uff0c\u3010" + entity.getProjectName() + "\u3011\uff0c\u3010");
        content.append(entity.getContractName() + "\u3011\uff0c\u3010" + entity.getSupplierName() + "\u3011\u63d0\u4ea4\u4e86\u8d39\u7528\u7533\u8bf7\uff0c\u8bf7\u60a8\u5ba1\u6838\uff01");
        StringBuilder subject = new StringBuilder();
        subject.append("\u3010\u5de5\u7a0b\u91cf\u5ba1\u6838\u3011\uff0c\u3010" + entity.getBillCode() + "\u3011\uff0c\u3010" + DateUtil.formatSeconds(new Date()) + "\u3011\u9700\u8981\u60a8\u5ba1\u6838\uff01");
        String pcUrl = "ejc-zdsmaterial-frontend/#/subCostApply?id=" + entity.getId() + "&userid=" + entity.getCompileId() + "&tenantId=" + entity.getTenantId();
        this.msgSendUtil.sendEmail(new String[]{String.valueOf(entity.getCompileId())}, "\u5de5\u7a0b\u91cf\u5ba1\u6838", subject.toString(), content.toString(), null, pcUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636eparameters\uff1a{}", (Object)JSONObject.toJSONString((Object)request.getParameterMap()));
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        String applyType = request.getParameter("applyType");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        SubFeeApplyEntity entity = (SubFeeApplyEntity)((Object)super.selectById((Serializable)((Object)billId)));
        entity.setSupOperateTime(supOperateTime);
        entity.setSupOperatorName(supOperatorName);
        entity.setSupOperatorPhone(supOperatorPhone);
        entity.setSupOperatorUserCode(supOperatorUserCode);
        entity.setApplyType(applyType);
        try {
            BillLockUtil.getLock(BILL_TYPE, entity.getId());
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, entity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            entity.setAttachIds(attchIdsList);
            super.saveOrUpdate((Object)entity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u66f4\u65b0\u72b6\u6001\u56de\u5199\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
            String string = "\u5355\u636e\u66f4\u65b0\u72b6\u6001\u56de\u5199\u5931\u8d25\uff01";
            return string;
        }
        finally {
            BillLockUtil.releaseLock(BILL_TYPE, entity.getId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateApplyType(SubFeeApplyVO vo) {
        UserContext user = this.sessionManager.getUserContext();
        this.logger.info("\u7528\u6237{}\u5bf9\u5355\u636eid-{}\u8fdb\u884c\u66f4\u65b0\u72b6\u6001\u64cd\u4f5c\uff01", (Object)user.getUserName(), (Object)vo.getId());
        SubFeeApplyEntity entity = (SubFeeApplyEntity)((Object)super.selectById((Serializable)vo.getId()));
        entity.setSupOperateTime(new Date());
        entity.setSupOperatorPhone(user.getUserMobile());
        entity.setSupOperatorName(user.getUserName());
        entity.setSupOperatorUserCode(user.getUserCode());
        entity.setApplyType(vo.getApplyType());
        Long partyContactsId = null;
        if (PlanConstant.APPLY_TYPE_BACK.equals(Integer.valueOf(entity.getApplyType()))) {
            CommonResponse linker;
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            if (null != entity.getPartyContactsId() && (linker = this.linkerApi.getOneById(entity.getPartyContactsId())).isSuccess() && null != linker.getData()) {
                partyContactsId = ((LinkerVO)linker.getData()).getSupUserId();
            }
        }
        try {
            Object fileResp;
            BillLockUtil.getLock(BILL_TYPE, entity.getId());
            HashMap files = new HashMap();
            HashMap<String, String> nameSourceTypeMapping = new HashMap<String, String>();
            if (PlanConstant.APPLY_TYPE_COMMIT.equals(vo.getApplyType())) {
                CommonResponse attachsResp = this.attachmentApi.queryListBySourceId(vo.getId(), BILL_TYPE, supSignFileSourceType, null);
                if (!attachsResp.isSuccess()) {
                    this.logger.error("\u67e5\u8be2id-{}\u5355\u636e\u7c7b\u578b-{}\u5f53\u524d\u7b7e\u5b57\u6587\u4ef6-{},\u4fe1\u606f\u5931\u8d25\uff0c {}", new Object[]{vo.getId(), BILL_TYPE, supSignFileSourceType, attachsResp.getMsg()});
                    String string = "\u67e5\u8be2\u7b7e\u5b57\u6587\u4ef6\u4fe1\u606f\u5931\u8d25!";
                    return string;
                }
                if (CollectionUtils.isEmpty((Collection)((Collection)attachsResp.getData()))) {
                    this.logger.info("\u67e5\u8be2id-{}\u5355\u636e\u7c7b\u578b-{}\u5f53\u524d\u7b7e\u5b57\u6587\u4ef6-{}\u4e3a\u7a7a", new Object[]{vo.getId(), BILL_TYPE, supSignFileSourceType});
                    String string = "\u6ca1\u627e\u5230\u5339\u914d\u7684\u7b7e\u5b57\u6587\u4ef6";
                    return string;
                }
                AttachmentVO supSignFile = ((List)attachsResp.getData()).stream().findFirst().orElse(new AttachmentVO());
                fileResp = this.attachmentApi.downloadFileById(supSignFile.getId());
                HashMap<String, InputStream> signFile = new HashMap<String, InputStream>();
                if (supSignFile.getId() != null) {
                    signFile.put(supSignFile.getFileName(), fileResp.body().asInputStream());
                    files.put(supSignFile.getFileName(), signFile);
                    nameSourceTypeMapping.put(supSignFile.getFileName(), supSignFile.getSourceType());
                }
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("nameSourceTypeMapping", JSONObject.toJSONString(nameSourceTypeMapping));
            params.put("billId", String.valueOf(entity.getSourceId()));
            params.put("supOperatorName", entity.getSupOperatorName());
            params.put("supOperatorPhone", entity.getSupOperatorPhone());
            params.put("supOperatorUserCode", entity.getSupOperatorUserCode());
            params.put("supOperateTime", String.valueOf(entity.getSupOperateTime().getTime()));
            params.put("applyType", entity.getApplyType());
            params.put("partyContactsId", CommonUtils.createString(partyContactsId));
            this.logger.info("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\uff0c\u901a\u77e5\u5355\u636e\u63a8\u9001\u65b9systemId-{},\u53c2\u6570-{}", new Object[]{BILL_NAME, entity.getId(), entity.getSystemId(), JSONObject.toJSONString(params)});
            CommonResponse backResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_WITER_BACK_SERVER_URL, params, entity.getSupplierId().toString(), files);
            this.logger.error("\u5355\u636e-{}\u66f4\u65b0\u72b6\u6001\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)BILL_NAME, (Object)JSONObject.toJSONString((Object)backResp));
            if (!backResp.isSuccess()) {
                this.logger.error("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", new Object[]{BILL_NAME, entity.getId(), backResp.getMsg()});
                fileResp = "\u5206\u5305\u8d39\u7528\u7533\u8bf7\u66f4\u65b0\u72b6\u6001\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u5931\u8d25";
                return fileResp;
            }
            if ("\u65e0\u6743\u9650\u8bbf\u95ee\u8be5\u670d\u52a1\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\uff01".equals(backResp.getData())) {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42URL-{}\u7ed9\u7cfb\u7edf-{}\u5931\u8d25, {}", new Object[]{BILL_WITER_BACK_SERVER_URL, entity.getSystemId(), backResp.getData()});
                fileResp = (String)backResp.getData();
                return fileResp;
            }
            CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)((String)backResp.getData()), CommonResponse.class);
            if (!operateResp.isSuccess()) {
                this.logger.error("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\u56de\u8c03\u5904\u7406\u5931\u8d25\uff0c{}", new Object[]{BILL_NAME, entity.getId(), operateResp.getMsg()});
                String string = "\u66f4\u65b0\u72b6\u6001\u56de\u8c03\u5904\u7406\u5931\u8d25";
                return string;
            }
            super.saveOrUpdate((Object)entity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\u5f02\u5e38\uff0c", new Object[]{BILL_NAME, entity.getId(), e});
            String string = "\u64cd\u4f5c\u5931\u8d25\uff01";
            return string;
        }
        finally {
            BillLockUtil.releaseLock(BILL_TYPE, entity.getId());
        }
        return null;
    }

    @Override
    public Boolean validateApplying(SubFeeApplyVO vo) {
        List<SubContractEntity> contList = this.contractService.getAllBySourceIds(new ArrayList<String>(Arrays.asList(vo.getSourceContractId())));
        Boolean flag = contList.stream().anyMatch(x -> PlanConstant.INTEGER_YES.equals(x.getIsApply()));
        if (flag.booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5728ERP\u7cfb\u7edf\u4e2d\u5b58\u5728\u7533\u8bf7\u4e2d\u5206\u5305\u8d39\u7528\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u53d1\u8d77\u7533\u8bf7!");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)vo.getContractId()));
        param.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        param.getParams().put("applyType", new Parameter("not_in", (Object)"0,4,6"));
        List list = super.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Set billCodes = list.stream().map(SubFeeApplyEntity::getBillCode).collect(Collectors.toSet());
            throw new BusinessException("\u8be5\u5408\u540c\u5728PM\u7cfb\u7edf\u4e2d\u5b58\u5728\u7533\u8bf7\u4e2d\u5206\u5305\u8d39\u7528\u5355\u3010" + StringUtils.join(billCodes, (String)",") + "\u3011\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u53d1\u8d77\u7533\u8bf7!");
        }
        return true;
    }

    @Override
    public Boolean validateApplyMny(SubFeeApplyVO vo) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)vo.getContractId()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List list = super.queryList(param);
        BigDecimal lastMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            lastMny = list.stream().map(x -> x.getApplyMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        }
        BigDecimal sumMny = ComputeUtil.safeAdd((BigDecimal)lastMny, (BigDecimal)vo.getApplyMny());
        if (ComputeUtil.isNotEmpty((BigDecimal)vo.getSettleSumMoney()).booleanValue()) {
            if (ComputeUtil.isGreaterThan((BigDecimal)sumMny, (BigDecimal)vo.getSettleSumMoney())) {
                throw new BusinessException("\u622a\u6b62\u672c\u671f\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d\u5927\u4e8e\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u7533\u8bf7!");
            }
        } else {
            BigDecimal contMny = ComputeUtil.safeAdd((BigDecimal)vo.getContractMoney(), (BigDecimal)vo.getFuJiaMoney());
            if (ComputeUtil.isGreaterThan((BigDecimal)sumMny, (BigDecimal)contMny)) {
                throw new BusinessException("\u622a\u6b62\u672c\u671f\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d\u5927\u4e8e\u4e3b\u5408\u540c+\u9644\u52a0\u5408\u540c\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u7533\u8bf7!");
            }
        }
        return true;
    }

    @Override
    public int pageCount(Map<String, Object> queryParam) {
        return this.mapper.pageCount(queryParam);
    }

    @Override
    public List<JSONObject> pageList(Map<String, Object> queryParam) {
        return this.mapper.pageList(queryParam);
    }

    @Override
    public BigDecimal thisYearApplyMny(Long linkerId, String linkerSid, Long supplierId) {
        return this.mapper.thisYearApplyMny(linkerId, linkerSid, supplierId);
    }
}

