/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleEntity;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleRecordEntity;
import com.ejianc.business.zdsmaterial.sub.settle.service.ISubSettleRecordService;
import com.ejianc.business.zdsmaterial.sub.settle.service.ISubSettleService;
import com.ejianc.business.zdssupplier.sub.api.ISubLinkerApi;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="subSettle")
public class SubSettleBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISubSettleService subSettleService;
    @Autowired
    private ISubSettleRecordService subSettleRecordService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubLinkerApi linkerApi;
    @Value(value="${eachLink.host}")
    private String host;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u63d0\u4ea4\u524d\u56de\u8c03");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u63d0\u4ea4\u5b8c\u56de\u8c03afterSubmitProcessor");
        SubSettleRecordEntity subSettleRecordEntity = new SubSettleRecordEntity();
        subSettleRecordEntity.setSettleStatus(ZDSMaterialCommonEnums.\u4e1a\u52a1\u73af\u8282_\u53d1\u9001\u6307\u4ee4.getCode());
        subSettleRecordEntity.setSettleId(billId);
        UserContext userContextCache = this.sessionManager.getUserContext();
        subSettleRecordEntity.setEmployeeId(userContextCache.getUserId());
        subSettleRecordEntity.setEmployeeName(userContextCache.getUserName());
        subSettleRecordEntity.setEmployeeCode(userContextCache.getUserCode());
        this.subSettleRecordService.save((Object)subSettleRecordEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u524d\u56de\u8c03");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u540e\u56de\u8c03");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        this.logger.info("\u5ba1\u6279\u8282\u70b9\u5ba1\u6279\u4e2d\u65f6\u8282\u70b9\u5ba1\u6279\u524d\u56de\u8c03");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03");
        return CommonResponse.success();
    }

    @Transactional
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03");
        SubSettleEntity entity = (SubSettleEntity)((Object)this.subSettleService.selectById(billId));
        entity.setFillStatus(1);
        this.subSettleService.updateById((Object)entity);
        this.subSettleService.pushSubSettleBill(entity);
        if (state == 1) {
            SubSettleRecordEntity subSettleRecordEntity = new SubSettleRecordEntity();
            subSettleRecordEntity.setSettleStatus(ZDSMaterialCommonEnums.\u4e1a\u52a1\u73af\u8282_\u53d1\u9001\u6307\u4ee4.getCode());
            subSettleRecordEntity.setSettleId(billId);
            UserContext userContextCache = this.sessionManager.getUserContext();
            subSettleRecordEntity.setEmployeeId(userContextCache.getUserId());
            subSettleRecordEntity.setEmployeeName(userContextCache.getUserName());
            subSettleRecordEntity.setEmployeeCode(userContextCache.getUserCode());
            this.subSettleRecordService.save((Object)subSettleRecordEntity);
        }
        PushMsgParameter pushMsgParameter = new PushMsgParameter();
        String subject = "\u3010\u4e2d\u7535\u56db\u5206\u5305\u7ed3\u7b97\u901a\u77e5\u3011\uff0c\u3010" + entity.getBillCode() + "\u3011\uff0c\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u9700\u8981\u60a8\u5ba1\u6838\uff01";
        pushMsgParameter.setSubject(subject);
        String contentSub = "\u3010" + entity.getProjectName() + "\u9879\u76ee\u3011\uff0c-\u3010" + entity.getSubContractName() + "\u5408\u540c\u3011\uff0c\u3010" + entity.getSupplierName() + "\u3011\u5408\u540c\u5df2\u53d1\u9001\u7ed3\u7b97\u901a\u77e5\uff0c\u8bf7\u5c3d\u5feb\u767b\u5f55\u5206\u4f9b\u65b9\u5e73\u53f0\uff01 " + this.host + "ejc-zdssupbusiness-frontend/#/subSettle/card?id=" + entity.getId().toString() + "\u5730\u5740";
        pushMsgParameter.setContent(contentSub);
        pushMsgParameter.setPcUrl(this.host + "ejc-zdssupbusiness-frontend/#/subSettle/card?id=" + entity.getId().toString());
        CommonResponse linkerResponse = this.linkerApi.getOneById(entity.getSubLinkId());
        if (!linkerResponse.isSuccess()) {
            this.logger.info("\u67e5\u8be2\u5206\u5305\u8054\u7cfb\u4eba\u7f51\u7edc\u5f02\u5e38", (Object)linkerResponse.getMsg());
            throw new BusinessException("\u67e5\u8be2\u5206\u5305\u8054\u7cfb\u4eba\u7f51\u7edc\u5f02\u5e38!");
        }
        LinkerVO linkerVO = (LinkerVO)linkerResponse.getData();
        JSONObject params = new JSONObject();
        params.put("userEmails", (Object)linkerVO.getElectronicMail());
        params.put("userNames", (Object)linkerVO.getUserName());
        pushMsgParameter.setZdsExtEmailParams(params);
        String[] recId = new String[]{entity.getSubLinkId().toString()};
        pushMsgParameter.setReceivers(recId);
        this.sendMsg(pushMsgParameter, entity.getId(), "\u7ed3\u7b97\u6307\u4ee4\u5355\u5411\u5206\u5305\u8054\u7cfb\u4eba\u53d1\u9001\u90ae\u4ef6");
        return CommonResponse.success();
    }

    public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{"email"});
        CommonResponse sendResp = this.pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            this.logger.error("{}-\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u5355\u636eId-{}\uff0c\u53d1\u9001\u90ae\u4ef6\u7ed3\u679c-{}", new Object[]{oprMsg, billId, JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
        } else {
            this.logger.info("{}-\u53d1\u9001\u90ae\u4ef6\u6210\u529f\uff01", (Object)oprMsg);
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5f03\u5ba1\u524d\u4e8b\u4ef6\u56de\u8c03");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03");
        return CommonResponse.error((String)"\u8be5\u529f\u80fd\u4e0d\u652f\u6301!");
    }
}

