/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.util;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.file.vo.UploadFileForNetParam;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.ByteArrayInputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PushFileUtil<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value(value="${eachLink.host}")
    private String host;

    public String uploadFileByUrl(String url, String sourceId, String billType, String sourceType, String authority) {
        Object downloadFileStr = null;
        try {
            this.logger.info("\u6839\u636e\u9644\u4ef6\u5730\u5740:{}", (Object)url);
            if (StringUtils.isEmpty((CharSequence)url)) {
                this.logger.error("sourceId-{}\u7684url\u4e3a\u7a7a\uff01", (Object)sourceId);
                return null;
            }
            HttpResponse response = HttpUtil.createGet((String)url).executeAsync();
            HashMap<String, ByteArrayInputStream> resp = new HashMap<String, ByteArrayInputStream>();
            String fileName = response.header("Content-Disposition").split(";")[1].split("=")[1];
            fileName = URLDecoder.decode(fileName, "UTF-8");
            resp.put(fileName, new ByteArrayInputStream(response.bodyBytes()));
            this.logger.info("\u6839\u636e\u9644\u4ef6\u5730\u5740\uff1a{} \u4e0b\u8f7d\u9644\u4ef6\u6210\u529f:{}", (Object)url, (Object)fileName);
            HashMap files = new HashMap();
            resp.keySet().stream().forEach(fileKey -> {
                HashMap file = new HashMap(1);
                file.put((String)fileKey, resp.get(fileKey));
                files.put(fileKey, file);
            });
            List attachmentVOS = FileUtil.getInstance().upFile(sourceType, sourceId, billType, files, authority);
            if (CollectionUtils.isNotEmpty((Collection)attachmentVOS)) {
                AttachmentVO vo = (AttachmentVO)attachmentVOS.get(0);
                return vo.getFilePath();
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u9644\u4ef6\u5730\u5740\u4e0b\u8f7d\u9644\u4ef6\u5931\u8d25:{}", (Throwable)e);
            e.printStackTrace();
        }
        return null;
    }

    public List<Long> uploadFileFormNet(List<AttachmentVO> fileList, String billType) {
        return this.uploadFileFormNet(fileList, billType, IdWorker.getId(), null);
    }

    public List<Long> uploadFileFormNet(List<AttachmentVO> fileList, String billType, Long sourceId, String sourceType) {
        fileList.removeAll(Collections.singleton(null));
        if (CollectionUtils.isEmpty(fileList)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> attachIds = new ArrayList<Long>();
        for (AttachmentVO file : fileList) {
            UploadFileForNetParam param = new UploadFileForNetParam();
            param.setTenantId(InvocationInfoProxy.getTenantid());
            param.setBillType(billType);
            param.setSourceId(sourceId);
            param.setSourceType(StringUtils.isNotBlank((CharSequence)sourceType) ? sourceType : file.getSourceType());
            String url = this.host + "/filepreview/" + file.getFilePath();
            param.setFilePathList(Collections.singletonList(url));
            Long id = IdWorker.getId();
            param.setNewFileIds(Collections.singletonList(id));
            CommonResponse resp = this.attachmentApi.uploadFileFormNet(param);
            if (!resp.isSuccess()) {
                this.logger.error("\u53c2\u6570-{},\u9644\u4ef6\u4e0a\u4f20\u5f02\u5e38-{}", (Object)JSONObject.toJSONString((Object)param), (Object)resp.getMsg());
            }
            attachIds.add(id);
        }
        return attachIds;
    }

    public Long uploadFileFormNet(String billType, Long sourceId, String sourceType, Long fileId) {
        if (null == sourceId) {
            sourceId = IdWorker.getId();
        }
        return this.uploadFileFormNet(billType, sourceId, sourceType, this.getattachById(fileId));
    }

    public Long uploadFileFormNet(String billType, Long sourceId, String sourceType, AttachmentVO attach) {
        if (null == attach) {
            return null;
        }
        UploadFileForNetParam param = new UploadFileForNetParam();
        param.setTenantId(InvocationInfoProxy.getTenantid());
        param.setBillType(billType);
        param.setSourceId(sourceId);
        param.setSourceType(sourceType);
        String url = this.host + "/filepreview/" + attach.getFilePath();
        param.setFilePathList(Collections.singletonList(url));
        Long id = IdWorker.getId();
        param.setNewFileIds(Collections.singletonList(id));
        param.setNewFileNames(Collections.singletonList(attach.getFileName()));
        CommonResponse resp = this.attachmentApi.uploadFileFormNet(param);
        if (!resp.isSuccess()) {
            this.logger.error("\u53c2\u6570-{},\u9644\u4ef6\u4e0a\u4f20\u5f02\u5e38-{}", (Object)JSONObject.toJSONString((Object)param), (Object)resp.getMsg());
        }
        this.logger.info("\u53c2\u6570-{},\u9644\u4ef6\u4e0a\u4f20\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)param), resp.getData());
        return id;
    }

    public Long uploadFileFormNet(String billType, Long sourceId, String sourceType, String filePath) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        UploadFileForNetParam param = new UploadFileForNetParam();
        param.setTenantId(InvocationInfoProxy.getTenantid());
        param.setBillType(billType);
        param.setSourceId(sourceId);
        param.setSourceType(sourceType);
        String url = this.host + "/filepreview/" + filePath;
        param.setFilePathList(Collections.singletonList(url));
        Long id = IdWorker.getId();
        param.setNewFileIds(Collections.singletonList(id));
        CommonResponse resp = this.attachmentApi.uploadFileFormNet(param);
        if (!resp.isSuccess()) {
            this.logger.error("\u53c2\u6570-{},\u9644\u4ef6\u4e0a\u4f20\u5f02\u5e38-{}", (Object)JSONObject.toJSONString((Object)param), (Object)resp.getMsg());
        }
        this.logger.info("\u53c2\u6570-{},\u9644\u4ef6\u4e0a\u4f20\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)param), resp.getData());
        return id;
    }

    public String getFilePath(Long attachid) {
        AttachmentVO result = this.getattachById(attachid);
        return result.getFilePath();
    }

    public AttachmentVO getattachById(Long attachid) {
        String url = this.host + "/ejc-file-web/attachment/no_auth/getattachById";
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("attachid", attachid);
        try {
            String responseStr = HttpTookit.getAndHeader((String)url, params);
            this.logger.info("attachid-{},\u9644\u4ef6\u67e5\u8be2\u7ed3\u679c-{}", (Object)attachid, (Object)responseStr);
            CommonResponse resp = (CommonResponse)JSON.parseObject((String)responseStr, (TypeReference)new TypeReference<CommonResponse<AttachmentVO>>(){}, (Feature[])new Feature[0]);
            if (!resp.isSuccess()) {
                throw new BusinessException(resp.getMsg());
            }
            if (null == resp.getData()) {
                return new AttachmentVO();
            }
            return (AttachmentVO)resp.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("attachid-{},\u9644\u4ef6\u67e5\u8be2\u5f02\u5e38-{}", (Object)attachid, (Object)e.getMessage());
            return new AttachmentVO();
        }
    }

    public List<AttachmentVO> queryListBySourceId(Long sourceId, String sourceType) {
        String url = this.host + "/ejc-file-web/no_auth/api/attachref/queryListBySourceId";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sourceId", sourceId);
        params.put("sourceType", sourceType);
        try {
            String responseStr = HttpTookit.getAndHeader((String)url, params);
            this.logger.info("sourceId-{},sourceType-{},\u9644\u4ef6\u67e5\u8be2\u7ed3\u679c-{}", new Object[]{sourceId, sourceType, responseStr});
            CommonResponse resp = (CommonResponse)JSON.parseObject((String)responseStr, (TypeReference)new TypeReference<CommonResponse<List<AttachmentVO>>>(){}, (Feature[])new Feature[0]);
            if (!resp.isSuccess()) {
                throw new BusinessException(resp.getMsg());
            }
            return (List)resp.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("sourceId-{},sourceType-{},\u9644\u4ef6\u67e5\u8be2\u5f02\u5e38-{}", new Object[]{sourceId, sourceType, e.getMessage()});
            return new ArrayList<AttachmentVO>();
        }
    }

    public Long getFileId(Long sourceId, String billType, String sourceType, Long fileId) {
        CommonResponse fileResp = this.attachmentApi.queryListBySourceId(sourceId, billType, sourceType, null);
        if (!fileResp.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)fileResp.getData()))) {
            this.logger.error("\u83b7\u53d6billType-{},sourceId-{},sourceType-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", new Object[]{billType, sourceId, sourceType, fileResp.getMsg()});
            Long newId = this.uploadFileFormNet(billType, sourceId, sourceType, fileId);
            return newId;
        }
        List fileList = (List)fileResp.getData();
        return ((AttachmentVO)fileList.get(0)).getId();
    }

    public static String createString(Object object) {
        if (object == null) {
            return "";
        }
        return String.valueOf(object);
    }

    public static String clearBracket(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return content;
        }
        String pattern = "\\([^)]*\\)";
        content = content.replaceAll(pattern, "");
        return content;
    }
}

