package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceEntity;
import com.ejianc.business.zdsmaterial.erp.service.IContractManagerService;
import com.ejianc.business.zdsmaterial.erp.service.IContractService;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceService;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceDetailEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceFileEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceOcrEntity;
import com.ejianc.business.zdsmaterial.material.service.IMatCheckerSettingService;
import com.ejianc.business.zdsmaterial.material.service.IMatInvoiceFileService;
import com.ejianc.business.zdsmaterial.material.service.IMatInvoiceOcrService;
import com.ejianc.business.zdsmaterial.material.service.IMatInvoiceService;
import com.ejianc.business.zdsmaterial.material.vo.MatInvoiceDetailVO;
import com.ejianc.business.zdsmaterial.material.vo.MatInvoiceOcrVO;
import com.ejianc.business.zdsmaterial.material.vo.MatInvoiceVO;
import com.ejianc.business.zdsmaterial.util.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.usercenter.api.IFaceAndIdCardService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 采购发票登记
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("matInvoice")
public class MatInvoiceController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "MAT_INVOICE";

    @Autowired
    private IMatInvoiceService service;

    @Autowired
    private IErpInvoiceDetailService erpInvoiceDetailService;

    @Autowired
    private IFaceAndIdCardService faceAndIdCardService;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IErpInvoiceService invoiceService;

    private final String COMPANY_SOCIAL_CODE = "company_social_code";

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IMatInvoiceFileService detailFileService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IMatInvoiceOcrService matInvoiceOcrService;

    @Autowired
    private IContractManagerService contractManagerService;

    @Autowired
    private IMatCheckerSettingService matCheckerSettingService;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private SessionManager sessionManager;

    @PostMapping(value = "changeAdminEmp")
    @ResponseBody
    public CommonResponse<String> changeAdminEmp(@RequestBody JSONObject changeParam) {
        logger.info("*****************采购发票转签：{}", changeParam.toJSONString());
        String changeRs = service.changeAminEmp(changeParam);
        if(StringUtils.isNotBlank(changeRs)) {
            return CommonResponse.error(changeRs);
        }
        return CommonResponse.success("操作成功！");
    }

    @PostMapping(value = "getBatchDownloadParams")
    @ResponseBody
    public CommonResponse<JSONObject> getBatchDownloadParams(@RequestBody List<Long> billIds) {
        JSONObject resp = new JSONObject();
        Map<String, String> fileDirName = new HashMap<>();
        List<MatInvoiceEntity> invoiceList = (List<MatInvoiceEntity>) service.listByIds(billIds);
        List<MatInvoiceFileEntity> detailFileList = detailFileService.getAllByPids(billIds);
        List<MatInvoiceOcrEntity> detailOcrFileList = matInvoiceOcrService.getAllByPids(billIds);

        fileDirName.putAll(invoiceList.stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item.getBillCode())));
        if(CollectionUtils.isNotEmpty(detailFileList)) {
            detailFileList.stream().filter(item -> fileDirName.containsKey(item.getMainId().toString())).forEach(item -> {
                fileDirName.put(item.getId().toString(), fileDirName.get(item.getMainId().toString()));
            });
        }
        if(CollectionUtils.isNotEmpty(detailOcrFileList)) {
            detailOcrFileList.stream().filter(item -> fileDirName.containsKey(item.getMainId().toString())).forEach(item -> {
                fileDirName.put(item.getId().toString(), fileDirName.get(item.getMainId().toString()));
            });
        }

        resp.put("sourceIds", fileDirName.keySet().stream().collect(Collectors.joining(",")));
        resp.put("fileDirName", JSONObject.toJSONString(fileDirName));


        return CommonResponse.success("查询成功！",resp);
    }

    /**
     * 单据附件转图片
     * @param billids
     * @return
     */
    @PostMapping(value = "billFileToImg")
    @ResponseBody
    public CommonResponse<List<AttachmentVO>> billFileToImg(@RequestBody List<Long> billids) {
        List<MatInvoiceFileEntity> detailFileList = detailFileService.getAllByPids(billids);
        List<Long> detailIds = detailFileList.stream().filter(item -> null != item.getFileId()).map(MatInvoiceFileEntity::getId).collect(Collectors.toList());

        List<MatInvoiceOcrEntity> detailOcrFileList = matInvoiceOcrService.getAllByPids(billids);
        if(CollectionUtils.isNotEmpty(detailOcrFileList)) {
            detailIds.addAll(detailOcrFileList.stream().map(MatInvoiceOcrEntity::getId).collect(Collectors.toList()));
        }
        JSONObject param = new JSONObject();
        param.put("sourceIds", detailIds.stream().map(item -> item.toString()).collect(Collectors.joining(",")));

        return attachmentApi.pdfFileToImg(param);
    }

    /**
     * 根据主表Id查询当前单据要打印的附件信息
     * @param ids
     * @return
     */
    @PostMapping(value = "queryAllPrintFile")
    @ResponseBody
    public CommonResponse<Map<String, List<String>>> queryAllPrintFile(@RequestBody List<Long> ids) {
        List<MatInvoiceFileEntity> detailFileList = detailFileService.getAllByPids(ids);
        List<Long> subIds = new ArrayList<>();
        Map<Long, Long> pidIdMap = detailFileList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item.getMainId()));
        List<Long> detailIds = detailFileList.stream().filter(item -> null != item.getFileId()).map(MatInvoiceFileEntity::getId).collect(Collectors.toList());
        subIds.addAll(detailIds);
        detailIds.addAll(ids);
        JSONObject params = new JSONObject();

        List<AttachmentVO> fileList = null;

        List<MatInvoiceOcrEntity> detailOcrFileList = matInvoiceOcrService.getAllByPids(ids);
        Map<Long, Long> ocrFileIdMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(detailOcrFileList)) {
            ocrFileIdMap.putAll(detailOcrFileList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item.getMainId())));
            detailIds.addAll(ocrFileIdMap.keySet());
            subIds.addAll(ocrFileIdMap.keySet());
        }

        //检查文件
        JSONObject param = new JSONObject();
        param.put("sourceIds", subIds.stream().map(item -> item.toString()).collect(Collectors.joining(",")));
        CommonResponse<List<AttachmentVO>> attachCheckResp =  attachmentApi.pdfFileToImg(param);

        params.put("sourceIds", JSONObject.toJSONString(detailIds));
        CommonResponse<List<AttachmentVO>> attachResp =  attachmentApi.queryAllBySourceIdList(params);
        if(!attachResp.isSuccess()) {
            logger.error("获取打印附近信息失败:{}", JSONObject.toJSONString(attachResp));
            return CommonResponse.error("获取打印附近信息失败!");
        }

        List<String> fileType = Arrays.asList(new String[]{"jpg", "bmp", "png", "jpeg"});
        Map<String, List<String>> resp = attachResp.getData().stream()
                .filter(item -> !"printTemplate".equals(item.getSourceType()) && fileType.contains(FileUtils.getFileExt(item.getFileName(), false))).map(item -> {
                    if(pidIdMap.containsKey(item.getSourceId())) {
                        item.setSourceId(pidIdMap.get(item.getSourceId()));
                    }
                    if(ocrFileIdMap.containsKey(item.getSourceId())) {
                        item.setSourceId(ocrFileIdMap.get(item.getSourceId()));
                    }
                    return item;
                }).collect(Collectors.groupingBy(item -> item.getSourceId().toString(), Collectors.mapping(item ->
                {
                    if(StringUtils.isNotBlank(item.getOnlinePath())) {
                        return item.getOnlinePath();
                    } else {
                        return baseHost +"filepreview/"+ item.getFilePath();
                    }
                }, Collectors.toList())));

        Map<Long, Long> subIdMap = new HashMap<>();
        attachResp.getData().stream().filter(item -> (ocrFileIdMap.containsKey(item.getSourceId()) || pidIdMap.containsKey(item.getSourceId()))
                && "pdf".equalsIgnoreCase(FileUtils.getFileExt(item.getFileName(), false))).forEach(item -> {
            subIdMap.put(item.getId(), item.getSourceId());
        });
        if(!subIdMap.isEmpty()) {
            params.put("sourceIds", JSONObject.toJSONString(new ArrayList<>(subIdMap.keySet())));
            attachResp =  attachmentApi.queryAllBySourceIdList(params);
            if(!attachResp.isSuccess()) {
                logger.error("获取打印附近信息失败:{}", JSONObject.toJSONString(attachResp));
                return CommonResponse.error("获取打印附近信息失败!");
            }

            //根据文件名称排序
            fileList = attachResp.getData();
            fileList.stream().sorted((v1,v2) -> v1.getFileName().compareTo(v2.getFileName()));

            Map<String, List<String>> subFileMap = fileList.stream()
                    .filter(item -> fileType.contains(FileUtils.getFileExt(item.getFileName(), false))).map(item -> {
                        if(subIdMap.containsKey(item.getSourceId()) && pidIdMap.containsKey(subIdMap.get(item.getSourceId()))) {
                            item.setSourceId(pidIdMap.get(subIdMap.get(item.getSourceId())));
                        }
                        if(subIdMap.containsKey(item.getSourceId()) && ocrFileIdMap.containsKey(subIdMap.get(item.getSourceId()))) {
                            item.setSourceId(ocrFileIdMap.get(subIdMap.get(item.getSourceId())));
                        }
                        return item;
                    }).collect(Collectors.groupingBy(item -> item.getSourceId().toString(), Collectors.mapping(item ->
                    {
                        if(StringUtils.isNotBlank(item.getOnlinePath())) {
                            return item.getOnlinePath();
                        } else {
                            return baseHost +"filepreview/"+ item.getFilePath();
                        }
                    }, Collectors.toList())));
            for(String key : subFileMap.keySet()) {
                if(resp.containsKey(key)) {
                    resp.get(key).addAll(subFileMap.get(key));
                } else {
                    resp.put(key, subFileMap.get(key));
                }
            }
        }

        service.updateBillPrintInfo(ids);

        return CommonResponse.success(resp);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MatInvoiceVO> saveOrUpdate(@RequestBody MatInvoiceVO saveOrUpdateVO) {
    	MatInvoiceEntity entity = BeanMapper.map(saveOrUpdateVO, MatInvoiceEntity.class);

        if("1".equals(entity.getOpenOcrState())){// 制单时已开启OCR识别
            Set<String> inValidNumbers= entity.getDetailList().stream().filter(x->!"del".equals(x.getRowState()) && !"1".equals(x.getOcrState()))
                    .map(x -> x.getInvoiceNumber()).collect(Collectors.toSet());
            if(CollectionUtils.isNotEmpty(inValidNumbers)) {
                throw new BusinessException("操作失败, 号码为【"+ inValidNumbers.stream().collect(Collectors.joining("、")) + "】的发票附件未上传或发票附件查验未通过！");
            }
            inValidNumbers= entity.getDetailList().stream().filter(x->!"del".equals(x.getRowState()) && !"查验通过".equals(x.getOcrCheckMsg()))
                    .map(x -> x.getInvoiceNumber()).collect(Collectors.toSet());
            if(CollectionUtils.isNotEmpty(inValidNumbers)) {
                throw new BusinessException("操作失败, 发票【"+ inValidNumbers.stream().collect(Collectors.joining("、")) + "】下存在查验未通过的清单！");
            }
        } else if(CollectionUtils.isEmpty(entity.getFileList())) {
            throw new BusinessException("操作失败, 未上传发票附件!");
        }

    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setPrintFlag(PlanConstant.INTEGER_NO); //默认未打印
            //自制默认制单人是发票初审人
            UserContext user = sessionManager.getUserContext();
            entity.setAdminId(user.getUserId().toString());
            entity.setAdminCode(user.getUserCode());
            entity.setAdminName(user.getUserName());


            //查询发票是否被引用
            if(CollectionUtils.isNotEmpty(entity.getDetailList())) {
                List<Long> invoiceIds = entity.getDetailList().stream().map(MatInvoiceDetailEntity::getInvoiceId).distinct().collect(Collectors.toList());
                List<ErpInvoiceEntity> invoiceList = invoiceService.getAllByIds(invoiceIds);
                List<ErpInvoiceEntity> quoteList = invoiceList.stream().filter(item -> !"del".equals(item.getRowState()) && ("1".equals(item.getErpQuoteFlag()) || "1".equals(item.getQuoteFlag()))).collect(Collectors.toList());
                if(CollectionUtils.isNotEmpty(quoteList)) {
                    return CommonResponse.error("操作失败，发票["+quoteList.stream().map(ErpInvoiceEntity::getNumber)
                            .distinct().collect(Collectors.joining("、")) + "]已被引用！");
                }
            }
        }
    	entity.setSourceType(PlanConstant.SOURCE_TYPE_EL);
    	entity.setSignState(Integer.valueOf(PlanConstant.CHECK_STATE_FINISH));

        //设置发票抬头
        if(CollectionUtils.isNotEmpty(entity.getDetailList()) && StringUtils.isBlank(entity.getInvoiceHeader())) {
            entity.setInvoiceHeader(entity.getDetailList().get(0).getInvoiceHeader());
        }

        //子表数据处理
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal totalTaxMny = BigDecimal.ZERO;
        BigDecimal totalMny = BigDecimal.ZERO;
        if(CollectionUtils.isNotEmpty(entity.getDetailList())) {
            for(MatInvoiceDetailEntity detail : entity.getDetailList()) {
                if("del".equals(detail.getRowState())) {
                    continue;
                }
                totalTax = ComputeUtil.safeAdd(totalTax, detail.getTax());
                totalMny = ComputeUtil.safeAdd(totalMny, detail.getMny());
                if(null == detail.getTaxMny() || BigDecimal.ZERO.compareTo(detail.getTaxMny()) == 0) {
                    detail.setTaxMny(ComputeUtil.safeAdd(detail.getTax(), detail.getMny()));
                }
                totalTaxMny = ComputeUtil.safeAdd(totalTaxMny, detail.getTaxMny());
            }
        }
        entity.setTotalMny(totalMny);
        entity.setTotalTax(totalTax);
        entity.setTotalTaxMny(totalTaxMny);

        //赋值电子发票信息
        Map<Long, ErpInvoiceDetailEntity> invoiceDetailMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(entity.getDetailList())){
            List<MatInvoiceDetailEntity> detailList = entity.getDetailList();
            List<Long> invoiceDetailIds = detailList.stream().map(MatInvoiceDetailEntity::getInvoiceDetailId).collect(Collectors.toList());
            LambdaQueryWrapper<ErpInvoiceDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(ErpInvoiceDetailEntity::getId, invoiceDetailIds);
            List<ErpInvoiceDetailEntity> invoiceDetailEntityList = erpInvoiceDetailService.list(queryWrapper);
            if(CollectionUtils.isNotEmpty(invoiceDetailEntityList)){
                invoiceDetailMap = invoiceDetailEntityList.stream().collect(Collectors.toMap(ErpInvoiceDetailEntity::getId, Function.identity()));
            }
            for (MatInvoiceDetailEntity matInvoiceDetailEntity : detailList){
                if (invoiceDetailMap.containsKey(matInvoiceDetailEntity.getInvoiceDetailId())){
                    ErpInvoiceDetailEntity erpInvoiceDetailEntity = invoiceDetailMap.get(matInvoiceDetailEntity.getInvoiceDetailId());
                    matInvoiceDetailEntity.setInvoiceDetailSpec(erpInvoiceDetailEntity.getDetailSpec());
                    matInvoiceDetailEntity.setInvoiceDetailUnitName(erpInvoiceDetailEntity.getDetailUnitName());
                    matInvoiceDetailEntity.setInvoiceDetailNum(erpInvoiceDetailEntity.getDetailNum());
                    matInvoiceDetailEntity.setInvoiceDetailMny(erpInvoiceDetailEntity.getDetailMny());
                    matInvoiceDetailEntity.setInvoiceDetailPrice(ComputeUtil.safeDiv(erpInvoiceDetailEntity.getDetailMny(),erpInvoiceDetailEntity.getDetailNum()));
                }
            }
            entity.setDetailList(detailList);
        }


        if(null == entity.getAdminId()) {

            Long checkerId = contractManagerService.getContractOperator(entity.getContractId(), "1");
            if(null == checkerId) {
                checkerId = matCheckerSettingService.getByContractId(entity.getContractId());
            }

            if(null == checkerId && StringUtils.isNotBlank(entity.getAdminId())) {
                checkerId = Long.valueOf(entity.getAdminId());
            }

            if(null != checkerId) {
                CommonResponse<EmployeeVO> creatorResp = employeeApi.getById(checkerId);
                if(!creatorResp.isSuccess()) {
                    logger.error("查询发票审核人-{}信息失败,{}", checkerId, JSONObject.toJSONString(creatorResp, SerializerFeature.PrettyFormat));
                    throw new BusinessException("操作失败,查询发票审核人信息失败!");
                }

                if(null == creatorResp.getData()) {
                    logger.error("查询发票审核人-{}信息为空,{}", checkerId, JSONObject.toJSONString(creatorResp, SerializerFeature.PrettyFormat));
                    throw new BusinessException("操作失败,查询发票审核人信息失败!");
                }
                EmployeeVO craetor = creatorResp.getData();

                //设置发票审核人信息
                entity.setAdminId(craetor.getId().toString());
                entity.setAdminCode(craetor.getCode());
                entity.setAdminName(craetor.getName());
            } else {
                logger.info("*********自制采购发票登记 编码-{}未获取到发票初审人**************", entity.getBillCode());
            }
        }

        service.saveOrUpdate(entity, false);
    	MatInvoiceVO vo = BeanMapper.map(entity, MatInvoiceVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MatInvoiceVO> queryDetail(Long id) {
    	MatInvoiceEntity entity = service.selectById(id);
    	MatInvoiceVO vo = BeanMapper.map(entity, MatInvoiceVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatInvoiceVO> vos) {
        //只能删除供方提交且状态是已驳回 或者项目方自制状态是已审核非流程中的单据

        if(ListUtil.isNotEmpty(vos)){
            List<Long> longList = vos.stream().map(MatInvoiceVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<MatInvoiceEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(MatInvoiceEntity::getId, longList);

            List<MatInvoiceEntity> entities = service.list(queryWrapper);
            for(MatInvoiceEntity e : entities) {
                if(PlanConstant.SOURCE_TYPE_SUPPLIER.equals(e.getSourceType())) {
                    if(PlanConstant.CHECK_STATE_BACK.equals(e.getSignState())) {
                        continue;
                    }
                    return CommonResponse.error("单据【"+e.getBillCode()+"】非驳回状态，不能进行删除操作！");
                }
                if(PlanConstant.SOURCE_TYPE_EL.equals(e.getSourceType())) {
                    if(BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(e.getBillState())
                            || BillStateEnum.UNAPPROVED.getBillStateCode().equals(e.getBillState())) {
                        continue;
                    }
                    return CommonResponse.error("单据【"+e.getBillCode()+"】已提交流程，不能进行删除操作！");
                }
            }
            service.removeByIds(longList,true);
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MatInvoiceVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getParams().put("adminId", new Parameter(QueryParam.LIKE, InvocationInfoProxy.getEmployeeId()));

        if(param.getOrderMap().containsKey("effectiveDate")) {
            param.getOrderMap().put(" effective_date is null, effective_date ", param.getOrderMap().get("effectiveDate"));
            param.getOrderMap().remove("createTime");

            param.getOrderMap().put("createTime", param.getOrderMap().get("effectiveDate"));
            param.getOrderMap().remove("effectiveDate");
        }

        if(null != param.getParams().get("range") && "only".equals(param.getParams().get("range").getValue().toString())) {
            //进查询我审批、制单的单据
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("and");

            ComplexParam c2 = new ComplexParam();
            c2.setLogic("or");
            c2.getParams().put("adminId", new Parameter(QueryParam.LIKE, InvocationInfoProxy.getEmployeeId()));

            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
            c3.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(new Integer[]{BillStateEnum.UNAPPROVED.getBillStateCode(),BillStateEnum.UNCOMMITED_STATE.getBillStateCode()})));
            c3.getParams().put("sourceType", new Parameter(QueryParam.EQ, PlanConstant.SOURCE_TYPE_EL));

            ComplexParam c4 = new ComplexParam();
            c4.setLogic("or");
            c4.getParams().put("chiefAccountantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));

            c1.getComplexParams().add(c2);
            c1.getComplexParams().add(c3);
            c1.getComplexParams().add(c4);
            param.getComplexParams().add(c1);

            param.getParams().remove("range");

        } else if (StringUtils.isNotEmpty(param.getBillTypeId()) && service.viewSelf(param.getBillTypeId()) && param.getParams().get("createUserCode") == null && param.getParams().get("create_user_code") == null) {
            //自制发票需制单人和发票管理员查看
            if (param.getParams().containsKey("sourceType") && PlanConstant.SOURCE_TYPE_EL.toString().equals(param.getParams().get("sourceType").getValue())){
                //自制的单据 查询自己录制的单据以及自己审批的单据

                ComplexParam c1 = new ComplexParam();
                c1.setLogic("and");

                ComplexParam c2 = new ComplexParam();
                c2.setLogic("or");
                c2.getParams().put("adminId", new Parameter(QueryParam.LIKE, InvocationInfoProxy.getEmployeeId()));

                ComplexParam c3 = new ComplexParam();
                c3.setLogic("or");
                c3.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));

                c1.getComplexParams().add(c2);
                c1.getComplexParams().add(c3);
                param.getComplexParams().add(c1);



            } else {
                //供方申请  查询自己审批的单据
                param.getParams().put("createUserCode", new Parameter("eq", InvocationInfoProxy.getUsercode()));

            }
            param.setBillTypeId(null);
        }

        IPage<MatInvoiceEntity> page = service.queryPage(param,false);
        IPage<MatInvoiceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MatInvoiceVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
//        param.getParams().put("adminId", new Parameter(QueryParam.LIKE, InvocationInfoProxy.getEmployeeId()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if(null != param.getParams().get("range") && "only".equals(param.getParams().get("range").getValue().toString())) {
            //进查询我审批、制单的单据
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("and");

            ComplexParam c2 = new ComplexParam();
            c2.setLogic("or");
            c2.getParams().put("adminId", new Parameter(QueryParam.LIKE, InvocationInfoProxy.getEmployeeId()));

            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
            c3.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(new Integer[]{BillStateEnum.UNAPPROVED.getBillStateCode(),BillStateEnum.UNCOMMITED_STATE.getBillStateCode()})));
            c3.getParams().put("sourceType", new Parameter(QueryParam.EQ, PlanConstant.SOURCE_TYPE_EL));

            ComplexParam c4 = new ComplexParam();
            c4.setLogic("or");
            c4.getParams().put("chiefAccountantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));

            c1.getComplexParams().add(c2);
            c1.getComplexParams().add(c3);
            c1.getComplexParams().add(c4);
            param.getComplexParams().add(c1);

            param.getParams().remove("range");

        } else if (StringUtils.isNotEmpty(param.getBillTypeId()) && service.viewSelf(param.getBillTypeId()) && param.getParams().get("createUserCode") == null && param.getParams().get("create_user_code") == null) {
            //自制发票需制单人和发票管理员查看
            if (param.getParams().containsKey("sourceType") && PlanConstant.SOURCE_TYPE_EL.toString().equals(param.getParams().get("sourceType").getValue())){
                //自制的单据 查询自己录制的单据以及自己审批的单据

                ComplexParam c1 = new ComplexParam();
                c1.setLogic("and");

                ComplexParam c2 = new ComplexParam();
                c2.setLogic("or");
                c2.getParams().put("adminId", new Parameter(QueryParam.LIKE, InvocationInfoProxy.getEmployeeId()));

                ComplexParam c3 = new ComplexParam();
                c3.setLogic("or");
                c3.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));

                c1.getComplexParams().add(c2);
                c1.getComplexParams().add(c3);
                param.getComplexParams().add(c1);



            } else {
                //供方申请  查询自己审批的单据
                param.getParams().put("createUserCode", new Parameter("eq", InvocationInfoProxy.getUsercode()));

            }
            param.setBillTypeId(null);
        }
        List<MatInvoiceEntity> list = service.queryList(param);
        list.forEach(vo->{
            vo.setSignStateName(PlanConstant.CHECK_STATE.get(String.valueOf(vo.getSignState())));
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MatInvoice-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refMatInvoiceData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MatInvoiceVO>> refMatInvoiceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MatInvoiceEntity> page = service.queryPage(param,false);
        IPage<MatInvoiceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MatInvoiceVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 保存同步单据
     * @param request
     * @return
     */
    @RequestMapping(value = "/saveSyncBill", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Long> saveSyncBill(HttpServletRequest request) {
        return CommonResponse.success("接收成功！", service.saveSyncBill(request));
    }

    /**
     * 确认
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/confirmSign", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MatInvoiceVO> confirmSign(Long id) {
        return CommonResponse.success("操作成功！", service.confirmSign(id, true, null));
    }

    @PostMapping(value = "/syncBillToErp")
    @ResponseBody
    public CommonResponse<String> syncBillToErp(@RequestBody Long id) {
        return CommonResponse.success(service.pushToErp(id));
    }

    /**
     * 驳回
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/rejectSign", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MatInvoiceVO> rejectSign(@RequestParam Long id, @RequestParam(required = false) String rejectReason) {
        return CommonResponse.success("操作成功！", service.confirmSign(id, false, rejectReason));
    }

    /**
     * 提交流程
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/commitReview", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MatInvoiceVO> commitReview(@RequestParam Long id) {
        return CommonResponse.success("操作成功！", service.commitReview(id));
    }

    /**
     * 累计发票额超合同金额校验
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/validateMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateMny(Long id) {
        return CommonResponse.success("校验成功！", service.validateMny(id));
    }

    public static Integer getInteger(String str) {
        if (str == null || str.isEmpty()) return null;
        // 匹配：可选正负号 + 至少一个数字（不允许前导零或允许前导零）
        String regex = "^[-+]?\\d+$";
        if (!str.matches(regex)) return null;

        // 进一步检查是否在 int 范围内（-2147483648 到 2147483647）
        try {
            return Integer.parseInt(str);
        } catch (NumberFormatException e) {
            return null;
        }
    }

    /** 发票上传识别 */
    @PostMapping(value = "/uploadFilesAndOcr")
    @ResponseBody
    public CommonResponse<MatInvoiceVO> uploadFilesAndOcr(@RequestBody MatInvoiceVO invoiceVO) {
        List<AttachmentVO> files = invoiceVO.getFiles();
//        CommonResponse<Boolean> invoiceIdentification = resourceApi.checkResource("invoiceIdentificationNum",InvocationInfoProxy.getTenantid());
//        if(!invoiceIdentification.isSuccess() || !invoiceIdentification.getData()){
//            return CommonResponse.error("贵公司尚未购买发票识别服务，该功能不可用！如有需求请联系实施人员！");
//        }
        if(ListUtil.isEmpty(files)){
            return CommonResponse.error("没有可识别的文件！");
        }
//        CommonResponse<String> response = faceAndIdCardService.getRecognizeInvoiceNum();
//        if(!response.isSuccess()){
//            return CommonResponse.error(response.getMsg());
//        }
//        int num = Integer.parseInt(response.getData());
//        if(num<=0 || num<files.size()){
//            return CommonResponse.error("发票识别服务数量已用尽，续费后继续使用！如有需求请联系实施人员！");
//        }
        Map<String, List<MatInvoiceDetailVO>> detailMap = invoiceVO.getDetailList().stream().filter(x->!"del".equals(x.getRowState())).collect(Collectors.groupingBy(x->x.getInvoiceNumber()));
        List<MatInvoiceOcrVO> ocrList = new ArrayList<>();
        String msg = null;
        for (AttachmentVO file : files) {
            MatInvoiceOcrVO vo = new MatInvoiceOcrVO();
            vo.setRowState("add");
            vo.setId(IdWorker.getId());
            vo.setFileId(file.getId());
            vo.setFileName(file.getFileName());
            vo.setUploadTime(new Date());
            vo.setUploadPerson(InvocationInfoProxy.getUserid().toString());
            vo.getAttachIds().add(file.getId());

            String fileUrl = file.getImgServerPath()+file.getFilePath();
            String[] names = file.getFileName().split("\\.");
            String fileType = names[names.length-1].toLowerCase();
            vo.setFileType(fileType);

            CommonResponse<JSONObject>  recognizeRes = null;
            Integer readPage = getInteger(file.getMark());
            if(null != readPage) {
                recognizeRes = faceAndIdCardService.recognizeInvoiceInfoAliByPage(fileUrl, readPage);
            } else {
                recognizeRes = faceAndIdCardService.recognizeInvoiceInfoAli(fileUrl);
            }
            if(!recognizeRes.isSuccess()){
                logger.error(recognizeRes.getMsg(), recognizeRes.getCause());
                vo.setIdentifyResult("识别异常:" + recognizeRes.getMsg());
                vo.setOcrMsg("识别异常");
            }else {
                JSONObject result = recognizeRes.getData();
                vo.setIdentifyResult(result.toJSONString());
                // 发票识别结果匹配
                String ocrMsg = this.transferOcrVO(vo, detailMap, invoiceVO);
                vo.setOcrMsg(ocrMsg);

                String[] goodsNames = new String[]{"辅料", "配件", "材料"};
                if(detailMap.containsKey(vo.getInvoiceNumber())){
                    List<MatInvoiceDetailVO> detailList = detailMap.get(vo.getInvoiceNumber());
                    for(MatInvoiceDetailVO e : detailList) {
                        if(StringUtils.isBlank(e.getOcrState()) || !"1".equals(e.getOcrState())) {
                            e.setOcrState("通过".equals(ocrMsg) ? "1" : "0");
                        }
                    }

                    detailMap.put(vo.getInvoiceNumber(), detailList);
                }

                List<MatInvoiceDetailVO> allToCheckDetailList = invoiceVO.getDetailList().stream().filter(x->!"del".equals(x.getRowState())
                        && !"查验通过".equals(x.getOcrCheckMsg())).collect(Collectors.toList());
                if(CollectionUtils.isNotEmpty(allToCheckDetailList)) {
                    List<String> checkErrNames = new ArrayList<>();
                    BigDecimal rate6 =  new BigDecimal("6");
                    BigDecimal rate5 =  new BigDecimal("5");
                    for(MatInvoiceDetailVO e : allToCheckDetailList) {
                        checkErrNames.clear();
                        // 发票，项目名称包含 服务、电费、劳务、租赁的，后边可以为空
                        if(e.getGoodsName().contains("服务") || e.getGoodsName().contains("劳务") ||
                                e.getGoodsName().contains("电费") || e.getGoodsName().contains("租赁")) {
                            e.setOcrCheckMsg("查验通过");
                            continue;
                        }
                        //税率为6%、5%的不做验证
                        if(null != e.getRate()
                                && (rate6.compareTo(e.getRate()) == 0 || rate5.compareTo(e.getRate()) == 0)) {
                            e.setOcrCheckMsg("查验通过");
                            continue;
                        }
                        //发票金额为负  清单不做验证
                        if(vo.getInvoiceTaxMny().compareTo(BigDecimal.ZERO) < 0) {
                            e.setOcrCheckMsg("查验通过");
                            continue;
                        }

                        if(CommonUtils.endsWithAny(e.getGoodsName(), goodsNames)){
                            e.setOcrCheckMsg("清单【项目名称】不能以["+StringUtils.join(goodsNames, "、")+"]字样结尾");
                            continue;
                        }

                        //发票清单中项目名称或【规格型号】【单位】【数量】等所在行字段都不能为空，不能空白
                        if(StringUtils.isBlank(e.getInvoiceDetailUnitName())) {
                            checkErrNames.add("【单位】");
//                            e.setOcrCheckMsg("【单位】为空");
//                            continue;
                        }
                        if(StringUtils.isBlank(e.getInvoiceDetailSpec())) {
//                            e.setOcrCheckMsg("【规格型号】为空");
//                            continue;
                            checkErrNames.add("【规格型号】");
                        }
                        if(null == e.getInvoiceDetailNum()) {
//                            e.setOcrCheckMsg("【数量】为空");
//                            continue;
                            checkErrNames.add("【数量】");
                        }
                        if(null == e.getInvoiceDetailMny()) {
//                            e.setOcrCheckMsg("【金额】为空");
//                            continue;
                            checkErrNames.add("【金额】");
                        }
//                        if(null == e.getInvoiceDetailPrice()) {
////                            e.setOcrCheckMsg("【单价】为空");
////                            continue;
//                            checkErrNames.add("【单价】");
//                        }
                        if(null == e.getRate()) {
//                            e.setOcrCheckMsg("【税率】为空");
//                            continue;
                            checkErrNames.add("【税率】");
                        }
                        if(null == e.getTax()) {
//                            e.setOcrCheckMsg("【税额】为空");
//                            continue;
                            checkErrNames.add("【税额】");
                        }

                        if(CollectionUtils.isNotEmpty(checkErrNames)) {
                            e.setOcrCheckMsg(checkErrNames.stream().collect(Collectors.joining("、"))+"为空");
                            continue;
                        }

                        e.setOcrCheckMsg("查验通过");
                    }
                }
            }
            ocrList.add(vo);
        }
        ocrList.addAll(invoiceVO.getOcrList());
        invoiceVO.setOcrList(ocrList);
//        List<MatInvoiceDetailVO> detailList = detailMap.values().stream().flatMap(List::stream).collect(Collectors.toList());
//        invoiceVO.setDetailList(detailList);
        return CommonResponse.success(msg, invoiceVO);
    }

    /**
     * 发票识别结果匹配
     * @param vo
     * @param detailMap
     */
    private String transferOcrVO(MatInvoiceOcrVO vo, Map<String, List<MatInvoiceDetailVO>> detailMap, MatInvoiceVO invoiceVO) {
        JSONObject result = JSONObject.parseObject(vo.getIdentifyResult());
        String invoiceNumber = result.getString("invoiceNumber");
        vo.setInvoiceDate(result.getDate("invoiceDate"));
        vo.setInvoiceCode(result.getString("invoiceCode"));
        vo.setInvoiceNumber(invoiceNumber);
        vo.setInvoiceMny(result.getBigDecimal("invoiceAmountPreTax"));
        vo.setInvoiceTax(result.getBigDecimal("invoiceTax"));
        vo.setInvoiceTaxMny(result.getBigDecimal("totalAmount"));

        String partyAName = null;
        String socialCode = null;
        if(null != invoiceVO.getContractId()) {
            //查询合同信息
            ContractEntity contract = contractService.selectById(invoiceVO.getContractId());
            if(null != contract && StringUtils.isNotBlank(contract.getContractPartyA())) {
                partyAName = contract.getContractPartyA();
            }
            if(StringUtils.isNotBlank(partyAName)) {
                CommonResponse<List<DefdocDetailVO>> defDetails = defdocApi.detailListByDetailNamesAndDocCode(new String[]{partyAName}, COMPANY_SOCIAL_CODE);
                if(!defDetails.isSuccess() || CollectionUtils.isEmpty(defDetails.getData())) {
                    logger.info("*******获取甲方：{}对应社会统一信用代码失败或为空*********！");
                }

                List<DefdocDetailVO> companySocialVos = defDetails.getData().stream().filter(item -> item.getName().equals(contract.getContractPartyA())).collect(Collectors.toList());
                if(CollectionUtils.isNotEmpty(companySocialVos)) {
                    socialCode = companySocialVos.get(0).getCode();
                }
            }
        }

        // 1.判断发票是否一致关键信息:发票号码(主要识别)、销方单位名称(主要识别)、含税金额(主要识别)
        if(!detailMap.containsKey(invoiceNumber)){
            return "失败：发票号码不匹配";
        }
        if(!CommonUtils.toDBC(invoiceVO.getSupplierName()).equals(result.getString("sellerName"))){
            return "失败：销方不匹配";
        }
        if(StringUtils.isNotBlank(partyAName) && !partyAName.replaceAll("（", "(").replaceAll("）", ")")
                .equals(result.getString("purchaserName").replaceAll("（", "(").replaceAll("）", ")"))) {
            return "失败：购买方不匹配";
        }
        if(StringUtils.isNotBlank(socialCode) && !socialCode.equalsIgnoreCase(result.getString("purchaserTaxNumber"))) {
                return "失败：购买方社会统一信用代码不匹配";
        }

        List<MatInvoiceDetailVO> detailList = detailMap.get(vo.getInvoiceNumber());
        BigDecimal invoiceTaxMny = detailList.stream().map(x->x.getTaxMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        if(!ComputeUtil.equals(invoiceTaxMny, vo.getInvoiceTaxMny())){
            logger.error("发票金额不匹配，发票明细总金额：{}, 发票识别金额：{}", invoiceTaxMny.toPlainString(), vo.getInvoiceTaxMny().toPlainString());
            return "失败：金额不匹配";
        }

        // 2.开票人、复核人、收款人三个人员名称不能含有字母;异常识别结果:开票人、复核人、收款人姓名异常
        String remarks = result.getString("remarks");// 从备注中取
        String drawer = result.getString("drawer");// 开票人
        String recipient = StringUtils.isNotEmpty(result.getString("recipient")) ?
                result.getString("recipient") : CommonUtils.parseField(remarks, "收款人");// 收款人
        String reviewer = StringUtils.isNotEmpty(result.getString("reviewer")) ?
                result.getString("reviewer") : CommonUtils.parseField(remarks, "复核人");// 复核人
        if(CommonUtils.judgeContainsStr(drawer)){
            return "失败：开票人姓名异常";
        }
        if(CommonUtils.judgeContainsStr(recipient)){
            return "失败：收款人姓名异常";
        }
        if(CommonUtils.judgeContainsStr(reviewer)){
            return "失败：复核人姓名异常";
        }
        // 3.复核人与收款人不能为同一人
        if(StringUtils.isNotEmpty(recipient) && StringUtils.isNotEmpty(reviewer) && recipient.equals(reviewer)){
            return "失败：复核人、收款人重复";
        }

        // 6.清单缺失
//        JSONArray invoiceDetails = result.getJSONArray("invoiceDetails");
//        if(detailList.size() != invoiceDetails.size()){
//            return "失败：发票清单数量不匹配";
//        }

        //发票税率查验
//        BigDecimal rate = detailList.get(0).getRate();

//        Map<String, List<MatInvoiceDetailVO>> invoiceDetailMap = invoiceVO.getDetailList().stream().filter(e -> !"del".equals(e.getRowState())).collect(Collectors.groupingBy(item ->
//             item.getInvoiceNumber() + item.getGoodsName() + (StringUtils.isBlank(item.getInvoiceDetailSpec()) ?"":item.getInvoiceDetailSpec().replaceAll(" ", ""))
//                    + (StringUtils.isBlank(item.getInvoiceDetailUnitName()) ?"":item.getInvoiceDetailUnitName())
//                    + item.getTaxMny().toPlainString() + item.getInvoiceDetailNum().toPlainString()
//        ));

//        DecimalFormat df = new DecimalFormat("#.##");
//        String[] names = new String[]{"辅料", "配件", "材料"};
//        for(Object o : invoiceDetails) {
//            JSONObject obj = (JSONObject)o;
//            String itemName = obj.getString("itemName");
//
//            if(!ComputeUtil.equals(rate, new BigDecimal(obj.getString("taxRate").replace("%", "")))) {
//                return "失败：发票清单税率不一致";
//            }
//
//            // 5.发票清单中，项目名称中字段不能【*辅料、*配件、*材料】结尾，正则表达式
//            if(CommonUtils.endsWithAny(itemName, names)){
//                return "失败：发票清单项目名称异常";
//            }
//            // 分包发票，项目名称为 建筑服务的，后边可以为空
//            if(itemName.contains("建筑服务")){
//                continue;
//            }
//            // 4.发票清单中:0CR识别发票清单中的项目名称或【规格型号】【单位】【数量】等所在行字段都不能为空，不能空白
//            for (String key : obj.keySet()) {
//                if(StringUtils.isEmpty(obj.getString(key))){
//                    return "失败：发票清单不完整";
//                }
//            }
//
////            String checkKey = invoiceNumber+obj.getString("itemName") + (StringUtils.isNotBlank(obj.getString("specification")) ? obj.getString("specification") : "")
////                    +(StringUtils.isNotBlank(obj.getString("unit")) ? obj.getString("unit") : "") +
////                    df.format(ComputeUtil.safeAdd(new BigDecimal(obj.getString("amount")), new BigDecimal(obj.getString("tax")))) + obj.getString("quantity");
////
////            if(invoiceDetailMap.containsKey(checkKey)) {
////                List<MatInvoiceDetailVO> details = invoiceDetailMap.get(checkKey).stream().filter(e -> StringUtils.isBlank(e.getOcrState()) || !"已匹配附件".equals(e.getOcrCheckMsg())).collect(Collectors.toList());
////                if(CollectionUtils.isNotEmpty(details)) {
////                    details.get(0).setOcrState("1");
////                    details.get(0).setOcrCheckMsg("已匹配附件");
////                    details.get(0).setOcrFileId(vo.getFileId().toString());
////                }
////            }
//        }
        return "通过";
    }
}
