package com.ejianc.business.zdsmaterial.sub.settle.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleEntity;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleFileEntity;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleRecordEntity;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleTemplateEntity;
import com.ejianc.business.zdsmaterial.sub.settle.mapper.SubSettleMapper;
import com.ejianc.business.zdsmaterial.sub.settle.service.ISubSettleFileService;
import com.ejianc.business.zdsmaterial.sub.settle.service.ISubSettleRecordService;
import com.ejianc.business.zdsmaterial.sub.settle.service.ISubSettleService;
import com.ejianc.business.zdsmaterial.sub.settle.utils.HttpTookit;
import com.ejianc.business.zdsmaterial.util.PushFileUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包结算管理
 *
 * @author generator
 *
 */
@Service("subSettleService")
public class SubSettleServiceImpl extends BaseServiceImpl<SubSettleMapper, SubSettleEntity> implements ISubSettleService{


    private final String BILL_PUSH_PM_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/subSettle/subSettleSyncBill";//推送接口
    private final String BILL_PUSH_PM_SERVER_APPROVE_URL = "/ejc-zdssupbusiness-web/openapi/subSettle/syncApproveStatus";//
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String OPERATE = "SubSettleBill";
    @Autowired
    private JedisPool jedisPool;

    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IUserApi usersApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private static final String BILL_TYPE_CODE = "EJCBT202403000002";
    @Autowired
    private ISubSettleRecordService subSettleRecordService;
    @Autowired
    private ISubSettleFileService subSettleFileService;

    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private SubSettleMapper mapper;

    private final String SOURCE_TYPE = "subFile";
    @Autowired
    private PushFileUtil pushFileUtil;

    @Override
    public String pushSubSettleBill(SubSettleEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = OPERATE + "::" + entity.getId().toString() + "::sup";
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);
            if (!locked) {
                releaseLock(jedis, false, key, OPERATE);
                return "分包结算推送供应链平台失败，加锁失败！";
            }
            //设置单据当前系统信息
            CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                logger.error("推送分包结算单-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
                return "推送分包结算单失败，获取当前系统编码失败";
            }
            entity.setSourceSystemId(ejcCloudSystemCode.getData());
            Map<String, String> params = new HashMap<>();

            Map<String, Map<String, InputStream>> files = new HashMap<>();
            if (entity.getSubSettleTemplateList() != null && entity.getSubSettleTemplateList().size() > 0) {
                Map<String, String> fileSourceTypeMap = new HashMap<>();
                List<Long> fileIds = new ArrayList<>();
                List<String> fileNames = new ArrayList<>();
                for (SubSettleTemplateEntity detail : entity.getSubSettleTemplateList()) {
                    fileNames.clear();
                    fileIds.clear();
                    CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(detail.getId(), null, null, null);
                    if (fileResp.isSuccess()) {
                        List<AttachmentVO> fileList = fileResp.getData();

                        for (AttachmentVO attach : fileList) {
                            fileIds.add(attach.getId());
                            fileNames.add(attach.getFileName());
                        }
                        detail.setFileIds(StringUtils.join(fileIds, ","));
                        detail.setFileNames(StringUtils.join(fileNames, ","));
                    }
                }
                params.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
            }
            params.put("transData", JSONObject.toJSONString(entity));
            logger.info("分包结算单推送供应链平台: url-{}, 分包结算单：{}", BILL_PUSH_PM_SERVER_URL, JSONObject.toJSONString(entity));
            CommonResponse<String> writeBackResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_PUSH_PM_SERVER_URL,
                    params, entity.getSupplierId().toString(), files);
            logger.error("分包结算单推送供应链平台请求结果，{}", JSONObject.toJSONString(writeBackResp));
            if (!writeBackResp.isSuccess()) {
                releaseLock(jedis, true, key, OPERATE);
                logger.error("分包结算单id-{}推送供应链平台发送请求失败，{}", entity.getId(), writeBackResp.getMsg());
                return "分包结算单推送供应链平台失败";
            }

            String operateRespStr = writeBackResp.getData();
            CommonResponse<String> operateResp = JSONObject.parseObject(operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                logger.error("分包结算单id-{}推送供应链，平台处理失败，{}", entity.getId(), operateResp.getMsg());
                releaseLock(jedis, true, key, OPERATE);
                return "分包结算单推送供应链平台失败";
            }

        } catch (Exception e) {
            logger.error("分包结算单id-{}推送供应链平台失败，", entity.getId(), e);
            msg = "操作失败，分包结算单推送供应链平台失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }

    @Transactional
    @Override
    public CommonResponse<String> subSettleCommitSyncBill(HttpServletRequest request) {
        String msg = null;
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);
        logger.info("接收到同步供方分包结算单信息: {}, 当前上下文: {}", transData, authority);
        if (StringUtils.isBlank(transData)) {
            return CommonResponse.error("单据同步失败，单据内容为空！");
        }
        SubSettleEntity entity = JSONObject.parseObject(transData, SubSettleEntity.class);
        Long sourceId = Long.parseLong(entity.getSourceId());
        SubSettleEntity subSettleEntity = super.selectById(sourceId);
        subSettleEntity.setSourceId(entity.getId().toString());
        subSettleEntity.setFillStatus(ZDSMaterialCommonEnums.填报状态_已上传资料.getCode());
        subSettleEntity.setSettleMny(entity.getSettleMny());
        super.updateById(subSettleEntity);

        //下载对应附件
        //执行新增 设置来源
        //将附件关联在单据中
        entity.setVersion(null);
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        entity.setSourceId(entity.getId().toString());
        if(CollectionUtils.isNotEmpty(entity.getSubSettleFileList())) {
            for(SubSettleFileEntity detail : entity.getSubSettleFileList()) {
                Long newId = IdWorker.getId();
                Long fileId = pushFileUtil.uploadFileFormNet(BILL_TYPE_CODE, newId, SOURCE_TYPE, detail.getAttachmentId());
                detail.setSourceFileId(detail.getSourceFileId());
                detail.setSourceFilePath(detail.getSourceFilePath());
                detail.setCreateTime(null);
                detail.setUpdateTime(null);
                detail.setUpdateUserCode(null);
                detail.setCreateUserCode(null);
                detail.setCreateUserCode(null);
                detail.setVersion(null);
                detail.setId(newId);
                detail.setAttachmentId(fileId);
                detail.setSettleId(sourceId);
            }
        }
        subSettleFileService.saveBatch(entity.getSubSettleFileList());
        //推送记录表
        SubSettleRecordEntity subSettleRecordEntity = new SubSettleRecordEntity();
        subSettleRecordEntity.setSettleStatus(ZDSMaterialCommonEnums.业务环节_供方上传资料.getCode());
        subSettleRecordEntity.setSettleId(subSettleEntity.getId());
        subSettleRecordEntity.setEmployeeId(entity.getSubLinkId());
        subSettleRecordEntity.setEmployeeName(entity.getSubLinkName());
        subSettleRecordEntity.setEmployeeCode(entity.getSubLinkCode());

        PushMsgParameter pushMsgParameter = new PushMsgParameter();
        String subject = "【结算申请】，【" +subSettleEntity.getBillCode()+ "】，【"+ DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())+"】需要您审核！";
        pushMsgParameter.setSubject(subject);
        String content = "【" +subSettleEntity.getBillCode()+ "】，【"
                +subSettleEntity.getProjectName()+"】，【"
                +subSettleEntity.getSubContractName()+"】，【"
                +subSettleEntity.getSupplierName()+"】提交了结算申请，请您审核！";
        pushMsgParameter.setContent(content);
        pushMsgParameter.setPcUrl(baseHost+"ejc-zdsmaterial-frontend/#/preview/card?id="+subSettleEntity.getId().toString());
        String[] recId = new String[]{subSettleEntity.getMatWorkerId().toString()}; //验收人Id
        pushMsgParameter.setReceivers(recId);
        CommonResponse<UserVO> userByUserId = usersApi.findUserByUserId(subSettleEntity.getMatWorkerId());
        if (!userByUserId.isSuccess()){
            logger.info("查询采购工程师网络异常",userByUserId.getMsg());
            throw new BusinessException("查询采购工程师网络异常!");
        }
        UserVO data = userByUserId.getData();
        JSONObject params = new JSONObject();
        params.put("userEmails", data.getUserEmail());
        params.put("userNames", data.getUserName());
        pushMsgParameter.setZdsExtEmailParams(params);// 中电四邮件消息扩展参数
        sendMsg(pushMsgParameter, subSettleEntity.getId(), "结算指令单向分包联系人发送邮件");


        //发送代办
        List<String> userId = new ArrayList<>();
        userId.add(subSettleEntity.getMatWorkerId().toString());
        sendTodo(userId,subSettleEntity.getId().toString(),subSettleEntity.getId().toString(),subSettleEntity.getId().toString(),subject,subSettleEntity.getMatWorkerId().toString(),baseHost+"ejc-zdsmaterial-frontend/#/preview/card?id="+subSettleEntity.getId().toString(),null,"分包方已上传结算审核资料");
        return CommonResponse.success("单据同步成功！", null);
    }
    @Value("${zds.erp.appId:859f0363d7dcc01cc4275a6cad2a0001}")
    private String appId;
    @Value("${zds.erp.secret:11658934fd26400985e1e9d83f6ac7cf}")
    private String secret;
    @Value("${zds.erp.reqHost:http://192.168.201.55:8001}")
    private String reqHost;
    private Gson gson = new GsonBuilder().disableHtmlEscaping().create();

    @Autowired
    private EnvironmentTools environmentTools;


    public boolean sendTodo(List<String> userId,String billId, String taskId, String bpmId, String title,
                            String startUserId, String formUrl, String maUrl, String taskName) {
        return  sendTodo(userId, billId, taskId, bpmId, title, startUserId, formUrl, maUrl, taskName, "0", "0");
    };

    public static void main(String[] args) {
        System.out.println(UUID.nameUUIDFromBytes("123".getBytes()).toString());
    }
    public Map<String, String> getErpHeaders() throws Exception {
        Map<String, String> headers = new HashMap<>();
        String nowStr = DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date());
        logger.info("-------------appId:{},secret:{}",appId, secret);
        headers.put("appid", toMD5(appId));
        headers.put("ticket", nowStr);
        headers.put("sign", toMD5(secret + toMD5(appId) + toMD5(nowStr)));
        return headers;
    }
    public JSONObject getUser(String userId){
        try {
            if(userId!=null){
                JSONArray jArray = ReferObjectUtil.getReferEntityValue(userId, "idm-user");
                if(jArray!=null&&jArray.size()>0){
                    JSONObject json = (JSONObject) jArray.get(0);
                    return json;
                }
            }
        } catch (Exception e) {
//			e.printStackTrace();
        }
        return null;
    }

    public boolean sendTodo(List<String> userId,String billId, String taskId, String bpmId, String title,
                            String startUserId, String formUrl, String maUrl, String taskName, String processState, String ideaCode) {
        if(userId==null||userId.size()==0){
            logger.info("用户信息为空--------");
            return false;
        }
        try {
            logger.info("调用中电四ERP 接口：发送消息接口start------------------");
            if(taskId.length()>19){
                taskId = taskId.substring(taskId.length()-19, taskId.length());
            }
            String serverUrl = reqHost + "/cefoc/yql/getTaskTicket";
            String[] userIds = new String[userId.size()];
            JSONObject json = this.getUser(startUserId);
            String startUserCode = startUserId;
            String startUserName = startUserId;
            if(json!=null){
                startUserCode = json.get("code").toString();
                startUserName = json.get("name").toString();
            }
            JSONArray data = new JSONArray();

            formUrl = URLEncoder.encode(formUrl,"utf-8");
            CommonResponse<List<UserVO>> userBack = usersApi.queryListByIds(userId.toArray(userIds));
            if(userBack.isSuccess()){
                if(userBack.getData()!=null&&userBack.getData().size()>0){
                    List<UserVO> userList = userBack.getData();
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    for(UserVO userVO : userList){
                        //modelId格式：单据id-用户编码-taskId
                        String modelId = billId + '-' + userVO.getUserCode() + "-" + taskId + "-" + bpmId;
                        modelId = UUID.nameUUIDFromBytes(modelId.getBytes(StandardCharsets.UTF_8)).toString();
                        logger.info("发送代办："+userVO.getUserName()+"-----------"+modelId);
                        String ApprovalURL = maUrl + "&userid=" + userVO.getId();
                        String jumpUrl = environmentTools.getBaseHost() + "portal/sso/index?usercode="+userVO.getUserCode()+"&targeturl="+formUrl;

                        JSONObject param = new JSONObject();
                        /******必填********/
                        param.put("YQLTaskTicketOID", modelId);//主键值
                        param.put("InstanceID", modelId);//审批实例
                        param.put("BusiField", title);//审批主题
                        param.put("ProcessState", "0".equals(processState) ?"待办":"已办");//审批状态名称（待办、已办）
                        param.put("ProcessStateCode", processState);//审批状态编码0,1;待办为0,已办为1
                        param.put("ActivityChineseName", taskName);//审批节点名称
                        param.put("Sys_Created", new Date());//创建时间
                        param.put("Sys_LAST_UPD", new Date());//最后更新时间
                        param.put("PersonName", userVO.getUserName());//审批人
                        param.put("PersonOID", userVO.getSourceId());//审批人sourcec_id
                        param.put("WorkCode", userVO.getUserCode());//审批人工号
                        param.put("ApprovalURL", ApprovalURL);//移动端审批页面
                        param.put("WebApprovalURL", jumpUrl);//电脑端审批页面
                        param.put("OriginatorName", startUserName);//发起人
                        param.put("OriginatorCode", startUserCode);//发起人工号
                        param.put("OriginatorTime", new Date());//发起时间
                        param.put("Idea", "0".equals(ideaCode) ? "" : "1".equals(ideaCode) ? "同意" : "不同意");//审批意见
                        param.put("IdeaCode", ideaCode);//审批标识1同意，2不同意
                        param.put("SYS_Deleted", 0);//删除状态默认0
                        param.put("YQL_SID", modelId);//代办信息ID

                        data.add(param);
                        /******非必填********/
//						param.put("SYS_CreatedBy", );//创建人oid
//						param.put("SYS_REPLACEMENT", );//授权用户oid
//						param.put("SYS_POSTN", );//创建人岗位oid
//						param.put("SYS_DIVISION", );//创建人部门oid
//						param.put("SYS_ORG", );//创建人组织oid
//						param.put("SYS_LAST_UPD_BY", );//最后更新人oid
                    }

                }else{
                    logger.info("根据id："+userId.toString()+"获取用户信息失败，未查询到该用户数据");
                }
            }else{
                logger.info("根据id："+userId.toString()+"获取用户信息失败，调用接口userApi.queryListByIds失败");
            }

            if(data!=null && data.size()>0){
                logger.info("传递的参数：---------------"+data.toJSONString());
                String paramterStr = gson.toJson(data);
                Map<String, String> header = this.getErpHeaders();
                String result = HttpTookit.postByJson(serverUrl, paramterStr, header);
                logger.info(result);
                logger.info("发送代办接口调用成功！！！++++++++++++");
            }

            logger.info("调用中电四ERP 接口：发送消息接口end------------------");
            return true;
        } catch (Exception e) {
            logger.info("错误：{}", e);
            logger.info("调用中电四ERP 接口：发送消息接口失败！！！！！！！！！！！！！！！！");
            return false;
        }
    }

    public String toMD5(String plainText) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hashBytes = digest.digest(plainText.getBytes());

        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xff) + 0x100, 16).substring(1));
        }

        return sb.toString().toLowerCase();
    }
    public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_EMAIL});
        CommonResponse<String> sendResp = pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            logger.error("{}-发送邮件失败，单据Id-{}，发送邮件结果-{}", oprMsg, billId, JSONObject.toJSONString(sendResp, SerializerFeature.PrettyFormat,
                    SerializerFeature.WriteMapNullValue));
        } else {
            logger.info("{}-发送邮件成功！", oprMsg);
        }



    }

    @Transactional
    @Override
    public String updateApproveStatus(Long id, Integer fillStatus , String rejectCause) {
        SubSettleEntity subSettleEntity = super.selectById(id);
        subSettleEntity.setFillStatus(fillStatus);
        if (null !=rejectCause ){
            subSettleEntity.setRejectCause(rejectCause);
        }
        //删除附件
        if (fillStatus == 1){
            List<SubSettleFileEntity> subSettleFileList = subSettleEntity.getSubSettleFileList();
            List<Long> collect = subSettleFileList.stream().map(SubSettleFileEntity::getAttachmentId).collect(Collectors.toList());
            List<Long> subFileListIds = subSettleFileList.stream().map(SubSettleFileEntity::getId).collect(Collectors.toList());
            String ids = StringUtils.join(collect.toArray(), ",");

            attachmentApi.delete(ids);

            //删除子表数据
            subSettleFileService.removeByIds(subFileListIds);
            subSettleEntity.setSettleMny(null);
        }
        super.updateById(subSettleEntity);

        //添加流转记录
        SubSettleRecordEntity subSettleRecordEntity = new SubSettleRecordEntity();
        if (fillStatus == 1){
            subSettleRecordEntity.setSettleStatus(ZDSMaterialCommonEnums.业务环节_驳回资料.getCode());
        }
        if (fillStatus == 3){
            subSettleRecordEntity.setSettleStatus(ZDSMaterialCommonEnums.业务环节_同意提交.getCode());
        }

        subSettleRecordEntity.setSettleId(id);
        UserContext userContextCache = sessionManager.getUserContext();
        subSettleRecordEntity.setEmployeeId(userContextCache.getUserId());
        subSettleRecordEntity.setEmployeeName(userContextCache.getUserName());
        subSettleRecordEntity.setEmployeeCode(userContextCache.getUserCode());

        subSettleRecordService.save(subSettleRecordEntity);


        //推送供方
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = OPERATE + "::" + subSettleEntity.getId().toString() + "::sup";
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);
            if (!locked) {
                releaseLock(jedis, false, key, OPERATE);
                return "分包结算状态推送供应链平台失败，加锁失败！";
            }
            //设置单据当前系统信息
            CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                logger.error("推送分包结算单-{}失败，获取当前系统编码失败,{}", subSettleEntity.getId(), ejcCloudSystemCode.getMsg());
                return "推送分包结算单失败，获取当前系统编码失败";
            }

            //设置当前系统ID
            subSettleEntity.setSourceSystemId(ejcCloudSystemCode.getData());
            Map<String, String> params = new HashMap<>();

            Map<String, Map<String, InputStream>> files = new HashMap<>();
            params.put("transData", JSONObject.toJSONString(subSettleEntity));
            logger.info("分包结算单推送供应链平台: url-{}, 分包结算单：{}", BILL_PUSH_PM_SERVER_APPROVE_URL, JSONObject.toJSONString(subSettleEntity));
            CommonResponse<String> writeBackResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_PUSH_PM_SERVER_APPROVE_URL,
                    params, subSettleEntity.getSupplierId().toString(), null);
            logger.error("分包结算单推送供应链平台请求结果，{}", JSONObject.toJSONString(writeBackResp));
            if (!writeBackResp.isSuccess()) {
                releaseLock(jedis, true, key, OPERATE);
                logger.error("分包结算单id-{}推送供应链平台发送请求失败，{}", subSettleEntity.getId(), writeBackResp.getMsg());
                return "分包结算单推送供应链平台失败";
            }

            String operateRespStr = writeBackResp.getData();
            CommonResponse<String> operateResp = JSONObject.parseObject(operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                logger.error("分包结算单id-{}推送供应链，平台处理失败，{}", subSettleEntity.getId(), operateResp.getMsg());
                releaseLock(jedis, true, key, OPERATE);
                return "分包结算单推送供应链平台失败";
            }



            //发送已办
            String subject = "【结算申请】，【" +subSettleEntity.getBillCode()+ "】，【"+ DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())+"】需要您审核！";
            List<String> userId = new ArrayList<>();
            userId.add(subSettleEntity.getMatWorkerId().toString());
            sendTodo(userId,subSettleEntity.getId().toString(),subSettleEntity.getId().toString(),subSettleEntity.getId().toString(),
                    subject,
                    subSettleEntity.getMatWorkerId().toString(),
                    baseHost+"ejc-zdsmaterial-frontend/#/preview/card?id="+subSettleEntity.getId().toString(),
                    null,"分包方已上传结算审核资料", "1", fillStatus == 3 ? "1":"2");

            if(null != subSettleEntity.getSourceId()) {
                sendTodo(userId,subSettleEntity.getSourceId(),subSettleEntity.getSourceId(),subSettleEntity.getSourceId(),
                        subject,
                        subSettleEntity.getMatWorkerId().toString(),
                        baseHost+"ejc-zdsmaterial-frontend/#/preview/card?id="+subSettleEntity.getId().toString(),
                        null,"分包方已上传结算审核资料", "1", fillStatus == 3 ? "1":"2");
            }
        } catch (Exception e) {
            logger.error("分包结算单id-{}推送供应链平台失败，", subSettleEntity.getId(), e);
            msg = "操作失败，分包结算单推送供应链平台失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;


    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public int pageCount(Map<String, Object> queryParam) {
        return mapper.pageCount(queryParam);
    }

    @Override
    public List<JSONObject> pageList(Map<String, Object> queryParam) {
        return mapper.pageList(queryParam);
    }
}
