package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.bean.BrandApplyDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.BrandApplyEntity;
import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.service.IBrandApplyService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.vo.BrandApplyDetailVO;
import com.ejianc.business.zdsmaterial.erp.vo.BrandApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 品牌申请主实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("brandApply")
public class BrandApplyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZDS_CEFOC_BRAND_APPLY";

    @Autowired
    private IBrandApplyService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBrandService brandService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BrandApplyVO> saveOrUpdate(@RequestBody BrandApplyVO saveOrUpdateVO) {
        if(CollectionUtils.isNotEmpty(saveOrUpdateVO.getDetailList())) {
            saveOrUpdateVO.setBrandNames(StringUtils.join(saveOrUpdateVO.getDetailList().stream().filter(item -> !"del".equals(item.getRowState())).map(BrandApplyDetailVO::getBrandName).collect(Collectors.toSet()), ","));
        }
    	BrandApplyEntity entity = BeanMapper.map(saveOrUpdateVO, BrandApplyEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

    	if(CollectionUtils.isNotEmpty(entity.getDetailList())) {
            //查询品牌是否已入库
            List<String> brandNames = new ArrayList<>(entity.getDetailList().stream().filter(item -> !"del".equals(item.getRowState()))
                    .map(item -> item.getBrandName()).collect(Collectors.toSet()));

            Map<String, BrandEntity> brandNameMaps = brandService.getAllByNames(brandNames);
            if(MapUtils.isNotEmpty(brandNameMaps)) {
                return CommonResponse.error("操作失败，品牌名称["+brandNameMaps.keySet().stream().collect(Collectors.joining("、"))+"]已在库，请勿重复申请！");
            }

    	    Map<String, List<BrandApplyDetailEntity>> detailMap = entity.getDetailList().stream().filter(item -> !"del".equals(item.getRowState()))
                    .collect(Collectors.groupingBy(item -> item.getMaterialTypeId().toString()+item.getBrandName()+item.getSupplierName()));

            Set<String> repeatKey = detailMap.entrySet()
                    .stream().filter(e -> e.getValue().size() > 1).flatMap(item -> Stream.of(item.getKey())).collect(Collectors.toSet());
            if(CollectionUtils.isNotEmpty(repeatKey)) {
                StringBuilder sp = new StringBuilder();
                BrandApplyDetailEntity tmpDetail = null;
                for(String k : repeatKey) {
                    tmpDetail = detailMap.get(k).get(0);
                    sp.append("操作失败，存在重复的品牌关系：物料分类[").append(tmpDetail.getMaterialTypeName()).append("],").append("品牌名称[").append(tmpDetail.getBrandName())
                            .append("],供应商名称[").append(tmpDetail.getSupplierName()).append("]、");
                }
                return CommonResponse.error(sp.substring(0, sp.length()-1));
            }
        }

    	service.saveOrUpdate(entity, false);
    	BrandApplyVO vo = BeanMapper.map(entity, BrandApplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BrandApplyVO> queryDetail(Long id) {
    	BrandApplyEntity entity = service.selectById(id);
    	BrandApplyVO vo = BeanMapper.map(entity, BrandApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BrandApplyVO> vos) {
        service.removeByIds(vos.stream().map(BrandApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BrandApplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("secOrgName");
        fuzzyFields.add("brandNames");
        fuzzyFields.add("secOrgCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<BrandApplyEntity> page = service.queryPage(param,false);
        IPage<BrandApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BrandApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("secOrgName");
        fuzzyFields.add("brandNames");
        fuzzyFields.add("secOrgCode");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<BrandApplyEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<BrandApplyVO> voList = BeanMapper.mapList(list, BrandApplyVO.class);
        voList.stream().forEach(item -> item.setBillStateStr(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription()));
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("BrandApply-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refBrandApplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BrandApplyVO>> refBrandApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BrandApplyEntity> page = service.queryPage(param,false);
        IPage<BrandApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BrandApplyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
