package com.ejianc.business.zdsmaterial.plan.control.controller;

import java.io.Serializable;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.erp.service.IOrderDetailService;
import com.ejianc.business.zdsmaterial.pick.service.ISubsetMaterialService;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanEntity;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanService;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanSumDetailVO;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanVO;
import com.ejianc.business.zdsstore.api.IStoreFlowApi;
import com.ejianc.business.zdsstore.api.IStoreManageApi;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumEntity;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumService;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanSumVO;

/**
 * 物资总控计划汇总
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("controlPlanSum")
public class ControlPlanSumController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IControlPlanSumService service;

    @Autowired
    private IControlPlanService controlService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IOrderDetailService orderDetailService;

    @Autowired
    private IStoreFlowApi storeFlowApi;

    @Autowired
    private IStoreManageApi storeManageApi;

    @Autowired
    private ISubsetMaterialService subsetMaterialService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ControlPlanSumVO> saveOrUpdate(@RequestBody ControlPlanSumVO saveOrUpdateVO) {
    	ControlPlanSumVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ControlPlanSumVO> queryDetail(Long id) {
    	ControlPlanSumEntity entity = service.selectById(id);
    	ControlPlanSumVO vo = BeanMapper.map(entity, ControlPlanSumVO.class);
        // 编制情况子表
    	QueryParam param = new QueryParam();
    	param.getParams().put("projectId", new Parameter(QueryParam.EQ, entity.getProjectId()));
    	List<ControlPlanEntity> list = controlService.queryList(param);
    	vo.setBillList(BeanMapper.mapList(list, ControlPlanVO.class));

    	//查询子表物资的已提订单量
        List<Long> materialIds = vo.getDetailList().stream().map(ControlPlanSumDetailVO::getMaterialId).collect(Collectors.toList());
        //查询字表物资入库数量
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ, entity.getProjectId())); //项目过滤
        queryParam.getParams().put("effectiveState",new Parameter(QueryParam.EQ,1)); //生效状态
        queryParam.getParams().put("materialId",new Parameter(QueryParam.IN, materialIds)); //物资I滴
//        queryParam.getParams().put("inOutType",new Parameter(QueryParam.EQ, 1)); //入库
        CommonResponse<List<FlowVO>> flowResp = storeFlowApi.getFlowList(queryParam);
        Map<Long, List<FlowVO>> flowMaps = new HashMap<>();
        if(flowResp.isSuccess()) {
            if(CollectionUtils.isNotEmpty(flowResp.getData())) {
                flowMaps.putAll(flowResp.getData().stream().collect(Collectors.groupingBy(FlowVO::getMaterialId)));
            }
        } else {
            logger.error("总控计划汇总子表入库数量查询失败，参数：{}, 结果：{}", JSONObject.toJSONString(queryParam, SerializerFeature.PrettyFormat),
                    JSONObject.toJSONString(flowResp, SerializerFeature.PrettyFormat));
        }

        //查询库存数量
        Map<Long, List<SurplusVO>> materialMap = new HashMap<>();
        List<SurplusVO> vos = new ArrayList<>();
        materialIds.stream().forEach(e -> {
            SurplusVO surplusVO = new SurplusVO();
            surplusVO.setMaterialId(e);
            surplusVO.setProjectId(entity.getProjectId());
            vos.add(surplusVO);
        });
        CommonResponse<List<SurplusVO>> surplusResponse = storeManageApi.querySurplusBatch(vos);
        if(surplusResponse.isSuccess()) {
            if(CollectionUtils.isNotEmpty(surplusResponse.getData())) {
                materialMap.putAll(surplusResponse.getData().stream().collect(Collectors.groupingBy(e -> e.getMaterialId())));
            }
        } else {
            logger.error("总控计划汇总子表库存数量查询失败，参数：{}, 结果：{}", JSONObject.toJSONString(vos, SerializerFeature.PrettyFormat),
                    JSONObject.toJSONString(surplusResponse, SerializerFeature.PrettyFormat));
        }
        //查询分包领料数量
//        subsetMaterialService.getNumMap()

        if(CollectionUtils.isNotEmpty(materialIds)) {
            List<Map<String, Object>> orderNums = orderDetailService.getMaterialOrderNums(entity.getProjectId(), materialIds);
            Map<Long, Map<String, Object>> orderNumMap = orderNums.stream().collect(Collectors.toMap(m -> Long.valueOf(m.get("materialId").toString()), m -> m));
            vo.getDetailList().stream().forEach(detail -> {
                if(orderNumMap.containsKey(detail.getMaterialId())) {
                    detail.setPurchaseNum(new BigDecimal(orderNumMap.get(detail.getMaterialId()).get("orderNum").toString()));
                    detail.setDeliveryNum(new BigDecimal(orderNumMap.get(detail.getMaterialId()).get("deliveryNum").toString()));
                    detail.setAcceptNum(new BigDecimal(orderNumMap.get(detail.getMaterialId()).get("acceptNum").toString()));
                } else {
                    detail.setPurchaseNum(BigDecimal.ZERO);
                    detail.setDeliveryNum(BigDecimal.ZERO);
                    detail.setAcceptNum(BigDecimal.ZERO);
                }

                if (flowMaps.containsKey(detail.getMaterialId())){
                    detail.setInStoreNum(flowMaps.get(detail.getMaterialId()).stream().filter(item -> Integer.valueOf(1).equals(item.getInOutFlag())).map(e -> e.getNum()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd));
                    detail.setPickNum(flowMaps.get(detail.getMaterialId()).stream().filter(item -> Integer.valueOf(2).equals(item.getInOutFlag()) && (InOutTypeEnum.领料出库.getInOutType().equals(item.getInOutType()) || InOutTypeEnum.直入直出出库.getInOutType().equals(item.getInOutType()))).map(e -> e.getNum()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd));
                } else {
                    detail.setInStoreNum(BigDecimal.ZERO);
                    detail.setPickNum(BigDecimal.ZERO);
                }
                if (materialMap.containsKey(detail.getMaterialId())){
                    detail.setSurplusNum(materialMap.get(detail.getMaterialId()).stream().map(e -> e.getSurplusNum()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd));
                } else {
                    detail.setSurplusNum(BigDecimal.ZERO);
                }
            });
        }

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ControlPlanSumVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ControlPlanSumVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ControlPlanSumVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ControlPlanSumVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("billName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("engineerName");
        fuzzyFields.add("managerName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("materialTypeNames");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ControlPlanSumEntity> page = service.queryPage(param,false);
        IPage<ControlPlanSumVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ControlPlanSumVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("billName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("engineerName");
        fuzzyFields.add("managerName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("materialTypeNames");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ControlPlanSumEntity> list = service.queryList(param);
        List<ControlPlanSumVO> records = BeanMapper.mapList(list, ControlPlanSumVO.class);
        records.forEach(vo->{
            vo.setChangeStatusName(PlanConstant.CHANGE_STATUS.get(vo.getChangeStatus()));
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("ControlPlanSum-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
//     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refControlPlanSumData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ControlPlanSumVO>> refControlPlanSumData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ControlPlanSumEntity> page = service.queryPage(param,false);
        IPage<ControlPlanSumVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ControlPlanSumVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
