package com.ejianc.business.zdsmaterial.accept.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.accept.AcceptVO;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptDetailEntity;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.accept.service.IAcceptService;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.enums.DeliveryAcceptStatusEnums;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryService;
import com.ejianc.business.zdsmaterial.erp.service.IExpenseAccountDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsmaterial.erp.vo.OrderVO;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialSourceVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsstore.api.IStoreManageApi;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierApi;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.business.zdssupplier.sub.api.ISubSupplierApi;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("accept") 
public class AcceptBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
	private IAcceptService service;
	@Autowired
	private IStoreManageApi storeManageApi;
	@Autowired
	private IDeliveryService deliveryService;
	@Autowired
	private IOrderService  orderService;
	@Autowired
	private IDeliveryDetailService deliveryDetailService;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IExpenseAccountDetailService expenseAccountDetailService;

	@Autowired
	private IMatSupplierApi matSupplierApi;

	@Autowired
	private ISubSupplierApi subSupplierApi;

	public static final String BILL_TYPE_OTHER_ACCEPT = "EJCBT202312000020";
	public static final String BILL_TYPE_ACCEPT = "EJCBT202312000001";
	public static final String PC_URL_OTHER_ACCEPT = "ejc-zdsmaterial-frontend/#/otherAccept/card";
	public static final String PC_URL_ACCEPT = "ejc-zdsmaterial-frontend/#/acceptList/acceptCard";
	@Autowired
	private IMaterialService materialService;
	@Value("${common.env.base-host}")
	private String baseHost;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		AcceptEntity entity = service.selectById(billId);
		if (CollectionUtils.isEmpty(entity.getDetailList())){
			return CommonResponse.error("明细为空，当前单据不能提交！");
		}

		if(PlanConstant.零星材料入库.equals(entity.getAcceptMaterialType())) {
			//回写报销单明细 占用入库量
			Map<Long, BigDecimal> nums = entity.getDetailList().stream().collect(Collectors.toMap(detail -> detail.getSourceDetailId(),
					detail -> detail.getDetailNum()));
			String msg = expenseAccountDetailService.handleAcceptNum(entity.getOrderBillId(), nums, true);
			if(StringUtils.isNotEmpty(msg)) {
				logger.error("零星材料入库id-{} 回写报销单id:{} 明细 占用入库量失败，原因：{}", entity.getId(), entity.getOrderBillId(), msg);
				return CommonResponse.error(msg);
			}
		} else {
			//查询对应供应商是否开通协同账户
			if (entity.getSourceType()==0||entity.getSourceType()==1) {
				CommonResponse<MatSupplierVO> supplierResp = matSupplierApi.getOneById(entity.getSupplierId());
				if(!supplierResp.isSuccess()) {
					logger.error("验收单提交-{}失败，根据id-{}获取供应商信息失败,{}", entity.getId(), entity.getSupplierId(), JSONObject.toJSONString(supplierResp));
					return CommonResponse.error("操作失败，获取供方信息失败");
				}
				MatSupplierVO supplier = supplierResp.getData();
				if(PlanConstant.STRING_NO.equals(supplier.getCoordination())) {
					logger.error("验收单提交-{}失败，供应商id-{}未开通协同账号", entity.getId(), entity.getSupplierId());
					return CommonResponse.error("操作失败，验收单对应供应商联系人未开通协同账号！");
				}
			}

			if(entity.getAcceptType()==1) {
				if(null == entity.getSubcontractorId()) {
					return CommonResponse.error("操作失败，未选择分包合同");
				}
				CommonResponse<SupplierVO> supplierResp = subSupplierApi.getOneById(entity.getSubcontractorId());
				if(!supplierResp.isSuccess()) {
					logger.error("验收单提交-{}失败，根据id-{}获取分包商信息失败,{}", entity.getId(), entity.getSubcontractorId(), JSONObject.toJSONString(supplierResp));
					return CommonResponse.error("操作失败，获取分包商信息失败");
				}
				SupplierVO supplier = supplierResp.getData();
				if(PlanConstant.STRING_NO.equals(supplier.getCoordination())) {
					logger.error("验收单提交-{}失败，供应商id-{}未开通协同账号", entity.getId(), entity.getSubcontractorId());
					return CommonResponse.error("操作失败，验收单对应分包商联系人未开通协同账号！");
				}
			}
		}
		return CommonResponse.success();
	};
	public void returnDeliveryOrOrder(AcceptEntity entity, Integer sourceType, Boolean status) {
		for (AcceptDetailEntity detail :entity.getDetailList()){
			detail.setCheckNum(detail.getDetailNum());
		}
		//查询基于当前发货单 一共有
		if (sourceType == 0) {
			if (null != entity.getId()&&status) {
				AcceptEntity accept = service.selectById(entity.getId());
				List<AcceptDetailEntity> detailList = accept.getDetailList();
				Map<Long, AcceptDetailEntity> collect = detailList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
				List<AcceptDetailEntity> detailList1 = entity.getDetailList();
				if (!collect.isEmpty()) {
					for (AcceptDetailEntity detail : detailList1) {
						if (collect.containsKey(detail.getId())) {
							if (!"del".equals(detail.getRowState())) {
								BigDecimal detailNum = detail.getDetailNum();
								BigDecimal detailNum1 = collect.get(detail.getId()).getDetailNum();
								detail.setCheckNum(ComputeUtil.safeSub(detailNum,detailNum1));
							}

						}
					}
				}
			}
			deliveryService.returnDeliveryOrOrder(entity, status);
		} else if (sourceType == 1) {
			orderService.returnHandAcceptNum(entity, status);
		}
	}
	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		AcceptEntity checkEntity = service.selectById(billId);
		if(PlanConstant.零星材料入库.equals(checkEntity.getAcceptMaterialType())) {
			//回写报销单明细 释放入库量
			Map<Long, BigDecimal> nums = checkEntity.getDetailList().stream().collect(Collectors.toMap(detail -> detail.getSourceDetailId(),
					detail -> detail.getDetailNum()));
			String msg = expenseAccountDetailService.handleAcceptNum(checkEntity.getOrderBillId(), nums, false);
			if(StringUtils.isNotEmpty(msg)) {
				logger.error("零星材料入库id-{} 回写报销单id:{} 明细 释放入库量失败，原因：{}", checkEntity.getId(), checkEntity.getOrderBillId(), msg);
				return CommonResponse.error(msg);
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		AcceptEntity entity = service.selectById(billId);

		//验收单生效保存
		service.saveBillEffect(entity);

		// 0:正常验收;1:直入直出;
		if (entity.getAcceptType()==1&&entity.getSubcontractorId()!=null){
			//TODO 推送入供方领料 未签字
			service.pushSubReturn(entity, InvocationInfoProxy.getUserid(), entity.getAcceptType() != 1);
		}else if(!PlanConstant.零星材料入库.equals(entity.getAcceptMaterialType())) {
			if (entity.getSupplierId()!=null){
				service.pushSubAccept(entity, InvocationInfoProxy.getUserid(), entity.getAcceptType() != 1);
			} else {
				service.inToStore(entity,true, InvocationInfoProxy.getUserid());
			}
		}

//		if(entity.getAcceptType()==1){
//			service.inToStore(entity,false, InvocationInfoProxy.getUserid());
//		}else {
//			service.inToStore(entity,true, InvocationInfoProxy.getUserid());
//		}

		//推送档案库
		//查询当前档案是否已在档案库
		if(CollectionUtils.isNotEmpty(entity.getDetailList())) {
			pushMaterial(entity);
		}


		//推送仓库
		return CommonResponse.success();
	}

	private void pushMaterial(AcceptEntity entity) {

		try {
			List<Long> materialIds = entity.getDetailList().stream().map(AcceptDetailEntity::getId).collect(Collectors.toList());
			List<MaterialVO> materialDbList = materialService.queryDetailList(materialIds, false);
			Map<Long, MaterialVO> dbMap = materialDbList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
			List<MaterialVO> addList = new ArrayList<>();
			for(AcceptDetailEntity detail : entity.getDetailList()) {
				if(!dbMap.containsKey(detail.getMaterialId())) {
					addList.add(generateNewMaterial(detail, entity));
				}
			}
			if(CollectionUtils.isNotEmpty(addList)) {
				List<MaterialVO> addResp = materialService.addNewMaterialsFromBill(addList);

				Map<String, List<MaterialVO>> map = addResp.stream().collect(
						Collectors.groupingBy(
								s->s.getName()+'-'+(StringUtils.isNotBlank(s.getPropertyShowName()) ? s.getPropertyShowName():"")+'-'+s.getUnitId()
						));
				for (AcceptDetailEntity detail : entity.getDetailList()){
					String key = detail.getMaterialName() + "-" + (StringUtils.isNotBlank(detail.getPropertyValue()) ? detail.getPropertyValue() : "")
							+ "-" + detail.getDetailUnitId();
					if (map.containsKey(key)) {
						MaterialVO materialVOS1 = map.get(key).get(0);
						detail.setMaterialId(materialVOS1.getId());
						detail.setMaterialCode(materialVOS1.getCode());
					}
				}
			}
		} catch (Exception e) {
			logger.error("物资验收id-{}物料推送档案库异常", entity.getId());
			logger.error("物资验收物料推送档案库异常", e);

			entity.setNewMatFlag(3); //标识推送档案库失败
		}
	}

	private MaterialVO generateNewMaterial(AcceptDetailEntity data, AcceptEntity accept) {
		MaterialVO vo = new MaterialVO();
		vo.setId(data.getMaterialId());
		vo.setCode(data.getMaterialCode());
		vo.setName(data.getMaterialName());
		vo.setCategoryId(data.getMaterialTypeId());
		vo.setCategoryCode(data.getMaterialTypeCode());
		vo.setCategoryName(data.getMaterialTypeName());
		vo.setUnitId(data.getDetailUnitId());
		vo.setUnitName(data.getDetailUnitName());
		vo.setProductCode(data.getProductCode());
		vo.setEnabled(ZDSMaterialCommonEnums.停启用_启用.getCode());
		vo.setBlockedFlag(ZDSMaterialCommonEnums.封存_正常.getCode());
		vo.setSystemId("sys");
		vo.setSourceId(String.valueOf(data.getId()));
		vo.setPropertyShowName(data.getPropertyValue());
		vo.setRelationList(new ArrayList<>());
		List<MaterialSourceVO> sourceList = new ArrayList<>();
		MaterialSourceVO materialSourceVO = new MaterialSourceVO();
		materialSourceVO.setMaterialId(data.getMaterialId());
		materialSourceVO.setBillType(AcceptVO.其他收单.equals(accept.getSourceType()) ? BILL_TYPE_OTHER_ACCEPT : BILL_TYPE_ACCEPT);
		materialSourceVO.setBillTypeName(AcceptVO.其他收单.equals(accept.getSourceType()) ? "自制入库":"物资验收");
		materialSourceVO.setSourceBillCode(accept.getBillCode());
		materialSourceVO.setSourcePid(accept.getId());
		materialSourceVO.setSourceDetailId(data.getId());
		materialSourceVO.setSourceBillPcUrl(baseHost + (AcceptVO.其他收单.equals(accept.getSourceType()) ? PC_URL_OTHER_ACCEPT : PC_URL_ACCEPT));
		materialSourceVO.setSourceCreateUserCode(accept.getCreateUserCode());
		materialSourceVO.setSourceCreateUserName(accept.getCreateUserName());
		materialSourceVO.setSourceCreateTime(accept.getCreateTime());
		materialSourceVO.setSourceCreateTime(accept.getCreateTime());
		materialSourceVO.setSourceOrgName(accept.getOrgName());
		sourceList.add(materialSourceVO);
		vo.setSourceList(sourceList);


		return vo;
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能撤回！");
		}
		AcceptEntity checkEntity = service.selectById(billId);

		if(!PlanConstant.零星材料入库.equals(checkEntity.getAcceptMaterialType())) {
			returnDeliveryOrOrder(checkEntity, checkEntity.getSourceType(), false);
		} else {
			//回写报销单明细 释放入库量
			Map<Long, BigDecimal> nums = checkEntity.getDetailList().stream().collect(Collectors.toMap(detail -> detail.getSourceDetailId(),
					detail -> detail.getDetailNum()));
			String msg = expenseAccountDetailService.handleAcceptNum(checkEntity.getOrderBillId(), nums, false);
			if(StringUtils.isNotEmpty(msg)) {
				logger.error("零星材料入库id-{} 回写报销单id:{} 明细 释放入库量失败，原因：{}", checkEntity.getId(), checkEntity.getOrderBillId(), msg);
				return CommonResponse.error(msg);
			}
		}

		if (checkEntity.getSourceType()==0 || checkEntity.getSourceType()==1){
			if(!PlanConstant.零星材料入库.equals(checkEntity.getAcceptMaterialType())) {
				QueryWrapper<AcceptEntity> queryWrapper = new QueryWrapper();
				queryWrapper.eq("contract_id",checkEntity.getContractId());
				queryWrapper.notIn("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
						BillStateEnum.PASSED_STATE.getBillStateCode()));
				int count  = service.count(queryWrapper);
				if (count>0){
					throw new BusinessException("一个合同只有存在一个自由态的验收单!");
				}
			}
			QueryWrapper<AcceptEntity> queryWrapper1 = new QueryWrapper();

			if (checkEntity.getSourceType()==0 || PlanConstant.零星材料入库.equals(checkEntity.getAcceptMaterialType())){
				queryWrapper1.eq("order_bill_id",checkEntity.getOrderBillId());
			}else {
				queryWrapper1.eq("delivery_bill_id",checkEntity.getDeliveryBillId());
			}
			queryWrapper1.eq("source_type",checkEntity.getSourceType());
			queryWrapper1.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
					BillStateEnum.PASSED_STATE.getBillStateCode()));
			queryWrapper1.orderByDesc("create_time");
			List<AcceptEntity> list = service.list(queryWrapper1);
			if (!(list.get(0).getId().equals(checkEntity.getId()))){
				throw new BusinessException("最新的单据才可以撤回!");
			}
		}

		if(!PlanConstant.零星材料入库.equals(checkEntity.getAcceptMaterialType())) {
			if (checkEntity.getMaterialSignatureStatus()==1){
				return CommonResponse.error("供方已签字,无法撤回!");
			}else {
				String s = service.deletePickReturnBill(checkEntity);
				if (StringUtils.isNotBlank(s)){
					return CommonResponse.error(s);
				}
			}
		}

		if (checkEntity.getSignatureStatus()==1){
			return CommonResponse.error("分包商已签字,无法撤回!");
		}else if (checkEntity.getSourceType()==2){
			String s = service.deleteReturnBill(checkEntity);
			if (StringUtils.isNotBlank(s)){
				return CommonResponse.error(s);
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		AcceptEntity entity = service.selectById(billId);
		List<Long> ids = new ArrayList<>();
		ids.add(billId);
		StoreManageVO storeManageVO = new StoreManageVO();
		storeManageVO.setSourceId(entity.getId());
		storeManageVO.setStoreId(entity.getStoreId());
		if (entity.getAcceptType() == 0){
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.收料入库);
		}else {
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.直入直出入库);
		}
		storeManageVO.setOutEffectiveON(true);
		String stringInfo = JSONObject.toJSONString(storeManageVO);
		logger.info("撤回参数：" +stringInfo);
		CommonResponse<StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
		if(!response.isSuccess()) {
			return CommonResponse.error(response.getMsg());
		}else{
			logger.info("xhc推送仓库成功:"+response.getMsg());
		}

		if (entity.getSourceType()==0){
			if (0==entity.getFinalAcceptFlag()&&0==entity.getCloseDelivery()){
				//部分验收 不关闭只是修改发货单的验收状态
				deliveryService.updateAcceptStatus(entity.getDeliveryBillId(), DeliveryAcceptStatusEnums.验收中.getCode());
			}else if (1==entity.getFinalAcceptFlag()&&1==entity.getCloseDelivery()){
				//匹配全部验收 修改发货单全部验收
				deliveryService.updateAcceptStatus(entity.getDeliveryBillId(), DeliveryAcceptStatusEnums.验收中.getCode());
			}else if (0==entity.getFinalAcceptFlag()&&1==entity.getCloseDelivery()){
				//不匹配全部验收 关闭发货单 释放金额赋值
				deliveryService.updateAcceptStatus(entity.getDeliveryBillId(), DeliveryAcceptStatusEnums.验收中.getCode());
				deliveryDetailService.updateDeliveryResNum(entity,false);
			}
		}
		if (entity.getSourceType()==0||entity.getSourceType()==1){
			if (entity.getSourceType()==0){
				DeliveryEntity deliveryEntity = deliveryService.selectById(entity.getDeliveryBillId());
				String s = deliveryService.updateSupDelivery(deliveryEntity);
				if (StringUtils.isNotBlank(s)){
					throw new BusinessException(s);
				}
			}
			OrderEntity orderEntity = orderService.selectById(entity.getOrderBillId());
			String supBusiness = orderService.pushToSupBusiness(BeanMapper.map(orderEntity, OrderVO.class));
			if (StringUtils.isNotBlank(supBusiness)){
				throw new BusinessException(supBusiness);
			}
		}

		// 取消生效
		entity.setEffectDate(null);
		entity.setApproveUserId(null);
		entity.setApproveUserName(null);
		service.saveOrUpdate(entity, false);
		return CommonResponse.success();
	}

}
