package com.ejianc.business.zdsmaterial.asynchandler.consumer;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.asynchandler.service.ISyncJobExecRecordService;
import com.ejianc.business.zdsmaterial.erp.vo.LinkerAccCooVO;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 接受并保存推送ERP数据记录
 *
 * @author CJ
 * @Description:
 * @date 2024/4/24 11:31
 */
@Component
public class LinkerAccCooListener extends BaseConsumer {

    public static final String LINKER_ACC_QUEUE = "linker_acc_coo_queue";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${spring.cloud.config.profile}")
    private String profile;


    @Autowired
    private ISyncJobExecRecordService service;

    @Override
    protected void doConsumeMsg(MqMessage mqMessage) {
        logger.info("接收到待开通协同账号数据记录：{}", mqMessage.getBody());
        try {
            LinkerAccCooVO accParam = JSONObject.parseObject(mqMessage.getBody().toString(), LinkerAccCooVO.class);
            if(StringUtils.isBlank(accParam.getLinkerType())) {
                logger.error("********ERROR**********联系人协同账号开通失败，缺少参数: 联系人类型-linkerType**************ERROR***************");
            }
            if(CollectionUtils.isEmpty(accParam.getLinkerIds())) {
                logger.error("********ERROR**********联系人协同账号开通失败，缺少参数: 联系人类型-linkerType**************ERROR***************");
            }
            for(Long linkerId : accParam.getLinkerIds()) {
                service.linkerAccCoo(accParam.getLinkerType(), linkerId);
            }
        } catch (Exception e) {
            logger.error("开通协同账号数据记录处理异常: ", e);
        }
    }

    @Override
    protected String[] getQueueNames() {
        return new String[]{LINKER_ACC_QUEUE+"_1"+profile};
    }
}
