package com.ejianc.business.zdsmaterial.cloudstore.shelf.controller;

import java.io.Serializable;

import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsstore.api.IStoreApi;
import com.ejianc.business.zdsstore.vo.StoreVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.zdsmaterial.cloudstore.shelf.bean.GoodsEntity;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.service.IGoodsService;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.GoodsVO;

/**
 * 物资集市
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("goods")
public class GoodsController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IStoreApi storeApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IGoodsService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GoodsVO> saveOrUpdate(@RequestBody GoodsVO saveOrUpdateVO) {
    	GoodsEntity entity = BeanMapper.map(saveOrUpdateVO, GoodsEntity.class);
//    	if(entity.getId() == null || entity.getId() == 0){
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
//        }
    	service.saveOrUpdate(entity, false);
    	GoodsVO vo = BeanMapper.map(entity, GoodsVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GoodsVO> queryDetail(Long id) {
    	GoodsEntity entity = service.selectById(id);
    	GoodsVO vo = BeanMapper.map(entity, GoodsVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GoodsVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (GoodsVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(GoodsVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     *
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialTypeCode");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("productCode");
        fuzzyFields.add("propertyValue");
        fuzzyFields.add("brandName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("sellUserName");
        fuzzyFields.add("corpName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        List<Long> orgIds = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(orgIds)){
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        }
        // 处理查询参数
        this.transferQueryParam(param);

//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
//        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<GoodsEntity> page = service.queryPage(param,false);
        IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), GoodsVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 处理查询参数
     * @param param
     * type: goods-物资集市，orgOn-大区上架，orgOut-大区下架，projectOn-项目上架，projectOut-项目下架
     */
    private String transferQueryParam(QueryParam param) {
        String type = "goods";
        if(param.getParams().containsKey("type")){
            type = String.valueOf(param.getParams().get("type").getValue());
            param.getParams().remove("type");
        } else {
            param.getParams().remove("orgId");
        }
        Integer status = PlanConstant.GOODS_STATUS_ON;
        Integer storeType = PlanConstant.STORE_TYPE_PROJECT;
        if("orgOn".equals(type)){
            status = PlanConstant.GOODS_STATUS_ON;
            storeType = PlanConstant.STORE_TYPE_ORG;
        } else if("orgOut".equals(type)) {
            status = PlanConstant.GOODS_STATUS_OUT;
            storeType = PlanConstant.STORE_TYPE_ORG;
        } else if("projectOn".equals(type)) {
            status = PlanConstant.GOODS_STATUS_ON;
            storeType = PlanConstant.STORE_TYPE_PROJECT;
        } else if("projectOut".equals(type)) {
            status = PlanConstant.GOODS_STATUS_OUT;
            storeType = PlanConstant.STORE_TYPE_PROJECT;
        }
        param.getParams().put("status", new Parameter(QueryParam.EQ, status));
        if(!type.equals("goods")){
            param.getParams().put("storeType", new Parameter(QueryParam.EQ, storeType));
        }

        // 是否我发布的
        if(param.getParams().containsKey("isMyGoods")){
            String isMyGoods = String.valueOf(param.getParams().get("isMyGoods").getValue());
            param.getParams().remove("isMyGoods");
            if(isMyGoods.contains("0") && isMyGoods.contains("1")){
                param.getParams().remove("sellUserId");
            }else if(isMyGoods.contains("0")){
                param.getParams().put("sellUserId", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
            }else if(isMyGoods.contains("1")){
                param.getParams().put("sellUserId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
            }
        }

//        Long parentOrgId = InvocationInfoProxy.getOrgId();
//        // 仓库穿透
//        if(param.getParams().containsKey("parentOrgId")) {
//            parentOrgId = Long.valueOf(String.valueOf(param.getParams().get("parentOrgId").getValue()));
//            param.getParams().remove("parentOrgId");
//            param.getParams().remove("orgId");
//            // 根据组织查询本上云仓
//            List<Long> cloudStoreIds = this.queryCloudStoreByOrg(parentOrgId);
//            if(CollectionUtils.isNotEmpty(cloudStoreIds)){
//                param.getParams().put("cloudStoreId", new Parameter(QueryParam.IN, cloudStoreIds));
//            } else {
//                param.getParams().put("0", new Parameter(QueryParam.EQ, 1));
//            }
//        }

        // 是否本区域
        if(param.getParams().containsKey("range")){
            String range = String.valueOf(param.getParams().get("range").getValue());
            param.getParams().remove("range");
            // 根据组织查询本上云仓
            List<Long> cloudStoreIds = this.queryCloudStoreByOrg(InvocationInfoProxy.getOrgId());
            if(CollectionUtils.isNotEmpty(cloudStoreIds)){
                if(range.contains("this") && range.contains("other")){
                    param.getParams().remove("cloudStoreId");
                }else if(range.contains("this")){
                    param.getParams().put("cloudStoreId", new Parameter(QueryParam.IN, cloudStoreIds));
                }else if(range.contains("other")){
                    param.getParams().put("cloudStoreId", new Parameter(QueryParam.NOT_IN, cloudStoreIds));
                }
            } else {
                // 没有建立本上云仓，其他大区也能查询到
                if(range.contains("other")){
                    param.getParams().remove("cloudStoreId");
                }else if(range.contains("this")){
                    param.getParams().put("0", new Parameter(QueryParam.EQ, 1));
                }
            }
            param.getParams().remove("orgId");
        }
        return type;
    }

    /**
     * 根据组织查询本上云仓
     * @param orgId
     * @return
     */
    private List<Long> queryCloudStoreByOrg(Long orgId) {
        CommonResponse<List<StoreVO>> resp = storeApi.queryCloudStoreByOrg(orgId);
//        if(!resp.isSuccess()){
//            throw new BusinessException(resp.getMsg());
//        }
        List<Long> cloudStoreIds = new ArrayList<>();
        if(resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())){
            cloudStoreIds = resp.getData().stream().map(StoreVO::getId).collect(Collectors.toList());
        }
        return cloudStoreIds;
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialTypeCode");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("productCode");
        fuzzyFields.add("propertyValue");
        fuzzyFields.add("brandName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("sellUserName");
        fuzzyFields.add("corpName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        // 处理查询参数
        String type = this.transferQueryParam(param);

        List<GoodsEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<GoodsVO> voList = BeanMapper.mapList(list, GoodsVO.class);
        voList.forEach(e -> {
            e.setAttrFlagName(PlanConstant.ATTR_FLAG.get(e.getAttrFlag()));
        });
        beans.put("records", voList);
        if("orgOn".equals(type) || "orgOut".equals(type)){
            ExcelExport.getInstance().export("Goods-org-export.xlsx", beans, response);
        } else if("projectOn".equals(type) || "projectOut".equals(type)){
            ExcelExport.getInstance().export("Goods-project-export.xlsx", beans, response);
        } else {
            ExcelExport.getInstance().export("Goods-export.xlsx", beans, response);
        }
    }

    /**
     * @Description 参照
//     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refGoodsData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> refGoodsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<GoodsEntity> page = service.queryPage(param,false);
        IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GoodsVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description updateStatus 下架
     */
    @RequestMapping(value = "/updateStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> updateStatus(@RequestBody List<GoodsVO> vos) {
        if(CollectionUtils.isEmpty(vos)){
            return CommonResponse.success("操作成功！", true);
        }
        List<Long> ids = vos.stream().map(GoodsVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<GoodsEntity> list = service.queryList(param);
        for(GoodsEntity entity : list){
            entity.setStatus(PlanConstant.GOODS_STATUS_OUT);//下架
            entity.setLowerType(PlanConstant.OUT_TYPE_HAND);//下架类型0-手动下架，1-售罄下架，2-到期下架
            entity.setLowerId(InvocationInfoProxy.getUserid());
            entity.setLowerName(sessionManager.getUserContext().getUserName());
            entity.setLowerCode(InvocationInfoProxy.getUsercode());
            entity.setLowerTime(DateFormater.getCurrentDate());
            entity.setLowerNum(entity.getSurplusNum());
            entity.setSurplusNum(null);
            if(ComputeUtil.isNotEmpty(entity.getAllotNum())){
                throw new BusinessException("【" + entity.getMaterialCode()+ "+" + entity.getMaterialName() + "+" + entity.getPropertyValue() + "】存在交易中的订单,不允许下架！");
            }
        }
        service.saveOrUpdateBatch(list);

        // 调用库存逻辑
        service.inOutStoreRollback(list);
        return CommonResponse.success("操作成功！", true);
    }
}
