package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.erp.bean.ExpenseAccountEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.ExpenseAccountMapper;
import com.ejianc.business.zdsmaterial.erp.service.IExpenseAccountService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2024/10/22 17:18
 */
@Service("expenseAccountService")
public class ExpenseAccountServiceImpl extends BaseServiceImpl<ExpenseAccountMapper, ExpenseAccountEntity> implements IExpenseAccountService {
    @Override
    public List<ExpenseAccountEntity> getAllBySourceIds(List<String> sourceIds) {
        QueryWrapper<ExpenseAccountEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("source_id", sourceIds);
        return super.list(query);
    }
}
