package com.ejianc.business.zdsmaterial.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * 材料明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material")
public class MaterialEntity extends BaseEntity {

    private static final long serialVersionUID = 9054320635849122578L;
    @ApiModelProperty("编码")
    @TableField(value="code")
    private String code;
    @ApiModelProperty("名称")
    @TableField(value="name")
    private String name;
    @ApiModelProperty("计量单位Id")
    @TableField(value="unit_id")
    private Long unitId;
    @ApiModelProperty("计量单位名称")
    @TableField(value="unit_name")
    private String unitName;
    @ApiModelProperty("所属分类名称")
    @TableField(value="category_name")
    private String categoryName;
    @ApiModelProperty("所属分类Id")
    @TableField(value="category_id")
    private Long categoryId;
    @ApiModelProperty("所属分类编码")
    @TableField(value="category_code")
    private String categoryCode;
    @ApiModelProperty("属性展示名称")
    @TableField(value="property_show_name")
    private String propertyShowName; //
    @ApiModelProperty("停启用标识：0-停用，1-启用")
    @TableField(value="enabled")
    private Integer enabled;

    @ApiModelProperty("封存状态：0-正常，1-封存")
    @TableField(value = "blocked_flag")
    private Integer blockedFlag;

    @ApiModelProperty("来源系统Id")
    @TableField(value="system_id")
    private String systemId;
    @ApiModelProperty("来源系统业务Id")
    @TableField(value="source_id")
    private String sourceId;

    @ApiModelProperty("备注")
    @TableField(value = "remark")
    private String remark;

    @ApiModelProperty("产品代码")
    @TableField(value = "product_code")
    private String productCode;

    @ApiModelProperty("自定义产品代码标识：0-通用产品代码（默认），1-自定义")
    @TableField(value = "product_code_custom_flag")
    private Integer productCodeCustomFlag;

    @ApiModelProperty("物资属性关系列表")
    @TableField(exist = false)
    @SubEntity(serviceName = "materialPropertyRelationService", pidName = "materialId")
    List<MaterialPropertyRelationEntity> relationList = new ArrayList<>();

    @TableField(value = "valid_flag")
    @ApiModelProperty("是否生效：0-未生效（业务单据推送待准入），1-已生效，2-作废未生效（准入时修改了属性，生成新的物料）")
    private Integer validFlag;

    @TableField(exist = false)
    @ApiModelProperty("物资来源单据列表")
    @SubEntity(serviceName = "materialSourceService", pidName = "materialId")
    List<MaterialSourceEntity> sourceList = new ArrayList<>();

    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }

    public List<MaterialSourceEntity> getSourceList() {
        return sourceList;
    }

    public void setSourceList(List<MaterialSourceEntity> sourceList) {
        this.sourceList = sourceList;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public Integer getProductCodeCustomFlag() {
        return productCodeCustomFlag;
    }

    public void setProductCodeCustomFlag(Integer productCodeCustomFlag) {
        this.productCodeCustomFlag = productCodeCustomFlag;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public List<MaterialPropertyRelationEntity> getRelationList() {
        return relationList;
    }

    public void setRelationList(List<MaterialPropertyRelationEntity> relationList) {
        this.relationList = relationList;
    }

    public Integer getBlockedFlag() {
        return blockedFlag;
    }

    public void setBlockedFlag(Integer blockedFlag) {
        this.blockedFlag = blockedFlag;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }
    public String getPropertyShowName() {
        return propertyShowName;
    }

    public void setPropertyShowName(String propertyShowName) {
        this.propertyShowName = propertyShowName;
    }
    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }
}
