package com.ejianc.business.zdsmaterial.material.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.material.bean.MatFeeApplyEntity;
import com.ejianc.business.zdsmaterial.material.service.IMatFeeApplyService;
import com.ejianc.business.zdsmaterial.material.vo.MatFeeApplyDetailVO;
import com.ejianc.business.zdsmaterial.material.vo.MatFeeApplyVO;
import com.ejianc.business.zdsmaterial.sub.subvisa.enums.InstructionStatusEnum;
import com.ejianc.business.zdsmaterial.sub.subvisa.vo.SignatureChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资费用申请
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("matFeeApply")
public class MatFeeApplyController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    @Autowired
    private IMatFeeApplyService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MatFeeApplyVO> queryDetail(Long id) {
    	MatFeeApplyEntity entity = service.selectById(id);
    	MatFeeApplyVO vo = BeanMapper.map(entity, MatFeeApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatFeeApplyVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MatFeeApplyVO vo : vos) {
                MatFeeApplyEntity matFeeApplyEntity = service.selectById(vo.getId());
                if (!matFeeApplyEntity.getReceiveStatus().equals(InstructionStatusEnum.已驳回.getStatus())){
                    throw new BusinessException("单据状态不为已驳回，不能删除！");
                }
            }
        }
        service.removeByIds(vos.stream().map(MatFeeApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }





    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MatFeeApplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("purchaseWorkerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("supplierManagerName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<MatFeeApplyEntity> page = service.queryPage(param,false);
        IPage<MatFeeApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<MatFeeApplyVO> matFeeApplyVOS = BeanMapper.mapList(page.getRecords(), MatFeeApplyVO.class);
        matFeeApplyVOS.stream().forEach(matFeeApplyVO -> {
            switch (matFeeApplyVO.getPaymentMethodId()){
                case 1:
                    matFeeApplyVO.setPaymentMethodName("电汇");
                    break;
                case 2:
                    matFeeApplyVO.setPaymentMethodName("银行承兑");
                    break;
                case 3:
                    matFeeApplyVO.setPaymentMethodName("供应链金融");
                    break;
                default:
                    break;
            }
            switch (matFeeApplyVO.getReceiveStatus()){
                case 0:
                    matFeeApplyVO.setReceiveStatusName("待提交");
                    break;
                case 1:
                    matFeeApplyVO.setReceiveStatusName("待审核");
                    break;
                case 2:
                    matFeeApplyVO.setReceiveStatusName("已审核");
                    break;
                case 3:
                    matFeeApplyVO.setReceiveStatusName("已驳回");
                    break;
                case 4:
                    matFeeApplyVO.setReceiveStatusName("审核中");
                    break;
                default:
                    matFeeApplyVO.setReceiveStatusName("待提交");
                    break;
            }
        });


        pageData.setRecords(matFeeApplyVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<MatFeeApplyVO>> iPageCommonResponse = queryList(param);
        List<MatFeeApplyVO> records = new ArrayList<>();
        if (iPageCommonResponse.isSuccess()){
            IPage<MatFeeApplyVO> pageData = iPageCommonResponse.getData();
            records =pageData.getRecords();
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("MatFeeApply-export.xlsx", beans, response);
    }


    /**
     *
     * 接受 推送 作废
     * @param request
     * @return
     */
    @PostMapping(value = "syncBill")
    public CommonResponse<String> syncBill(HttpServletRequest request) {
        return service.syncBill(request);
    }

    @RequestMapping(value = "/pushStatus", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MatFeeApplyVO> pushStatus(Long id) {
        return  service.pushStatus(id);
    }
}
