package com.ejianc.business.zdsmaterial.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.material.bean.MaterialBasePriceContentEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialBasePriceEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MaterialBasePriceMapper;
import com.ejianc.business.zdsmaterial.material.service.IMaterialBasePriceContentService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialBasePriceService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialBasePriceContentVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialBasePriceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 基准价格导入
 * 
 * @author generator
 * 
 */
@Service("materialBasePriceService")
public class MaterialBasePriceServiceImpl extends BaseServiceImpl<MaterialBasePriceMapper, MaterialBasePriceEntity> implements IMaterialBasePriceService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BASE-PRICE-IMPORT";//此处需要根据实际修改
    @Autowired
    private IMaterialBasePriceContentService materialBasePriceContentService;
    @Override
    public CommonResponse<MaterialBasePriceVO> saves(MaterialBasePriceVO saveOrUpdateVO) {
        List<MaterialBasePriceContentVO> materialBasePriceContentList = saveOrUpdateVO.getMaterialBasePriceContentList();
        List<Long> collect = materialBasePriceContentList.stream().map(MaterialBasePriceContentVO::getMaterialId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        if (CollectionUtils.isNotEmpty(collect)){
            queryParam.getParams().put("materialId", new Parameter(QueryParam.IN, collect));
            queryParam.getParams().put("areaName",new Parameter(QueryParam.EQ, saveOrUpdateVO.getAreaName()));
            queryParam.getParams().put("brandName",new Parameter(QueryParam.EQ, saveOrUpdateVO.getBrandName()));
            queryParam.getParams().put("supplierName",new Parameter(QueryParam.EQ, saveOrUpdateVO.getSupplierName()));
            queryParam.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
            queryParam.getParams().put("status",new Parameter(QueryParam.EQ,1));
            List<MaterialBasePriceContentEntity> materialBasePriceContentEntities = materialBasePriceContentService.queryList(queryParam);
            HashMap<Long, MaterialBasePriceContentEntity> map = new HashMap<>();
            materialBasePriceContentEntities.forEach(entity -> {
                if (!map.containsKey(entity.getMaterialId())){
                    map.put(entity.getMaterialId(), entity);
                }else{
                    if (map.get(entity.getMaterialId()).getPublishDate().after(entity.getPublishDate())){
                        map.put(entity.getMaterialId(), entity);
                    }
                }
            });
            materialBasePriceContentList.forEach(vo -> {
                Long materialId = vo.getMaterialId();
                if (map.containsKey(materialId) && map.get(materialId).getPublishDate().after(vo.getPublishDate())){
                    throw new BusinessException("已存在晚于"+vo.getMaterialName()+"该日期的数据");
                }
            });
        }
        MaterialBasePriceEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialBasePriceEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(CollectionUtils.isNotEmpty(entity.getMaterialBasePriceContentList())) {
            entity.getMaterialBasePriceContentList().parallelStream().forEach(detail -> {
                detail.setBrandId(entity.getBrandId());
                detail.setBrandName(entity.getBrandName());
                detail.setSupplierCode(entity.getSupplierCode());
                detail.setSupplierId(entity.getSupplierId());
                detail.setSupplierName(entity.getSupplierName());
                detail.setArea(entity.getArea());
                detail.setAreaName(entity.getAreaName());
            });
        }

        super.saveOrUpdate(entity, false);
        MaterialBasePriceVO vo = BeanMapper.map(entity, MaterialBasePriceVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    @Transactional
    public CommonResponse<String> changeStatus(MaterialBasePriceVO saveOrUpdateVO) {

        Long id = saveOrUpdateVO.getId();
        Integer status = saveOrUpdateVO.getStatus();
        UpdateWrapper<MaterialBasePriceEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("status",status);
        updateWrapper.eq("id",id);
        super.update(updateWrapper);
        UpdateWrapper<MaterialBasePriceContentEntity> wrapper = new UpdateWrapper<>();
        wrapper.set("status",status);
        wrapper.in("baseprice_id",id);
        materialBasePriceContentService.update(wrapper);
        return CommonResponse.success("修改状态成功！");
    }
}
