package com.ejianc.business.zdsmaterial.pricelib.processor;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceSubConditionDetailVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceLibVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * 基准单价计算公式处理器
 *
 * 公式：原材料基准单价
 *
 *
 * @Author: caojie
 * @CreateTime:2025-07-07 10:00
 * @Version: 1.0
 */
@Component
public class SingleBaseUnitPriceProcessor implements BaseCalcProcessor {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean calcBeforeCheck(PriceLibVO priceLibVO, MaterialPriceCalcSubConditionVO calcFormula) {
        if(null == priceLibVO.getBaseMaterialUnitPrice()) {
            logger.error("基准单价公式：SingleBaseUnitPriceProcessor 计算终止，原材料基础价为空, {}", JSONObject.toJSONString(priceLibVO));
            priceLibVO.setCalcContent("未计算：原材料基础价为空");
            return false;
        }

        return true;
    }

    @Override
    public BigDecimal calc(PriceLibVO priceLibVO, MaterialPriceCalcSubConditionVO calcFormula) {

        //公式：原材料基准单价

        if(!calcBeforeCheck(priceLibVO, calcFormula)) {
            return BigDecimal.ZERO;
        }
        priceLibVO.setCalcContent(calcFormula.getCalcDisplayContent());
        MaterialPriceSubConditionDetailVO calcElem = calcFormula.getDetailList().get(0);
        JSONObject params = JSONObject.parseObject(calcFormula.getCalcParams());

        BigDecimal result = priceLibVO.getBaseMaterialUnitPrice();
        //计算  = 原材料基准单价
        priceLibVO.setAdjustedPrice(result);
        priceLibVO.setCalcMny(ComputeUtil.safeMultiply(result, priceLibVO.getSourceNum()));

        return result;
    }
}
