package com.ejianc.business.zdsmaterial.sub.invoice.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 分包发票登记
 *
 * @author generator
 *
 */
 @TableName("ejc_material_sub_invoice")
public class SubInvoiceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="source_contract_id")
    private String sourceContractId; // 合同来源主键
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_code")
    private String supplierCode; // 供应商编码
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="exec_code")
    private String execCode; // 执行编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 单据组织id
    @TableField(value="org_code")
    private String orgCode; // 单据组织编码
    @TableField(value="org_name")
    private String orgName; // 单据组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="exec_headquarters")
    private String execHeadquarters; // 执行总部
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_date")
    private Date billDate; // 单据日期
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_id")
    private Long createUserId; // 制单人Id
    @TableField(value="contract_type")
    private String contractType; // 合同类型
    @TableField(value="main_cont_mny")
    private BigDecimal mainContMny; // 主合同额
    @TableField(value="child_cont_mny")
    private BigDecimal childContMny; // 附加合同额
    @TableField(value="invoice_type")
    private String invoiceType; // 合同约定发票类型
    @TableField(value="order_mny")
    private BigDecimal orderMny; // 订单金额
    @TableField(value="cont_rate")
    private BigDecimal contRate; // 合同税率
    @TableField(value="invoice_header")
    private String invoiceHeader; // 发票抬头
    @TableField(value="tax_create_state")
    private Integer taxCreateState; // 是否税务局代开
    @TableField(value="invoice_cty")
    private String invoiceCty; // 发票种类：1-增值税专用发票2-增值税普通发票3-其他
    @TableField(value="tax_cty_id")
    private Long taxCtyId; // 税收分类
    @TableField(value="tax_cty_code")
    private String taxCtyCode; // 税收分类编码
    @TableField(value="tax_cty_name")
    private String taxCtyName; // 税收分类名称
    @TableField(value="invoice_rate")
    private BigDecimal invoiceRate; // 发票税率
    @TableField(value="total_mny")
    private BigDecimal totalMny; // 发票金额
    @TableField(value="total_tax_mny")
    private BigDecimal totalTaxMny; // 发票金额(含税)
    @TableField(value="total_tax")
    private BigDecimal totalTax; // 税额
    @TableField(value="admin_id")
    private String adminId; // 发票管理员
    @TableField(value="admin_code")
    private String adminCode; // 发票管理员编码
    @TableField(value="admin_name")
    private String adminName; // 发票管理员名称
    @TableField(value="create_user_name")
    private String createUserName; // 创建者名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="sign_state")
    private Integer signState; // 申请状态0-待审核1-已审核2-已驳回
    @TableField(value="source_id")
    private Long sourceId; // 来源主键
    @TableField(value="operate_time")
    private Date operateTime; // 操作时间
    @TableField(value="operate_id")
    private Long operateId; // 操作人id
    @TableField(value="operate_name")
    private String operateName; // 操作人名称
    @TableField(value="system_id")
    private String systemId; // 来源系统主键
    @TableField(value="bill_push_flag")
    private String billPushFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    @TableField(exist = false)
    private String signStateName;
    @TableField(value = "reject_reason")
    private String rejectReason;//驳回原因
    @TableField(value = "push_erp_flag")
    private String pushErpFlag; //推送ERP标识 0-未推送，1-已推送, 2-发票引用不推送
    @TableField(value="source_type")
    private Integer sourceType; // 来源方式：1-自制，2-供方发起
    @TableField(value = "open_ocr_state")
    private String openOcrState; // 是否开启OCR识别：0-未开启，1-已开启

    @TableField(exist=false)
    @SubEntity(serviceName="subInvoiceDetailService", pidName = "mainId")
    private List<SubInvoiceDetailEntity> detailList = new ArrayList<>(); // 分包发票登记-明细
    @TableField(exist=false)
    @SubEntity(serviceName="subInvoiceFileService", pidName = "mainId")
    private List<SubInvoiceFileEntity> fileList = new ArrayList<>(); // 分包发票登记-附件
    @TableField(exist=false)
    @SubEntity(serviceName="subInvoiceOcrService", pidName = "mainId")
    private List<SubInvoiceOcrEntity> ocrList = new ArrayList<>(); // 分包发票登记-OCR附件

    @TableField
    private Long chiefAccountantId; //主管会计Id
    @TableField
    private String chiefAccountantName; //主管会计名称

    @TableField
    private Date commitDate; // 提交日期

    @TableField
    private String commitUserName; // 提交人名称

    @TableField
    private String commitUserCode; // 提交人编码

    @TableField
    private Date effectiveDate; // 生效日期

    @TableField
    private Integer printFlag; //单据是否已打印标识：0-否，1-是

    @TableField
    private Long lastPrintUserId; // 最近打印人id

    @TableField
    private String lastPrintUserName; // 最近打印人名称

    @TableField
    private String lastPrintUserCode; // 最近打印人编码

    private Long finalApproveUserId; // 最终审核人id

    @TableField
    private String finalApproveUserName; // 最终审核人名称

    @TableField
    private String finalApproveUserCode; // 最终审核人编码

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Integer getPrintFlag() {
        return printFlag;
    }

    public void setPrintFlag(Integer printFlag) {
        this.printFlag = printFlag;
    }

    public Long getLastPrintUserId() {
        return lastPrintUserId;
    }

    public void setLastPrintUserId(Long lastPrintUserId) {
        this.lastPrintUserId = lastPrintUserId;
    }

    public String getLastPrintUserName() {
        return lastPrintUserName;
    }

    public void setLastPrintUserName(String lastPrintUserName) {
        this.lastPrintUserName = lastPrintUserName;
    }

    public String getLastPrintUserCode() {
        return lastPrintUserCode;
    }

    public void setLastPrintUserCode(String lastPrintUserCode) {
        this.lastPrintUserCode = lastPrintUserCode;
    }

    public Long getFinalApproveUserId() {
        return finalApproveUserId;
    }

    public void setFinalApproveUserId(Long finalApproveUserId) {
        this.finalApproveUserId = finalApproveUserId;
    }

    public String getFinalApproveUserName() {
        return finalApproveUserName;
    }

    public void setFinalApproveUserName(String finalApproveUserName) {
        this.finalApproveUserName = finalApproveUserName;
    }

    public String getFinalApproveUserCode() {
        return finalApproveUserCode;
    }

    public void setFinalApproveUserCode(String finalApproveUserCode) {
        this.finalApproveUserCode = finalApproveUserCode;
    }

    public Long getChiefAccountantId() {
        return chiefAccountantId;
    }

    public void setChiefAccountantId(Long chiefAccountantId) {
        this.chiefAccountantId = chiefAccountantId;
    }

    public String getChiefAccountantName() {
        return chiefAccountantName;
    }

    public void setChiefAccountantName(String chiefAccountantName) {
        this.chiefAccountantName = chiefAccountantName;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getPushErpFlag() {
        return pushErpFlag;
    }

    public void setPushErpFlag(String pushErpFlag) {
        this.pushErpFlag = pushErpFlag;
    }

    public String getRejectReason() {
        return rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getSourceContractId() {
        return sourceContractId;
    }

    public void setSourceContractId(String sourceContractId) {
        this.sourceContractId = sourceContractId;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getExecCode() {
        return execCode;
    }

    public void setExecCode(String execCode) {
        this.execCode = execCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getExecHeadquarters() {
        return execHeadquarters;
    }

    public void setExecHeadquarters(String execHeadquarters) {
        this.execHeadquarters = execHeadquarters;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    public BigDecimal getMainContMny() {
        return mainContMny;
    }

    public void setMainContMny(BigDecimal mainContMny) {
        this.mainContMny = mainContMny;
    }
    public BigDecimal getChildContMny() {
        return childContMny;
    }

    public void setChildContMny(BigDecimal childContMny) {
        this.childContMny = childContMny;
    }
    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }
    public BigDecimal getOrderMny() {
        return orderMny;
    }

    public void setOrderMny(BigDecimal orderMny) {
        this.orderMny = orderMny;
    }
    public BigDecimal getContRate() {
        return contRate;
    }

    public void setContRate(BigDecimal contRate) {
        this.contRate = contRate;
    }
    public String getInvoiceHeader() {
        return invoiceHeader;
    }

    public void setInvoiceHeader(String invoiceHeader) {
        this.invoiceHeader = invoiceHeader;
    }
    public Integer getTaxCreateState() {
        return taxCreateState;
    }

    public void setTaxCreateState(Integer taxCreateState) {
        this.taxCreateState = taxCreateState;
    }
    public String getInvoiceCty() {
        return invoiceCty;
    }

    public void setInvoiceCty(String invoiceCty) {
        this.invoiceCty = invoiceCty;
    }
    public Long getTaxCtyId() {
        return taxCtyId;
    }

    public void setTaxCtyId(Long taxCtyId) {
        this.taxCtyId = taxCtyId;
    }
    public String getTaxCtyCode() {
        return taxCtyCode;
    }

    public void setTaxCtyCode(String taxCtyCode) {
        this.taxCtyCode = taxCtyCode;
    }
    public String getTaxCtyName() {
        return taxCtyName;
    }

    public void setTaxCtyName(String taxCtyName) {
        this.taxCtyName = taxCtyName;
    }
    public BigDecimal getInvoiceRate() {
        return invoiceRate;
    }

    public void setInvoiceRate(BigDecimal invoiceRate) {
        this.invoiceRate = invoiceRate;
    }
    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }

    public BigDecimal getTotalTaxMny() {
        return totalTaxMny;
    }

    public void setTotalTaxMny(BigDecimal totalTaxMny) {
        this.totalTaxMny = totalTaxMny;
    }

    public BigDecimal getTotalTax() {
        return totalTax;
    }

    public void setTotalTax(BigDecimal totalTax) {
        this.totalTax = totalTax;
    }
    public String getAdminId() {
        return adminId;
    }

    public void setAdminId(String adminId) {
        this.adminId = adminId;
    }
    public String getAdminCode() {
        return adminCode;
    }

    public void setAdminCode(String adminCode) {
        this.adminCode = adminCode;
    }
    public String getAdminName() {
        return adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getSignState() {
        return signState;
    }

    public void setSignState(Integer signState) {
        this.signState = signState;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Date getOperateTime() {
        return operateTime;
    }

    public void setOperateTime(Date operateTime) {
        this.operateTime = operateTime;
    }
    public Long getOperateId() {
        return operateId;
    }

    public void setOperateId(Long operateId) {
        this.operateId = operateId;
    }
    public String getOperateName() {
        return operateName;
    }

    public void setOperateName(String operateName) {
        this.operateName = operateName;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getSignStateName() {
        return signStateName;
    }

    public void setSignStateName(String signStateName) {
        this.signStateName = signStateName;
    }

    public String getOpenOcrState() {
        return openOcrState;
    }

    public void setOpenOcrState(String openOcrState) {
        this.openOcrState = openOcrState;
    }

    public List<SubInvoiceDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<SubInvoiceDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public List<SubInvoiceFileEntity> getFileList() {
        return fileList;
    }

    public void setFileList(List<SubInvoiceFileEntity> fileList) {
        this.fileList = fileList;
    }

    public List<SubInvoiceOcrEntity> getOcrList() {
        return ocrList;
    }

    public void setOcrList(List<SubInvoiceOcrEntity> ocrList) {
        this.ocrList = ocrList;
    }
}
