package com.ejianc.business.zdsmaterial.sub.settle.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleFileEntity;
import com.ejianc.business.zdsmaterial.sub.settle.mapper.SubSettleFileMapper;
import com.ejianc.business.zdsmaterial.sub.settle.service.ISubSettleFileService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包结算管理-供方附件
 * 
 * @author generator
 * 
 */
@Service("subSettleFileService")
public class SubSettleFileServiceImpl extends BaseServiceImpl<SubSettleFileMapper, SubSettleFileEntity> implements ISubSettleFileService{

    @Autowired
    private SubSettleFileMapper mapper;


    @Override
    public Map<Long, List<SubSettleFileEntity>> getAllBySettleIds(List<Long> settleIds) {
        Map<Long, List<SubSettleFileEntity>> resp = new HashMap<>();
        QueryWrapper<SubSettleFileEntity> query = new QueryWrapper<>();
        query.in("settle_id", settleIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        List<SubSettleFileEntity> list = super.list(query);

        if(CollectionUtils.isNotEmpty(list)) {
            resp = list.stream().collect(Collectors.groupingBy(SubSettleFileEntity::getSettleId));
        }

        return resp;
    }
}
