package com.ejianc.business.zdsmaterial.sub.subvisa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.InstructionSetDetailEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.enums.InstructionStatusEnum;
import com.ejianc.business.zdsmaterial.sub.subvisa.vo.InstructionSetVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zdsmaterial.sub.subvisa.mapper.InstructionSetMapper;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.InstructionSetEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.service.IInstructionSetService;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 指令单
 * 
 * @author generator
 * 
 */
@Service("instructionSetService")
public class InstructionSetServiceImpl extends BaseServiceImpl<InstructionSetMapper, InstructionSetEntity> implements IInstructionSetService{
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "INSET-CODE";//此处需要根据实际修改
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;

    private final String BILL_PUSH_PM_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/instructionSet/syncBill";//推送接口
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String OPERATE = "InstructionSetBill";
    @Override
    public InstructionSetVO saveOrUpdate(InstructionSetVO saveOrUpdateVO) {
        InstructionSetEntity entity = BeanMapper.map(saveOrUpdateVO, InstructionSetEntity.class);
        //校验编码
        if(StringUtils.isNotBlank(entity.getBillCode())){
            checkCode(entity);
        }else{
            //判断编码是否存在 不存在生成
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        super.saveOrUpdate(entity, false);
        InstructionSetVO vo = BeanMapper.map(entity, InstructionSetVO.class);
        return vo;
    }



    public void checkCode(InstructionSetEntity entity) {
        QueryWrapper<InstructionSetEntity> queryWrapper = new QueryWrapper<InstructionSetEntity>();
        queryWrapper.eq("bill_code", entity.getBillCode());
        queryWrapper.eq("dr", 0);
        if(entity.getId() != null ){
            queryWrapper.ne("id", entity.getId());
        }
        List<InstructionSetEntity> list = super.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("指令单编号重复，请重新输入！");

        }
    }




    @Override
    public String pushBill(InstructionSetEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = OPERATE + "::" + entity.getId().toString() + "::sup";
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);
            if (!locked) {
                releaseLock(jedis, false, key, OPERATE);
                return "指令单推送供应链平台失败，加锁失败！";
            }
            //设置单据当前系统信息
            CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                logger.error("推送指令单-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
                return "推送指令单失败，获取当前系统编码失败";
            }
            Map<String, String> params = new HashMap<>();

            //推送两种情况 一种是未引用推送 一种是作废


            if (InstructionStatusEnum.未引用.getStatus().equals(entity.getInstructionSetStatus())) {
                Map<String, Integer> fileNames = new HashMap<>();
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                if (entity.getDetailList() != null && entity.getDetailList().size() > 0) {
                    Map<String, String> fileSourceTypeMap = new HashMap<>();
                    for (InstructionSetDetailEntity detail : entity.getDetailList()) {
                        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(detail.getId(), null, null, null);
                        if (fileResp.isSuccess()) {
                            List<AttachmentVO> fileList = fileResp.getData();
                            List<Long> fileIds = new ArrayList<>();
                            for (AttachmentVO attach : fileList) {
                                fileIds.add(attach.getId());
                                detail.setAttachmentLinkUrl(attach.getFilePath());
//                                String filName = "";
//                                if (fileNames.get(attach.getFileName()) != null) {
//                                    filName = attach.getFileName().replace(".",
//                                            "(" + fileNames.get(attach.getFileName()) + ").");
//                                    fileNames.put(attach.getFileName(), (fileNames.get(attach.getFileName()) + 1));
//                                } else {
//                                    filName = attach.getFileName();
//                                    fileNames.put(attach.getFileName(), 1);
//                                }
                                detail.setAttachmentName(attach.getFileName());
                                detail.setAttachmentId(attach.getId());
                                fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                            }
                            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(fileList)) {
                                Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                                fileMap.keySet().stream().forEach(fileKey -> {
                                    Map<String, InputStream> file = new HashMap<>(1);
                                    file.put(fileKey, fileMap.get(fileKey));
                                    files.put(fileKey, file);
                                });
                            }
                        }
                    }
                    params.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                }
                params.put("transData", JSONObject.toJSONString(entity));
                logger.info("指令单推送供应链平台: url-{}, 指令单：{}", BILL_PUSH_PM_SERVER_URL, JSONObject.toJSONString(entity));
                CommonResponse<String> writeBackResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_PUSH_PM_SERVER_URL,
                        params, entity.getSupplierId().toString(), files);
                logger.error("指令单推送供应链平台请求结果，{}", JSONObject.toJSONString(writeBackResp));
                if (!writeBackResp.isSuccess()) {
                    releaseLock(jedis, true, key, OPERATE);
                    logger.error("指令单id-{}推送供应链平台发送请求失败，{}", entity.getId(), writeBackResp.getMsg());
                    return "指令单推送供应链平台失败";
                }

                String operateRespStr = writeBackResp.getData();
                CommonResponse<String> operateResp = JSONObject.parseObject(operateRespStr, CommonResponse.class);
                if (!operateResp.isSuccess()) {
                    logger.error("指令单id-{}推送供应链，平台处理失败，{}", entity.getId(), operateResp.getMsg());
                    releaseLock(jedis, true, key, OPERATE);
                    return "指令单推送供应链平台失败";
                }
            } else {
                params.put("transData", JSONObject.toJSONString(entity));
                logger.info("指令单作废推送供应链平台: url-{}, 发货单：{}", BILL_PUSH_PM_SERVER_URL, JSONObject.toJSONString(entity));
                CommonResponse<String> writeBackResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_PUSH_PM_SERVER_URL,
                        params, entity.getSupplierId().toString(), null);
                logger.info("指令单作废推送供应链平台请求结果，{}", JSONObject.toJSONString(writeBackResp));

                if (!writeBackResp.isSuccess()) {
                    releaseLock(jedis, true, key, OPERATE);
                    logger.error("指令单id-{}作废推送供应链平台发送请求失败，{}", entity.getId(), writeBackResp.getMsg());
                    return "指令单作废推送供应链平台失败";
                }

                String operateRespStr = writeBackResp.getData();
                CommonResponse<String> operateResp = JSONObject.parseObject(operateRespStr, CommonResponse.class);
                if (!operateResp.isSuccess()) {
                    logger.error("指令单作废id-{}推送供应链，平台处理失败，{}", entity.getId(), operateResp.getMsg());
                    releaseLock(jedis, true, key, OPERATE);
                    return "指令单作废推送供应链平台失败";
                }
            }


        } catch (Exception e) {
            logger.error("指令单id-{}推送供应链平台失败，", entity.getId(), e);
            msg = "操作失败，指令单推送供应链平台失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }

    @Override
    public CommonResponse<InstructionSetVO> pushStatus(InstructionSetVO saveOrUpdateVO) {
        InstructionSetEntity entity = super.selectById(saveOrUpdateVO.getId());
        entity.setInstructionSetStatus(InstructionStatusEnum.作废.getStatus());
        String s = pushBill(entity);
        if (StringUtils.isNotBlank(s)) {
            throw new BusinessException(s);
        }
        super.saveOrUpdate(entity,false);
        InstructionSetVO instructionSetVO = BeanMapper.map(entity, InstructionSetVO.class);
        return CommonResponse.success("作废成功",instructionSetVO);
    }
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public void changeInstructionSetStatus(Long id, Integer s){
        UpdateWrapper<InstructionSetEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id",id);
        updateWrapper.set("instruction_set_status",s);
        boolean update = super.update(updateWrapper);
        if (!update){
            throw new BusinessException("指令单状态修改失败");
        }
    }
    @Override
    public Integer queryInstructionSetStatus(Long id){
        InstructionSetEntity instructionSetEntity = super.selectById(id);
        logger.info("查询对应的指令单---指令单id: {}, 指令单状态: {}", id, instructionSetEntity.getInstructionSetStatus());
        return instructionSetEntity.getInstructionSetStatus();

    }
}
