package com.ejianc.business.zdsmaterial.util;

import com.ejianc.framework.cache.redissonlock.RedissonLocker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

@Component
public class BillLockUtil {
    private static RedissonLocker redissonLocker;

    @Autowired
    public void setRedissonLocker (RedissonLocker redissonLocker){
        this.redissonLocker = redissonLocker;
    }

    private final static String LOCK_KEY = "BILLKEY-";

    public static Boolean getLock(Long id) {
        if (id == null) {
            return false;
        }
        redissonLocker.lock(LOCK_KEY + id, TimeUnit.SECONDS, 30);
        return true;
    }

    public static Boolean getLock(String lockKey, Long id) {
        if (id == null) {
            return false;
        }
        redissonLocker.lock(lockKey + "::" + id, TimeUnit.SECONDS, 30);
        return true;
    }
    public static Boolean getLock(String lockKey, Long id, int timeOut) {
        if (id == null) {
            return false;
        }
        redissonLocker.lock(lockKey + "::" + id, TimeUnit.SECONDS, timeOut);
        return true;
    }

    public static void releaseLock(Long id) {
        if (id == null) {
            return;
        }
        redissonLocker.unlock(LOCK_KEY + id);
    }

    public static void releaseLock(String lockKey, Long id) {
        if (id == null) {
            return;
        }
        redissonLocker.unlock(lockKey + "::" + id);
    }
}
