package com.ejianc.business.zdsmaterial.accept.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.accept.AcceptVO;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.accept.service.IAcceptService;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 物资验收
 *
 * @author generator
 */
@Controller
@RequestMapping("accept")
public class AcceptController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZDS-ACC";//此处需要根据实际修改

    @Autowired
    private IAcceptService service;

    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_TYPE_CODE = "EJCBT202312000001";

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AcceptVO> saveOrUpdate(@RequestBody AcceptVO saveOrUpdateVO) {
        if(StringUtils.isBlank(saveOrUpdateVO.getSiteAcceptorLinkPhone())) {
            //验收人手机号为空，则从当前用户信息中获取
            saveOrUpdateVO.setSiteAcceptorLinkPhone(sessionManager.getUserContext().getUserMobile());
        }

        AcceptVO acceptVO = service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！", acceptVO);
    }


    @GetMapping(value = "pushInStore")
    @ResponseBody
    public CommonResponse<String> pushInStore(@RequestParam Long id, @RequestParam Long userId, @RequestParam boolean pushEffect) {
        AcceptEntity entity = service.selectById(id);
        service.inToStore(entity, pushEffect, userId);
        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/updateCloeState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AcceptVO> updateCloeState(@RequestBody AcceptVO saveOrUpdateVO) {
        UpdateWrapper<AcceptEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("close_delivery",saveOrUpdateVO.getCloseDelivery());
        updateWrapper.eq("id",saveOrUpdateVO.getId());
        service.update(updateWrapper);
        return CommonResponse.success("保存或修改单据成功！", saveOrUpdateVO);
    }
    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AcceptVO> queryDetail(Long id) {
        AcceptEntity entity = service.selectById(id);
        AcceptVO vo = BeanMapper.map(entity, AcceptVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }
    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/pushSubAccept", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AcceptVO> pushSubAccept(@RequestParam Long id) {
        AcceptEntity entity = service.selectById(id);
        String s = service.pushSubAccept(entity, InvocationInfoProxy.getUserid());
        if (StringUtils.isNotBlank(s)){
            throw new BusinessException(s);
        }
        AcceptVO vo = BeanMapper.map(entity, AcceptVO.class);
        return CommonResponse.success("验收单推送供应商成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/pushSubReturn", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AcceptVO> pushSubReturn(@RequestParam Long id) {
        AcceptEntity entity = service.selectById(id);
        String s = service.pushSubReturn(entity, InvocationInfoProxy.getUserid(), null);
        if (StringUtils.isNotBlank(s)){
            throw new BusinessException(s);
        }
        AcceptVO vo = BeanMapper.map(entity, AcceptVO.class);
        return CommonResponse.success("验收单推送分包商成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AcceptVO> vos) {
        service.delete(vos);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AcceptVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 单据编号、项目名称、合同名称、供应商、车牌号 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("carCode");
        fuzzyFields.add("supplierName");

        if (param.getParams().containsKey("queryCoverage")) {
            if ("1".equals(param.getParams().get("queryCoverage").getValue())) {
                //只查询本人验收的验收单
                param.getParams().put("siteAcceptorId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
            }
            param.getParams().remove("queryCoverage");
        }

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(!param.getParams().containsKey("orgId")){//PC端查询
            List<OrgVO> orgVOList = null;

            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
        }

        IPage<AcceptEntity> page = service.queryPage(param, false);
        if (CollectionUtils.isNotEmpty(page.getRecords())){
            IPage<AcceptVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            List<AcceptVO> acceptVOS = BeanMapper.mapList(page.getRecords(), AcceptVO.class);
            for (AcceptVO vo:acceptVOS){
                vo.setAcceptTypeStr(vo.getAcceptType()==1?"直入直出":"正常验收");
                if (vo.getStoreType()==1){
                    vo.setStoreTypeStr("主材库");
                }else if (vo.getStoreType()==2){
                    vo.setStoreTypeStr("临建材料");
                }else {
                    vo.setStoreTypeStr("甲供材");
                }
                if (vo.getSourceType()==1){
                    vo.setSourceTypeStr("自制");
                }else if (vo.getSourceType()==2){
                    vo.setSourceTypeStr("其他验收");
                }else {
                    vo.setSourceTypeStr("发货单");
                }
                if (vo.getSourceType()==0||vo.getSourceType()==1){
                    vo.setSignatureStatusStr(vo.getSignatureStatus()==1?"已签字":"未签字");
                }
                if (vo.getAcceptType()==1){
                    if (null!=vo.getSubSignatureStatus()){
                        vo.setSubSignatureStatusStr(vo.getSubSignatureStatus()==1?"已签字":"未签字");
                    }else {
                        vo.setSubSignatureStatusStr("");
                        vo.setSubSignatureStatus(3);
                    }
                }
                if(!PlanConstant.零星材料入库.equals(vo.getAcceptMaterialType())) {
                    if (null!=vo.getMaterialSignatureStatus()){
                        vo.setMaterialSignatureStatusStr(vo.getMaterialSignatureStatus()==1?"已签字":"未签字");
                    }else {
                        vo.setMaterialSignatureStatusStr("未签字");
                    }
                } else {
                    vo.setMaterialSignatureStatusStr("");
                }
            }
            pageData.setRecords(acceptVOS);
            return CommonResponse.success("查询列表数据成功！", pageData);
        }else {
            IPage<AcceptVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(null);
            return CommonResponse.success("查询列表数据成功！", pageData);
        }

    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<AcceptVO> records = new ArrayList<>();
        CommonResponse<IPage<AcceptVO>> iPageCommonResponse = queryList(param);
        if (iPageCommonResponse.isSuccess()){
             records = iPageCommonResponse.getData().getRecords();
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        records.forEach(vo->{
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        beans.put("records", records);
        if (records.size()>0){
            Integer sourceType = records.get(0).getSourceType();
            if (sourceType==2){
                ExcelExport.getInstance().export("Accept-other-export.xlsx", beans, response);

            }else {
                ExcelExport.getInstance().export("Accept-export.xlsx", beans, response);

            }
        }
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refAcceptData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AcceptVO>> refAcceptData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AcceptEntity> page = service.queryPage(param, false);
        IPage<AcceptVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AcceptVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
    /**
     * 接收并保存供方推送单据
     *
     * @param request
     * @return
     */
    @PostMapping(value = "pushAccept")
    public CommonResponse<String> pushAccept(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);
        logger.info("接收到推送验收单据: {}, 当前上下文: {}", transData, authority);

        if (StringUtils.isBlank(transData)) {
            return CommonResponse.error("单据同步失败，单据内容为空！");
        }
        Long acceptId = JSONObject.parseObject(transData, Long.class);
        //保存单据中附件并获取到上传后附件的Id
        Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                mp, BILL_TYPE_CODE, authority, null);
        service.updateSignatureStatus(acceptId);
        return CommonResponse.success("单据同步成功！");

    }


    /**
     * 接收并保存供方推送单据 领料签字 验收签字
     *
     * @param request
     * @return
     */
    @PostMapping(value = "supSignSync")
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String s = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(s)){
            return CommonResponse.error(s);
        }
        return CommonResponse.success("单据同步成功！");

    }
}
