package com.ejianc.business.zdsmaterial.erp.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 订单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_order")
public class OrderEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="source_order_id")
    private String sourceOrderId; // ERP订单主键, 来源于总价合同时为空
    @TableField(value="source_order_code")
    private String sourceOrderCode; // ERP订单编码
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="source_contract_id")
    private String sourceContractId; // ERP合同主键
    @TableField(value="contract_price_type")
    private Integer contractPriceType; // 计价方式：1-单价合同，2-总价合同；备注：总价合同订单由合同自动生成
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="org_id")
    private Long orgId; // 单据组织id
    @TableField(value="org_name")
    private String orgName; // 单据组织名称
    @TableField(value="org_code")
    private String orgCode; // 单据组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商
    @TableField(value="supplier_code")
    private String supplierCode; // 供应商编码
    @TableField(value="supplier_link_name")
    private String supplierLinkName; // 供应商联系人
    @TableField(value="supplier_link_phone")
    private String supplierLinkPhone; // 供应商联系人手机号
    @TableField(value = "supplier_linker_id")
    private Long supplierLinkerId; //供应商联系人Id
    @TableField(value = "supplier_manager_sup_id")
    private Long supplierManagerSupId; //乙方联系人供方用户Id
    @TableField(value = "supplier_linker_sid")
    private String supplierLinkerSid;//乙方联系人Sid;
    @TableField(value="acceptor_id")
    private Long acceptorId; // 接收人id
    @TableField(value="acceptor_sid")
    private String acceptorSid; // 接收人ERP主键
    @TableField(value="acceptor_name")
    private String acceptorName; // 接收人名称
    @TableField(value="acceptor_code")
    private String acceptorCode; // 接收人编码
    @TableField(value="acceptor_link_phone")
    private String acceptorLinkPhone; // 接收人电话
    @TableField(value="purchase_user_id")
    private Long purchaseUserId; // 采购人id
    @TableField(value = "purchase_user_sid")
    private String purchaseUserSid; // 采购人ERP主键
    @TableField(value="purchase_user_name")
    private String purchaseUserName; // 采购人名称
    @TableField(value="purchase_user_code")
    private String purchaseUserCode; // 采购人编码
    @TableField(value="purchase_user_link_phone")
    private String purchaseUserLinkPhone; // 采购人电话
    @TableField(value="delivery_date")
    private Date deliveryDate; // 交货日期
    @TableField(value="order_tax_mny")
    private BigDecimal orderTaxMny; // 订单金额（含税）
    @TableField(value="order_mny")
    private BigDecimal orderMny; // 订单金额
    @TableField(value="delivered_tax_mny")
    private BigDecimal deliveredTaxMny; // 已发货金额（含税）
    @TableField(value="delivered_mny")
    private BigDecimal deliveredMny; // 已发货金额
    @TableField(value = "total_accept_tax_mny")
    private BigDecimal totalAcceptTaxMny; // 订单验收金额（含税）
    @TableField(value = "total_accept_mny")
    private BigDecimal totalAcceptMny; // 订单验收金额
    @TableField(value="hand_accept_tax_mny")
    private BigDecimal handAcceptTaxMny; // 自制验收金额（含税）
    @TableField(value="hand_accept_mny")
    private BigDecimal handAcceptMny; // 自制验收金额
    @TableField(value="delivery_status")
    private Integer deliveryStatus; // 订单发货状态：0-待发货，1-部分发货，2-全部发货 ?自制验收
    @TableField(value="enable_status")
    private Integer enableStatus; // 订单停启用状态：1-启用，2-停用
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="sign_user_id")
    private String signUserId; // 确认人id
    @TableField(value="sign_user_name")
    private String signUserName; // 确认人名称
    @TableField(value="sign_user_phone")
    private String signUserPhone; // 确认人手机号
    @TableField(value="sign_time")
    private Date signTime; // 确认时间
    @TableField(value="signature_status")
    private Integer signatureStatus; // 确认状态 0:未确认;1:已确认; 
    @TableField(value="supplier_tenant_id")
    private Long supplierTenantId; // 供方租户主键

    @TableField(value = "delivery_address")
    private String deliveryAddress; //送货地址
    @TableField(value = "delivery_remark")
    private String deliveryRemark; //送货要求

    @TableField(value = "remark")
    private String remark; //备注

    /**
     * 来源业务单据Id
     */
    @TableField(value = "source_id")
    private String sourceId;

    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    @TableField(value = "bill_push_flag")
    private String billPushFlag;

    @TableField(value = "source_system_id")
    private String sourceSystemId;
    @TableField(value = "freeze_status")
    private Integer freezeStatus; //1-正常 2-暂停

    @TableField(value = "is_official_seal")
    private String isOfficialSeal;//是否盖章

    @TableField(exist=false)
    @SubEntity(serviceName="orderDetailService", pidName = "orderId")//此处有pid="xxx"，默认值pid="pid"
    private List<OrderDetailEntity> detailList = new ArrayList<>(); // 订单明细

    @TableField(value = "approved_tax_mny")
    private BigDecimal approvedTaxMny; //已审金额
    @TableField(value = "balance_tax_mny")
    private BigDecimal balanceTaxMny; //订单余额

    @TableField(value = "sys_last_upd")
    private String sysLastUpd; //ERP最后更新时间

    public String getIsOfficialSeal() {
        return isOfficialSeal;
    }

    public void setIsOfficialSeal(String isOfficialSeal) {
        this.isOfficialSeal = isOfficialSeal;
    }

    public String getAcceptorSid() {
        return acceptorSid;
    }

    public void setAcceptorSid(String acceptorSid) {
        this.acceptorSid = acceptorSid;
    }

    public String getPurchaseUserSid() {
        return purchaseUserSid;
    }

    public void setPurchaseUserSid(String purchaseUserSid) {
        this.purchaseUserSid = purchaseUserSid;
    }

    public String getSupplierLinkerSid() {
        return supplierLinkerSid;
    }

    public void setSupplierLinkerSid(String supplierLinkerSid) {
        this.supplierLinkerSid = supplierLinkerSid;
    }

    public String getSysLastUpd() {
        return sysLastUpd;
    }

    public void setSysLastUpd(String sysLastUpd) {
        this.sysLastUpd = sysLastUpd;
    }

    public Long getSupplierManagerSupId() {
        return supplierManagerSupId;
    }

    public void setSupplierManagerSupId(Long supplierManagerSupId) {
        this.supplierManagerSupId = supplierManagerSupId;
    }

    public BigDecimal getApprovedTaxMny() {
        return approvedTaxMny;
    }

    public void setApprovedTaxMny(BigDecimal approvedTaxMny) {
        this.approvedTaxMny = approvedTaxMny;
    }

    public BigDecimal getBalanceTaxMny() {
        return balanceTaxMny;
    }

    public void setBalanceTaxMny(BigDecimal balanceTaxMny) {
        this.balanceTaxMny = balanceTaxMny;
    }

    public Integer getFreezeStatus() {
        return freezeStatus;
    }

    public void setFreezeStatus(Integer freezeStatus) {
        this.freezeStatus = freezeStatus;
    }

    public Long getSupplierLinkerId() {
        return supplierLinkerId;
    }

    public void setSupplierLinkerId(Long supplierLinkerId) {
        this.supplierLinkerId = supplierLinkerId;
    }

    public BigDecimal getTotalAcceptTaxMny() {
        return totalAcceptTaxMny;
    }

    public void setTotalAcceptTaxMny(BigDecimal totalAcceptTaxMny) {
        this.totalAcceptTaxMny = totalAcceptTaxMny;
    }

    public BigDecimal getTotalAcceptMny() {
        return totalAcceptMny;
    }

    public void setTotalAcceptMny(BigDecimal totalAcceptMny) {
        this.totalAcceptMny = totalAcceptMny;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getDeliveryAddress() {
        return deliveryAddress;
    }

    public void setDeliveryAddress(String deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public String getDeliveryRemark() {
        return deliveryRemark;
    }

    public void setDeliveryRemark(String deliveryRemark) {
        this.deliveryRemark = deliveryRemark;
    }

    public String getSourceOrderId() {
        return sourceOrderId;
    }

    public void setSourceOrderId(String sourceOrderId) {
        this.sourceOrderId = sourceOrderId;
    }
    public String getSourceOrderCode() {
        return sourceOrderCode;
    }

    public void setSourceOrderCode(String sourceOrderCode) {
        this.sourceOrderCode = sourceOrderCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getSourceContractId() {
        return sourceContractId;
    }

    public void setSourceContractId(String sourceContractId) {
        this.sourceContractId = sourceContractId;
    }
    public Integer getContractPriceType() {
        return contractPriceType;
    }

    public void setContractPriceType(Integer contractPriceType) {
        this.contractPriceType = contractPriceType;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
    public String getSupplierLinkName() {
        return supplierLinkName;
    }

    public void setSupplierLinkName(String supplierLinkName) {
        this.supplierLinkName = supplierLinkName;
    }
    public String getSupplierLinkPhone() {
        return supplierLinkPhone;
    }

    public void setSupplierLinkPhone(String supplierLinkPhone) {
        this.supplierLinkPhone = supplierLinkPhone;
    }
    public Long getAcceptorId() {
        return acceptorId;
    }

    public void setAcceptorId(Long acceptorId) {
        this.acceptorId = acceptorId;
    }
    public String getAcceptorName() {
        return acceptorName;
    }

    public void setAcceptorName(String acceptorName) {
        this.acceptorName = acceptorName;
    }
    public String getAcceptorCode() {
        return acceptorCode;
    }

    public void setAcceptorCode(String acceptorCode) {
        this.acceptorCode = acceptorCode;
    }
    public String getAcceptorLinkPhone() {
        return acceptorLinkPhone;
    }

    public void setAcceptorLinkPhone(String acceptorLinkPhone) {
        this.acceptorLinkPhone = acceptorLinkPhone;
    }
    public Long getPurchaseUserId() {
        return purchaseUserId;
    }

    public void setPurchaseUserId(Long purchaseUserId) {
        this.purchaseUserId = purchaseUserId;
    }
    public String getPurchaseUserName() {
        return purchaseUserName;
    }

    public void setPurchaseUserName(String purchaseUserName) {
        this.purchaseUserName = purchaseUserName;
    }
    public String getPurchaseUserCode() {
        return purchaseUserCode;
    }

    public void setPurchaseUserCode(String purchaseUserCode) {
        this.purchaseUserCode = purchaseUserCode;
    }
    public String getPurchaseUserLinkPhone() {
        return purchaseUserLinkPhone;
    }

    public void setPurchaseUserLinkPhone(String purchaseUserLinkPhone) {
        this.purchaseUserLinkPhone = purchaseUserLinkPhone;
    }
    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }
    public BigDecimal getOrderTaxMny() {
        return orderTaxMny;
    }

    public void setOrderTaxMny(BigDecimal orderTaxMny) {
        this.orderTaxMny = orderTaxMny;
    }
    public BigDecimal getOrderMny() {
        return orderMny;
    }

    public void setOrderMny(BigDecimal orderMny) {
        this.orderMny = orderMny;
    }
    public BigDecimal getDeliveredTaxMny() {
        return deliveredTaxMny;
    }

    public void setDeliveredTaxMny(BigDecimal deliveredTaxMny) {
        this.deliveredTaxMny = deliveredTaxMny;
    }
    public BigDecimal getDeliveredMny() {
        return deliveredMny;
    }

    public void setDeliveredMny(BigDecimal deliveredMny) {
        this.deliveredMny = deliveredMny;
    }
    public BigDecimal getHandAcceptTaxMny() {
        return handAcceptTaxMny;
    }

    public void setHandAcceptTaxMny(BigDecimal handAcceptTaxMny) {
        this.handAcceptTaxMny = handAcceptTaxMny;
    }
    public BigDecimal getHandAcceptMny() {
        return handAcceptMny;
    }

    public void setHandAcceptMny(BigDecimal handAcceptMny) {
        this.handAcceptMny = handAcceptMny;
    }
    public Integer getDeliveryStatus() {
        return deliveryStatus;
    }

    public void setDeliveryStatus(Integer deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }
    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getSignUserId() {
        return signUserId;
    }

    public void setSignUserId(String signUserId) {
        this.signUserId = signUserId;
    }
    public String getSignUserName() {
        return signUserName;
    }

    public void setSignUserName(String signUserName) {
        this.signUserName = signUserName;
    }
    public String getSignUserPhone() {
        return signUserPhone;
    }

    public void setSignUserPhone(String signUserPhone) {
        this.signUserPhone = signUserPhone;
    }
    public Date getSignTime() {
        return signTime;
    }

    public void setSignTime(Date signTime) {
        this.signTime = signTime;
    }
    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }
    public Long getSupplierTenantId() {
        return supplierTenantId;
    }

    public void setSupplierTenantId(Long supplierTenantId) {
        this.supplierTenantId = supplierTenantId;
    }
    
    public List<OrderDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<OrderDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
