package com.ejianc.business.zdsmaterial.erp.service;

import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.vo.OrderVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 订单
 * 
 * @author generator
 * 
 */
public interface IOrderService extends IBaseService<OrderEntity> {

    OrderVO getOneBySourceContractId(String sourceOrderId);

    /**
     * 依据合同生成/更新订单信息
     *
     * @param contract
     * @param addFlag
     */
    void saveByContract(ContractEntity contract, boolean addFlag);

    /**
     * 订单同步供方
     *
     * @param orderVO
     * @return
     */
    String pushToSupBusiness(OrderVO orderVO);

    void supOrderSync(OrderVO orderVO);

    /**
     * 自制验收回写自制验收量
     * @param entity
     * @param status
     */
    void returnHandAcceptNum(AcceptEntity entity, Boolean status);


    /**
     * 发货单回写验收量
     * @param deliveryEntity
     */
    void returnAcceptedNum(DeliveryEntity deliveryEntity, boolean addFlag);

    List<OrderEntity> getBySourceIds(List<String> sourceIds);

    void saveByContracts(List<ContractEntity> saveList);

    OrderEntity updateFreezeStatus(OrderVO saveOrUpdateVO);

    List<Long> getCanSyncOrderIdsBySupplierId(Long supplierId);

    void cancelOrderByContractId(List<Long> mainContractIds);

    void cancelOrderList(List<Long> orderIds);
}
