package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.ContractMapper;
import com.ejianc.business.zdsmaterial.erp.service.IContractDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IContractService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsmaterial.erp.vo.ContractVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 物资合同
 * 
 * @author generator
 * 
 */
@Service("contractService")
public class ContractServiceImpl extends BaseServiceImpl<ContractMapper, ContractEntity> implements IContractService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractDetailService detailService;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private  ContractMapper contractMapper;

    @Override
    public ContractVO getOneBySourceContractId(String sourceContractId) {
        ContractVO resp = null;
        QueryWrapper<ContractEntity> query = new QueryWrapper<>();
        query.eq("source_contract_id", sourceContractId);
        query.eq("dr", BaseVO.DR_UNDELETE);

        ContractEntity e = super.getOne(query);
        if(null != e) {
            e.setDetailList(detailService.getByAllContractId(e.getId()));;
            resp = BeanMapper.map(e, ContractVO.class);
        }

        return resp;
    }

    @Override
    public ContractVO getOneByCode(String contractCode) {
        ContractVO resp = null;
        QueryWrapper<ContractEntity> query = new QueryWrapper<>();
        query.eq("bill_code", contractCode);
        query.eq("dr", BaseVO.DR_UNDELETE);

        ContractEntity e = super.getOne(query);
        if(null != e) {
            e.setDetailList(detailService.getByAllContractId(e.getId()));
            resp = BeanMapper.map(e, ContractVO.class);
        }

        return resp;
    }

    @Override
    public ContractVO saveContract(ContractVO saveContractInfo) {
        ContractEntity saveEntity = BeanMapper.map(saveContractInfo, ContractEntity.class);

        boolean addFlag = null == saveEntity.getId();
        super.saveOrUpdate(saveEntity, false);

        if(ZDSMaterialCommonEnums.总价合同.getCode().equals(saveEntity.getPriceType())) {
            //总价合同，则生成或更新订单
            orderService.saveByContract(saveEntity, addFlag);
        }

        return BeanMapper.map(saveEntity, ContractVO.class);
    }

    @Override
    public List<ContractEntity> getBySourceIds(List<String> sourceIds) {
        QueryWrapper<ContractEntity> query = new QueryWrapper<>();
        query.in("source_contract_id", sourceIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());

        return super.list(query);
    }
//            jsonObject.put("performanceNum", supplierTenantId);
//        jsonObject.put("finishedNum", supplierTenantId);
//        jsonObject.put("thisYearContractMny", supplierTenantId);
//        jsonObject.put("thisYearApplyMny", supplierTenantId);

    /**
     * 履约中
     * @return
     */
    @Override
    public Integer performanceNum(Long linkerId, String linkerSid, Long supplierId){
        QueryWrapper<ContractEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("enable_status", 1);
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
//        queryWrapper.eq("contract_type", 1);
        if(null != linkerId || StringUtils.isNotEmpty(linkerSid)) {
            queryWrapper.and(q -> q.eq("supplier_manager_id", linkerId).or().eq("supplier_manager_sid", linkerSid));
        }
        if(null != supplierId) {
            queryWrapper.eq("supplier_id", supplierId);
        }
        int count = super.count(queryWrapper);
        return count;
    }

    /**
     * 已结束
     * @return
     */
    @Override
    public Integer finishedNum(Long linkerId, String linkerSid, Long supplierId){
        QueryWrapper<ContractEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("enable_status", 2);
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
        if(null != linkerId || StringUtils.isNotEmpty(linkerSid)) {
            queryWrapper.and(q -> q.eq("supplier_manager_id", linkerId).or().eq("supplier_manager_sid", linkerSid));
        }
        if(null != supplierId) {
            queryWrapper.eq("supplier_id", supplierId);
        }
        int count = super.count(queryWrapper);
        return count;
    }
    /**
     * 本年度新签合同额
     * @return
     */
    @Override
    public String thisYearContract(Long linkerId, String linkerSid, Long supplierId){

        List<Long> collect =  new ArrayList<>();
        List<ContractEntity> list = contractMapper.queryNowYearList(linkerId, linkerSid, supplierId);
        StringJoiner joiner = new StringJoiner(",");

        if (CollectionUtils.isNotEmpty(list)){
            for (ContractEntity e : list) {
                joiner.add(String.valueOf(e.getId()));
            }
        }

        // 获取最终的id字符串
        String idsStr = joiner.toString();
        return idsStr;
    }

    @Override
    public int countContractAndOrder(Map<String, Object> queryParam) {
        return contractMapper.countContractAndOrder(queryParam);
    }

    @Override
    public List<Map> pageContractAndOrder(Map<String, Object> queryParam) {
        return contractMapper.pageContractAndOrder(queryParam);
    }

    @Override
    public BigDecimal thisYearContractMny(Long linkerId, String linkerSid, Long supplierId) {
        return contractMapper.thisYearContractMny(linkerId, linkerSid, supplierId);
    }

    @Override
    @Async(value = "maContextCommonTask")
    public void cancelBill(List<Long> delContractIds) {
        //查询作废单据中对应的总价合同
        QueryWrapper<ContractEntity> query = new QueryWrapper<>();
        query.in("id", delContractIds);
        query.eq("price_type", 2);

        List<ContractEntity> mainCons = super.list(query);
        if(CollectionUtils.isNotEmpty(mainCons)) {
            List<Long> mainContractIds = mainCons.stream().map(ContractEntity::getId).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(mainContractIds)) {
                orderService.cancelOrderByContractId(mainContractIds);
            }
        }

        //合同主表作废
        UpdateWrapper<ContractEntity> update = new UpdateWrapper<>();
        update.in("id", delContractIds);
        update.eq("dr", BaseVO.DR_UNDELETE);
        update.set("dr", 1);
        update.set("update_time", new Date());
        update.set("remark", "ERP-作废删除");
        super.update(update);

        //合同子表作废
        detailService.cancelByContractIds(delContractIds);
    }

    @Override
    public List<String> getSyncList() {
        return contractMapper.getSyncList();
    }

    @Override
    public void updateSyncResult(String sourceContractId, String syncFlag) {
        contractMapper.updateSyncResult(sourceContractId, syncFlag);
    }

    @Override
    public List<Long> getAllTransferContractIds(Long userId) {
        QueryWrapper<ContractEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("change_porter_id", userId);

        List<ContractEntity> contracts = super.list(query);
        if(CollectionUtils.isNotEmpty(contracts)) {
            return contracts.stream().map(ContractEntity::getId).collect(Collectors.toList());
        }

        return new ArrayList<>();
    }
}
