package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.ErpInvoiceMapper;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceService;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 领航发票实体
 * 
 * @author generator
 * 
 */
@Service("erpInvoiceService")
public class ErpInvoiceServiceImpl extends BaseServiceImpl<ErpInvoiceMapper, ErpInvoiceEntity> implements IErpInvoiceService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final String MAT_INVOICE_ERP_REQ_URL = "/cefoc/yql/getMEBillSubList";
    private final String SUB_INVOICE_ERP_REQ_URL = "/cefoc/yql/getSubBillSubList";

    @Override
    public List<ErpInvoiceEntity> getAllBySourceIds(List<String> sourceIds) {
        QueryWrapper<ErpInvoiceEntity> query = new QueryWrapper<>();
        query.in("source_id", sourceIds);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());

        return super.list(query);
    }

    @Override
    public ErpInvoiceEntity getOneById(Long id) {
        return super.selectById(id);
    }

    @Override
    public ErpInvoiceEntity getOneBySourceId(String sourceId) {
        ErpInvoiceEntity resp = null;
        QueryWrapper<ErpInvoiceEntity> query = new QueryWrapper<>();
        query.eq("source_id", sourceId);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());

        resp = super.getOne(query);
        if(null != resp) {
            return super.selectById(resp.getId());
        }

        return resp;
    }

    @Override
    public List<ErpInvoiceEntity> getAllByIds(List<Long> ids) {
        QueryWrapper<ErpInvoiceEntity> query = new QueryWrapper<>();
        query.in("id", ids);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }

    @Override
    public List<ErpInvoiceEntity> getAllByInvoiceNums(List<String> invoiceNums) {
        QueryWrapper<ErpInvoiceEntity> query = new QueryWrapper<>();
        query.in("number", invoiceNums);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }

    @Override
    public List<String> checkQuote(List<String> invoiceNums, String checkType) {
        Set<String> resp = new HashSet<>();
        JSONArray jsonArr = syncTodayQuotedInvoice(checkType);
        JSONObject json = null;
        if(null != jsonArr && jsonArr.size() > 0) {
            for(Object obj : jsonArr) {
                json = (JSONObject) obj;
                if(invoiceNums.contains(json.getString("InvoiceHM")) && !resp.contains(json.getString("InvoiceHM"))) {//根据发票号查询发票是否被引用
                    resp.add(json.getString("InvoiceHM"));
                }
            }
        }

        return new ArrayList<>(resp);
    }


    @Override
    public JSONArray syncTodayQuotedInvoice(String checkType) {
        logger.info("*********************中电四-发票引用信息查询 开始*********************");

        String url = ZDSInterfaceCommonUtil.getErpReqHost() + ("mat".equals(checkType) ? MAT_INVOICE_ERP_REQ_URL : SUB_INVOICE_ERP_REQ_URL);
        Map<String, String> headers = null;
        JSONObject param = new JSONObject();

        //查询当天的数据
        String startDateStr = DateFormatUtil.formatDate("yyyy-MM-dd", DateUtil.addDays(new Date(), -2)) + " 00:00:00";
        String endDateStr = DateFormatUtil.formatDate("yyyy-MM-dd", new Date()) + " 23:59:59";

        param.put("BeginDateTime", startDateStr);
        param.put("EndDateTime", endDateStr);
        Integer PageSize = 100;
        Integer PageNum = 1;

        try {
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            param.put("PageSize", PageSize);
            JSONObject reqJson = null;

            param.put("PageNum", PageNum);
            String reqResp = HttpTookit.postByJson(url, JSONObject.toJSONString(param),
                    headers, ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);

            reqJson = JSONObject.parseObject(reqResp);

            if("ok".equals(reqJson.getString("status"))) {
                logger.info("发票引用信息查询,请求成功，共{}条数据",reqJson.getString("allCount"));
                return reqJson.getJSONArray("data");
            } else {
                logger.error("发票引用信息查询：请求地址-{},参数-{},header-{},结果-{}", url, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
                throw new BusinessException("引用发票信息查询失败");
            }

        } catch (Exception e) {
            logger.error("发票引用信息查询, 请求地址：{}, 请求参数：{}", url, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat), e);
            throw new BusinessException("引用发票信息查询失败！");
        }
    }
}
