package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zdsmaterial.asynchandler.QueueUtils;
import com.ejianc.business.zdsmaterial.erp.bean.MessageInfoEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.MessageInfoMapper;
import com.ejianc.business.zdsmaterial.erp.service.IMessageInfoService;
import com.ejianc.business.zdsmaterial.erp.vo.MessageInfoVO;
import com.ejianc.business.zdsmaterial.sub.settle.utils.HttpTookit;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 发送消息信息记录
 * 
 * @author generator
 * 
 */
@Service("messageInfoService")
public class MessageInfoServiceImpl extends BaseServiceImpl<MessageInfoMapper, MessageInfoEntity> implements IMessageInfoService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${zds.erp.reqHost:http://192.168.201.55:8001}")
    private String reqHost;
    @Autowired
    private IUserApi usersApi;
    @Autowired
    private EnvironmentTools environmentTools;
    private Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    @Value("${zds.erp.appId:859f0363d7dcc01cc4275a6cad2a0001}")
    private String appId;
    @Value("${zds.erp.secret:11658934fd26400985e1e9d83f6ac7cf}")
    private String secret;
    @Autowired
    private QueueUtils queueUtils;
    @Value("${spring.cloud.config.profile}")
    private String profile;

    private final String THIRD_TODO_PAGE = "ejc-bpm-frontend/#/thirdTodo";

    @Value("${thirdTask.warnUserIds:303581417601122400}")
    private String warnUserIds;
    @Autowired
    private IPushMessageApi pushMessageApi;

    @Value("${common.env.base-host}")
    private String BASE_HOST;


    @Override
    public void reviewSendMessage(Long id) {
        MessageInfoEntity entity = super.selectById(id);
        if ( null == entity){
            throw new BusinessException("请传入正确的消息id");
        }
        MessageInfoVO vo = BeanMapper.map(entity, MessageInfoVO.class);

        if (StringUtils.isAnyBlank(vo.getUserId(),vo.getProcessState(),vo.getProcessStateCode()) || null==vo.getBillId()){
            throw new BusinessException("必填数据为空");
        }
        this.sendTodoMessage(Arrays.asList(vo.getUserId().split(",")),vo.getBillId().toString(),vo.getBillTypeCode(), vo.getTitle(), vo.getStartUserId(),vo.getFormUrl()
        ,vo.getMaUrl(),vo.getProcessState(),vo.getProcessStateCode(),vo.getTaskName(),vo.getIdea(),vo.getIdeaCode(),id);
    }

    @Override
    public String thirdTaskReSend(List<Long> ids) {
        List<MessageInfoEntity> todoList = getUnHandleList(ids);
        String serverUrl = reqHost + "/cefoc/yql/getTaskTicket";

        Integer sucNum = 0, failNum = 0;

        for(MessageInfoEntity messageInfoVO : todoList) {
            try {
                logger.info("*******待办/已办消息id-{}重发*******", messageInfoVO.getId());
                if(StringUtils.isBlank(messageInfoVO.getParam())) {
                    logger.info("******注意*****待办/已办消息id-{}参数为空，重发跳过****注意***", messageInfoVO.getId());
                    continue;
                }
                String paramterStr = gson.toJson(messageInfoVO.getParam());
                Map<String, String> header = this.getErpHeaders();
                String resultResp = HttpTookit.postByJson(serverUrl, paramterStr, header);
                logger.info("发送代办/已办id-{}调用ERP接口调用成功，返回结果：{}！！！++++++++++++",messageInfoVO.getId(), resultResp);

                if(resultResp.contains("处理失败:0条")) {
                    messageInfoVO.setSuccessFlag("1");
                    messageInfoVO.setMessage(resultResp);
                    messageInfoVO.setState(null);
                    sucNum++;
                } else {
                    messageInfoVO.setSuccessFlag("0");
                    messageInfoVO.setMessage(resultResp);
                    messageInfoVO.setState("未处理");
                    failNum++;
                }
                queueUtils.sendMq(MessageInfoVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(messageInfoVO));
            } catch (Exception e) {
                messageInfoVO.setSuccessFlag("0");
                messageInfoVO.setMessage("消息推送EPR异常");
                messageInfoVO.setState("未处理");
                queueUtils.sendMq(MessageInfoVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(messageInfoVO));
                failNum++;
            }
        }
        if(sucNum >0) {
            return "操作成功，成功发送事项："+sucNum+ (failNum == 0 ? "条！":"条，失败："+failNum+"条");
        }
        return "操作失败，事项重新推送ERP,ERP处理失败！";

    }

    @Override
    public void scanThirdFailTask() {
        logger.info("********************************第三方失败代办预警任务  START ********************************");
        List<MessageInfoEntity> toHandleList = getUnHandleList(null);
        logger.info("查询到待预警 第三方代办数据：{}条", toHandleList.size());
        if(CollectionUtils.isEmpty(toHandleList)) {
            logger.info("查询到待预警 第三方代办数据为空，预警任务执行结束 END ********************************", toHandleList.size());
            return;
        }


        sendWarn(toHandleList);

        logger.info("********************************第三方失败代办预警任务  END ********************************");
    }

    private void sendWarn(List<MessageInfoEntity> toHandleList) {
        sendWarnMsg("ERP处理失败代办、已办消息预警",
                "【代办、已办消息ERP处理失败预警】：【"+ DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())
                +"】检测到有【"+toHandleList.size()+"】条代办、已办任务推送ERP失败，请尽快处理！",
                BASE_HOST + THIRD_TODO_PAGE);
    }

    @Override
    public boolean sendWarnMsg(String title, String content, String pcUrl) {
        try {
            PushMsgParameter parameter = new PushMsgParameter();
            parameter.setSubject(title);
            parameter.setContent(content);
            parameter.setPcUrl(pcUrl);
            parameter.setMobileUrl(pcUrl);
            String[] recIds = warnUserIds.split(","); //预警接收人Id
            parameter.setReceivers(recIds);
            parameter.setSaveFlag(true);
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setMsgType("notice");
            parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, PushMsgParameter.CHANNEL_TYPE_EMAIL});

            CommonResponse<String> sendResp = pushMessageApi.pushMessage(parameter);
            if (!sendResp.isSuccess()) {
                logger.error("发送代办、已办预警消息失败，消息-{}，发送消息结果-{}", JSONObject.toJSONString(parameter), JSONObject.toJSONString(sendResp, SerializerFeature.PrettyFormat,
                        SerializerFeature.WriteMapNullValue));
                return false;
            } else {
                logger.info("发送代办、已办预警消息成功！");
                return true;
            }
        } catch (Exception e) {
            logger.error("发送代办、已办预警消息异常！！！", e);
            return false;
        }
    }

    private List<MessageInfoEntity> getUnHandleList(List<Long> ids) {
        //查询当前失败的且未处理的第三方代办列表
        QueryWrapper<MessageInfoEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("success_flag", "0");
        if(CollectionUtils.isNotEmpty(ids)) {
            query.in("id", ids);
        }
        return super.list(query);
    }


    /**
     *
     * ========================必填数据============================
     * @param userId 审批人ids 多个用,分割
     * @param billId 业务单据id
     * @param billTypeCode 业务单据编码
     * @param title 审批主题
     * @param startUserId  提交人/发起人id
     * @param formUrl   pc端链接
     * @param maUrl  移动端链接
     * @param processState  //审批状态名称（待办、已办）
     * @param processStateCode 审批状态编码0,1;待办为0,已办为1
     * @param taskName  审批节点名称
     * @param idea  审批意见
     * @param ideaCode  审批标识1同意，2不同意
     * @return
     */
    @Override
    public void sendTodo(List<String> userId, String billId, String billTypeCode, String title
            , String startUserId, String formUrl, String maUrl, String processState, String processStateCode, String taskName,String idea,String ideaCode) {
        this.sendTodoMessage(userId,billId,billTypeCode,title,startUserId,formUrl,maUrl,processState,processStateCode,taskName,idea,ideaCode,null);
    }


    public void sendTodoMessage(List<String> userId, String billId, String billTypeCode, String title
            , String startUserId, String formUrl, String maUrl, String processState, String processStateCode,
                                String taskName,String idea,String ideaCode,Long id) {

        if(userId==null||userId.size()==0){
            logger.info("用户信息为空--------");
            throw new BusinessException("发送代办已办消息失败，用户信息为空");
        }
        if (StringUtils.isAnyBlank(billId,processState,processStateCode)){
            throw new BusinessException("发送代办已办消息失败，必填参数【billId,processState,processStateCode】为空");
        }
        MessageInfoVO messageInfoVO = new MessageInfoVO();
        if (null == id) {
            messageInfoVO.setBillId(Long.valueOf(billId));
            messageInfoVO.setBillTypeCode(billTypeCode);
            messageInfoVO.setUserId(StringUtil.join(userId, ','));
            messageInfoVO.setTitle(title);
            messageInfoVO.setStartUserId(startUserId);
            messageInfoVO.setFormUrl(formUrl);
            messageInfoVO.setMaUrl(maUrl);
            messageInfoVO.setProcessState(processState);
            messageInfoVO.setProcessStateCode(processStateCode);
            messageInfoVO.setTaskName(taskName);
            messageInfoVO.setId(IdWorker.getId());
        }else {
            messageInfoVO= BeanMapper.map(super.selectById(id),MessageInfoVO.class);
        }
        try {
            logger.info("调用中电四ERP 接口：发送消息接口start------------------");
            String serverUrl = reqHost + "/cefoc/yql/getTaskTicket";
            String[] userIds = new String[userId.size()];
            JSONObject json = this.getUser(startUserId);
            String startUserCode = startUserId;
            String startUserName = startUserId;
            if(json!=null){
                startUserCode = json.get("code").toString();
                startUserName = json.get("name").toString();
            }
            JSONArray data = new JSONArray();
            if (StringUtils.isNotBlank(formUrl)) {
                formUrl = URLEncoder.encode(formUrl, "utf-8");
            }
            CommonResponse<List<UserVO>> userBack = usersApi.queryListByIds(userId.toArray(userIds));
            if(userBack.isSuccess()){
                if(userBack.getData()!=null&&userBack.getData().size()>0){
                    List<UserVO> userList = userBack.getData();
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Set<Long> userIdSet = new HashSet();
                    Set<String> userCodeSet = new HashSet();
                    Set<String> userNameSet = new HashSet();
                    if ("0".equals(processStateCode)) {
                            for(UserVO userVO : userList){
                            //发送待办重新组装参数
                                String modelId = ZDSInterfaceCommonUtil.changeLongToGUID(messageInfoVO.getId());
                                logger.info("发送代办：" + userVO.getUserName() + "-----------" + modelId);
                                String ApprovalURL = maUrl + "&userid=" + userVO.getId();
                                String jumpUrl = environmentTools.getBaseHost() + "portal/sso/index?usercode=" + userVO.getUserCode() + "&targeturl=" + formUrl;

                                JSONObject param = new JSONObject();
                                /******必填********/
                                param.put("YQLTaskTicketOID", modelId);//主键值
                                param.put("InstanceID", modelId);//审批实例
                                param.put("BusiField", title);//审批主题
                                param.put("ProcessState", processState);//审批状态名称（待办、已办）
                                param.put("ProcessStateCode", processStateCode);//审批状态编码0,1;待办为0,已办为1
                                param.put("ActivityChineseName", taskName);//审批节点名称
                                param.put("Sys_Created", DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date()));//创建时间
                                param.put("Sys_LAST_UPD", DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date()));//最后更新时间
                                param.put("PersonName", userVO.getUserName());//审批人
                                param.put("PersonOID", userVO.getSourceId());//审批人sourcec_id
                                param.put("WorkCode", userVO.getUserCode());//审批人工号
                                param.put("ApprovalURL", ApprovalURL);//移动端审批页面
                                param.put("WebApprovalURL", jumpUrl);//电脑端审批页面
                                param.put("OriginatorName", StringUtils.isNotBlank(startUserName)?startUserName:userVO.getUserName());//发起人
                                param.put("OriginatorCode", StringUtils.isNotBlank(startUserCode)?startUserCode:userVO.getUserCode());//发起人工号
                                param.put("OriginatorTime", DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date()));//发起时间
                                param.put("Idea", "");//审批意见
                                param.put("IdeaCode", "0");//审批标识1同意，2不同意
                                param.put("SYS_Deleted", 0);//删除状态默认0
                                param.put("YQL_SID", modelId);//代办信息ID

                                data.add(param);
                            /******非必填********/
    //						param.put("SYS_CreatedBy", );//创建人oid
    //						param.put("SYS_REPLACEMENT", );//授权用户oid
    //						param.put("SYS_POSTN", );//创建人岗位oid
    //						param.put("SYS_DIVISION", );//创建人部门oid
    //						param.put("SYS_ORG", );//创建人组织oid
    //						param.put("SYS_LAST_UPD_BY", );//最后更新人oid
                            userIdSet.add(userVO.getId());
                            userCodeSet.add(userVO.getUserCode());
                            userNameSet.add(userVO.getUserName());
                        }
                        messageInfoVO.setUserId(StringUtil.join(userIdSet,','));
                        messageInfoVO.setUserCode(StringUtil.join(userCodeSet,','));
                        messageInfoVO.setUserName(StringUtil.join(userNameSet,','));
                    } else {
                        LambdaQueryWrapper<MessageInfoEntity> qw = Wrappers.lambdaQuery();
                        qw.eq(MessageInfoEntity::getBillId,billId)
                                .eq(MessageInfoEntity::getDr,0)
                                .orderByDesc(MessageInfoEntity::getCreateTime).last("limit 1");
                        MessageInfoEntity entity = super.getOne(qw);
                        messageInfoVO= BeanMapper.map(entity,MessageInfoVO.class);
                        if (null == messageInfoVO){
                            logger.info("根据billId：{}获取代办信息失败", billId);
                            messageInfoVO.setSuccessFlag("0");
                            messageInfoVO.setMessage("根据billId："+billId+"获取代办信息失败");
                            messageInfoVO.setState("未处理");
                            queueUtils.sendMq(MessageInfoVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(messageInfoVO));
                        } else {
                            String param = messageInfoVO.getParam();
                            data = JSONObject.parseArray(param);
                            for (Object o : data) {
                                JSONObject map = (JSONObject) JSONObject.toJSON(o);
                                map.put("ProcessState", "已办");//审批状态名称（待办、已办）
                                map.put("ProcessStateCode", "1");//审批状态编码0,1;待办为0,已办为1
                                map.put("Sys_LAST_UPD", DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date()));//最后更新时间
                                map.put("Idea", idea);//审批意见
                                map.put("IdeaCode", ideaCode);//审批标识1同意，2不同意
                            }
                        }
                    }
                    messageInfoVO.setParam(JSONObject.toJSONString(data));
                }else{
                    logger.info("根据id：{}获取用户信息失败，未查询到该用户数据", userId.toString());
                    messageInfoVO.setSuccessFlag("0");
                    messageInfoVO.setMessage("根据id："+userId.toString()+"获取用户信息失败，未查询到该用户数据");
                    messageInfoVO.setState("未处理");
                    queueUtils.sendMq(MessageInfoVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(messageInfoVO));
                }
            }else{
                logger.info("根据id：{}获取用户信息失败，调用接口userApi.queryListByIds失败", userId.toString());
                messageInfoVO.setSuccessFlag("0");
                messageInfoVO.setMessage("根据id："+userId.toString()+"获取用户信息失败，调用接口userApi.queryListByIds失败");
                messageInfoVO.setState("未处理");
                queueUtils.sendMq(MessageInfoVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(messageInfoVO));
            }

            if(data!=null && data.size()>0){
                logger.info("发送用户{}传递的参数：{}---------------", "0".equals(processStateCode)? "代办":"已办", data.toJSONString());
                String paramterStr = gson.toJson(data);
                Map<String, String> header = this.getErpHeaders();
                String resultResp = HttpTookit.postByJson(serverUrl, paramterStr, header);
                logger.info("billId-{},发送代办/已办调用ERP接口调用成功，返回结果：{}！！！++++++++++++",billId, resultResp);

                if(resultResp.contains("处理失败:0条")) {
                    messageInfoVO.setSuccessFlag("1");
                    messageInfoVO.setMessage(resultResp);
                    messageInfoVO.setState(null);
                } else {
                    messageInfoVO.setSuccessFlag("0");
                    messageInfoVO.setMessage(resultResp);
                    messageInfoVO.setState("未处理");
                }
                queueUtils.sendMq(MessageInfoVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(messageInfoVO));
            }

            logger.info("调用中电四ERP 接口：发送消息接口end------------------");
        } catch (Exception e) {
            logger.info("调用中电四ERP 接口：发送代办/已办消息异常：", e);
            messageInfoVO.setSuccessFlag("0");
            messageInfoVO.setMessage("调用中电四ERP 接口：发送消息接口失败！");
            messageInfoVO.setState("未处理");
            queueUtils.sendMq(MessageInfoVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(messageInfoVO));
        }
    }



    public JSONObject getUser(String userId){
        try {
            if(userId!=null){
                JSONArray jArray = ReferObjectUtil.getReferEntityValue(userId, "idm-user");
                if(jArray!=null&&jArray.size()>0){
                    JSONObject json = (JSONObject) jArray.get(0);
                    return json;
                }
            }
        } catch (Exception e) {
//			e.printStackTrace();
        }
        return null;
    }

    public Map<String, String> getErpHeaders() throws Exception {
        Map<String, String> headers = new HashMap<>();
        String nowStr = DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date());
        logger.info("-------------appId:{},secret:{}",appId, secret);
        headers.put("appid", toMD5(appId));
        headers.put("ticket", nowStr);
        headers.put("sign", toMD5(secret + toMD5(appId) + toMD5(nowStr)));
        return headers;
    }
    public String toMD5(String plainText) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hashBytes = digest.digest(plainText.getBytes());

        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xff) + 0x100, 16).substring(1));
        }

        return sb.toString().toLowerCase();
    }

    public static void main(String[] args) {
        MessageInfoVO vo = new MessageInfoVO();
        vo.setParam("[{\"BusiField\":\"待办测试11\",\"Sys_LAST_UPD\":1737539451259,\"PersonName\":\"田刚刚\",\"InstanceID\":\"123-100351000-1778837995772710913-7038\",\"Sys_Created\":1737539451259,\"OriginatorTime\":1737539451259,\"ProcessStateCode\":\"0\",\"OriginatorName\":\"王财\",\"WebApprovalURL\":\"https://testscmm.cefoc.cn/portal/sso/index?usercode=100351000&targeturl=url\",\"YQLTaskTicketOID\":\"123-100351000-1778837995772710913-7038\",\"ApprovalURL\":\"url&userid=1778837995772710913\",\"OriginatorCode\":\"13253636467\",\"ProcessState\":\"待办\",\"IdeaCode\":\"0\",\"Idea\":\"\",\"SYS_Deleted\":0,\"WorkCode\":\"100351000\",\"PersonOID\":\"000078a6-0000-0000-0000-000060f6d999\",\"ActivityChineseName\":\"分包\",\"YQL_SID\":\"123-100351000-1778837995772710913-7038\"}]");
        JSONArray array = JSONObject.parseArray(vo.getParam());
        for (Object o : array) {
            JSONObject map = (JSONObject)JSONObject.toJSON(o);
            map.put("ProcessState", "已办");//审批状态名称（待办、已办）
            map.put("ProcessStateCode", "1");//审批状态编码0,1;待办为0,已办为1
        }
        System.out.println(array);
    }
}
