package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.SubContractMapper;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractDetailService;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractService;
import com.ejianc.business.zdsmaterial.sub.fee.vo.AuditorContractDetailVO;
import com.ejianc.business.zdsmaterial.sub.fee.vo.AuditorSetVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包合同
 *
 * @author generator
 *
 */
@Service("subContractService")
public class SubContractServiceImpl extends BaseServiceImpl<SubContractMapper, SubContractEntity> implements ISubContractService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SubContractMapper mapper;

    @Autowired
    private ISubContractDetailService detailService;

    @Override
    public List<SubContractEntity> getAllBySourceIds(List<String> sourceIds) {
        if(CollectionUtils.isEmpty(sourceIds)){
            return null;
        }
        QueryWrapper<SubContractEntity> query = new QueryWrapper<>();
        query.in("source_contract_id", sourceIds);
        query.in("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        List<SubContractEntity> list = super.list(query);
        return list ;
    }


    @Override
    public void AuditorSetStatus(AuditorSetVO vo){
        List<AuditorContractDetailVO> contractDetailList = vo.getContractDetailList();
        List<AuditorContractDetailVO> auditorContractDetailVOStream = contractDetailList.stream().filter(e -> null!=e.getStationCode()&&e.getStationCode().equals("001")).collect(Collectors.toList());
        if (auditorContractDetailVOStream != null&& auditorContractDetailVOStream.size() > 0){
            List<Long> contractIdS = auditorContractDetailVOStream.stream().map(AuditorContractDetailVO::getContractId).collect(Collectors.toList());
            Collection<SubContractEntity> subContractEntities = super.listByIds(contractIdS);
            if(CollectionUtils.isNotEmpty(subContractEntities)) {
                Map<Long, List<AuditorContractDetailVO>> collect = auditorContractDetailVOStream.stream().collect(Collectors.groupingBy(c -> c.getContractId()));

                subContractEntities.stream().forEach(item-> {
                    List<AuditorContractDetailVO> auditorContractDetailVOS = collect.get(item.getId());
                    logger.info("*********************auditorContractDetailVOS{}*********************", JSONObject.toJSONString(auditorContractDetailVOS));

                    for (AuditorContractDetailVO detailVO:auditorContractDetailVOS){
                        if (detailVO.getRowState()!=null&&detailVO.getRowState().equals("add")){
                            item.setAuditWorkerId(detailVO.getUserId());
                            item.setAuditWorkerName(detailVO.getUserName());
                        }else if (detailVO.getRowState()!=null&&detailVO.getRowState().equals("del")){
                            item.setAuditWorkerId(null);
                            item.setAuditWorkerName(null);
                        }
                    }
                    logger.info("*********************item setAuditWorkerId{}*********************",item.getAuditWorkerId());

                });
                super.saveOrUpdateBatch(subContractEntities,subContractEntities.size());
            }
        }
    }

    @Override
    public Integer performanceNum(Long linkerId, String linkerSid, Long supplierId) {
        QueryWrapper<SubContractEntity> queryWrapper = new QueryWrapper<>();
        if(null != linkerId || StringUtils.isNotEmpty(linkerSid)) {
            queryWrapper.eq("party_contact_id", linkerId).or().eq("party_contact_s_id", linkerSid);
        }
        if(null != supplierId) {
            queryWrapper.eq("supplier_id", supplierId);
        }
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
        int count = super.count(queryWrapper);
        return count;
    }

    @Override
    public Integer finishSettleNum(Long linkerId, String linkerSid, Long supplierId) {

        QueryWrapper<SubContractEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("is_finish", 1);
        queryWrapper.eq("is_sett", 0);
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
        if(null != linkerId || StringUtils.isNotEmpty(linkerSid)) {
            queryWrapper.and(q -> q.eq("party_contact_id", linkerId).or().eq("party_contact_s_id", linkerSid));
        }
        if(null != supplierId) {
            queryWrapper.eq("supplier_id", supplierId);
        }
        int count = super.count(queryWrapper);
        return count;
    }
    @Override
    public Integer settleNum(Long linkerId, String linkerSid, Long supplierId) {
        QueryWrapper<SubContractEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("is_sett", 1);
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
        if(null != linkerId || StringUtils.isNotEmpty(linkerSid)) {
            queryWrapper.and(q -> q.eq("party_contact_id", linkerId).or().eq("pro_manager_sid_party_b_id", linkerSid));
        }
        if(null != supplierId) {
            queryWrapper.eq("supplier_id", supplierId);
        }
        int count = super.count(queryWrapper);
        return count;
    }

    @Override
    public BigDecimal thisYearContractMny(Long linkerId, String linkerSid, Long supplierId) {
        List<SubContractEntity> subContractEntities = mapper.queryNowYearList(linkerId, linkerSid, supplierId);
        if (subContractEntities != null && subContractEntities.size() > 0){
            BigDecimal sum = subContractEntities.stream().map(SubContractEntity::getContractMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            return sum;
        }

        return BigDecimal.ZERO;
    }

    @Override
    @Async(value = "maContextCommonTask")
    public void cancelContract(List<Long> delContractIds) {
        //合同主表作废
        UpdateWrapper<SubContractEntity> update = new UpdateWrapper<>();
        update.in("id", delContractIds);
        update.eq("dr", BaseVO.DR_UNDELETE);
        update.set("dr", 1);
        update.set("update_time", new Date());
        super.update(update);

        //合同子表作废
        detailService.cancelByContractIds(delContractIds);
    }

    @Override
    public List<SupplierVO> getAllSubSupInfoBySourceIds(List<String> supSourceIds) {
        return mapper.getAllSubSupInfoBySourceIds(supSourceIds);
    }

    @Override
    public List<String> getSyncList() {
        return mapper.getSyncList();
    }

    @Override
    public void updateSyncResult(String sourceContractId, String result) {
        mapper.updateSyncResult(sourceContractId, result);
    }

    @Override
    public SupplierVO getSubSupInfoByTenant(Long supTenant) {
        return mapper.getSubSupInfoByTenant(supTenant);
    }

    @Override
    public SupplierVO getSubSupInfoById(Long supplierId) {
        return mapper.getSubSupInfoById(supplierId);
    }
}
