package com.ejianc.business.zdsmaterial.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.material.bean.MatSupplierManagerEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MatSupplierManagerMapper;
import com.ejianc.business.zdsmaterial.material.service.IMatSupplierManagerService;
import com.ejianc.business.zdsmaterial.material.vo.MatSupplierManagerVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 采购计划控制方式
 * 
 * @author generator
 * 
 */
@Service("matSupplierManagerService")
public class MatSupplierManagerServiceImpl extends BaseServiceImpl<MatSupplierManagerMapper, MatSupplierManagerEntity> implements IMatSupplierManagerService {

    @Autowired
    private MatSupplierManagerMapper mapper;

    @Override
    public List<MatSupplierManagerEntity> getAllByUserId(Long userId) {
        QueryWrapper<MatSupplierManagerEntity> query = new QueryWrapper<>();
        query.eq("manager_id", userId);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }

    @Override
    public JSONObject queryCategoryList(QueryParam param) {
        JSONObject jsonObject = new JSONObject();
        Map<String,Object> condition = new HashMap<>();
        for(Map.Entry<String, Parameter> entry:param.getParams().entrySet()) {
            condition.put(entry.getKey(), entry.getValue().getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());

        List<MaterialCategoryVO> dataList = mapper.queryCategoryList(condition);
        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l-> {
            if(l.get("leafFlag").equals(false)){
                l.put("children", new ArrayList<>());
            }
        });

        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
        return jsonObject;
    }

    @Override
    public List<Long> getAllByCategoryIdAndEmpIds(Long categoryId, List<Long> empIds) {
        List<Long> resp = new ArrayList<>();
        QueryWrapper<MatSupplierManagerEntity> query = new QueryWrapper<>();
        query.in("manager_id", empIds);
        query.eq("category_id", categoryId);

        List<MatSupplierManagerEntity> eList = super.list(query);
        if(CollectionUtils.isNotEmpty(eList)) {
            resp = eList.stream().map(MatSupplierManagerEntity::getManagerId).collect(Collectors.toList());
        }
        return resp;
    }

    @Override
    public List<MatSupplierManagerEntity> getAllByCategoryIds(List<Long> categoryIds) {
        QueryWrapper<MatSupplierManagerEntity> query = new QueryWrapper<>();
        query.in("category_id", categoryIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }

    @Override
    public List<MatSupplierManagerEntity> getAllByIds(List<Long> ids) {
        QueryWrapper<MatSupplierManagerEntity> query = new QueryWrapper<>();
        query.in("id", ids);
        query.eq("dr", BaseVO.DR_UNDELETE);
        return super.list(query);
    }

    @Override
    public List<MatSupplierManagerVO> getExportList() {
        return mapper.getExportList();
    }
}
