package com.ejianc.business.zdsmaterial.out.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.zdsmaterial.out.bean.OutStoreEntity;
import com.ejianc.business.zdsmaterial.out.vo.OutStoreVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 领料出库
 * 
 * @author generator
 * 
 */
public interface IOutStoreService extends IBaseService<OutStoreEntity> {

    /**
     * 保存或修改信息
     *
     * @param outStoreVO
     * @return
     */
    CommonResponse<OutStoreVO> saveOrUpdate(OutStoreVO outStoreVO);

    CommonResponse<String> del(List<OutStoreVO> vos);

    String updateBillSupSignSyncInfo(HttpServletRequest request);

    boolean pushBillToSupCenter(OutStoreEntity entity);

    CommonResponse<String> updatePushBill(OutStoreEntity entity);

    Boolean inOutStore(OutStoreEntity entity, Boolean outEffectiveON);

    Boolean inOutStoreRollback(OutStoreEntity entity, Boolean outEffectiveON);

    /**
     * 单据确认
     *
     * @param vo
     */
    String updateBillConfirmState(OutStoreVO vo);

    Map<Long, Boolean> queryConfirmEnable(List<Long> projectIds, List<Long> contractIds);

    OutStoreVO queryDetail(Long id);

    Boolean validateStoreNum(OutStoreVO vo);

    Boolean validateOutNum(OutStoreVO vo);

    /**
     * 接收施工方领料出库
     *
     * @param request 施工方领料出库信息
     * @return 保存结果
     */
    boolean saveOutStore(HttpServletRequest request);

    /**
     * 施工方撤回领料出库
     *
     * @param vo 领料出库信息
     * @return 撤回结果
     */
    boolean delOutStore(OutStoreVO vo);

    /**
     * 查询领料出库列表
     *
     * @param param 查询参数
     * @return 查询结果
     */
    IPage<OutStoreVO> queryOutStoreList(QueryParam param);

//    /**
//     * 领料出库签字
//     *
//     * @param storeVO 需要签字的领料出库信息
//     * @return 签字结果
//     */
//    OutStoreVO saveSignStatus(OutStoreVO storeVO);
}
