package com.ejianc.business.zdsmaterial.sub.subvisa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.InstructionSetEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.SignatureChangeEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.enums.InstructionStatusEnum;
import com.ejianc.business.zdsmaterial.sub.subvisa.service.IInstructionSetService;
import com.ejianc.business.zdsmaterial.sub.subvisa.service.ISignatureChangeService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;

@Service("signatureChange") 
public class SignatureChangeBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ISignatureChangeService service;

	@Autowired
	private IInstructionSetService instructionSetService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IPushMessageApi pushMessageApi;
	@Value("${common.env.base-host}")
	private String BASE_HOST;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		SignatureChangeEntity entity = service.selectById(billId);

		if (entity.getSourceType().equals(InstructionStatusEnum.直接新增.getStatus())){
			//查询引用单状态
			Integer integer = instructionSetService.queryInstructionSetStatus(entity.getSetId());
			if (InstructionStatusEnum.已引用.getStatus().equals(integer)){
				throw new BusinessException("当前指令单已被引用，不允许提交!");
			}
		}
		if (entity.getDetailList().size()>0|| CollectionUtils.isNotEmpty(entity.getDetailList())){
			if (entity.getReceiveStatus().equals(InstructionStatusEnum.已驳回.getStatus())){
				return CommonResponse.error("已驳回的单据，不允许提交！");
			}
			return CommonResponse.success();
		}else {
			return CommonResponse.error("事项为空，不允许提交！");
		}
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		SignatureChangeEntity entity = service.selectById(billId);
		entity.setReceiveStatus(InstructionStatusEnum.审核中.getStatus());
		service.saveOrUpdate(entity,false);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		SignatureChangeEntity entity = service.selectById(billId);
		if (entity.getSourceType().equals(InstructionStatusEnum.直接新增.getStatus())){
			instructionSetService.changeInstructionSetStatus(entity.getSetId(), InstructionStatusEnum.已引用.getStatus());
		}
		entity.setReceiveStatus(InstructionStatusEnum.已审核.getStatus());
		String s = service.pushBill(entity);
		if (StringUtils.isNotBlank(s)) {
			throw new BusinessException(s);
		}
		service.saveOrUpdate(entity,false);
//发送消息
		logger.info("变更签证指令单向乙方联系人id-{}发送消息", entity.getPartyBContactId().toString());
		PushMsgParameter parameter = new PushMsgParameter();
		parameter.setSubject("【变更签证指令单】：【"+entity.getBillCode()+"】，【"
				+ DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss",
				new Date()) +"】发货单已验收，请查看！");
		StringBuilder content = new StringBuilder();
		content.append("【").append(entity.getSupplierName()).append("】，【")
				.append(entity.getProjectName()).append("】，【")
				.append(entity.getSubContractName()).append("】进行变更签证，【").append(entity.getBillCode()).append("】，请尽快处理！");
		parameter.setContent(content.toString());
		parameter.setPcUrl(BASE_HOST + "ejc-zdsmaterial-frontend/#/signatureChange/card?id=" + entity.getId().toString());
		String[] recIds = new String[]{entity.getPartyBContactId().toString()}; //验收人Id
		parameter.setReceivers(recIds);
		sendMsg(parameter, entity.getId(), "变更签证指令单向乙方联系人发送消息");
		return CommonResponse.success();
	}
	public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
		parameter.setSaveFlag(true);
		parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
		parameter.setMsgType("notice");
		parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, PushMsgParameter.CHANNEL_TYPE_EMAIL});

		CommonResponse<String> sendResp = pushMessageApi.pushMessage(parameter);
		if (!sendResp.isSuccess()) {
			logger.error("{}-发送消息失败，单据Id-{}，发送消息结果-{}", oprMsg, billId, JSONObject.toJSONString(sendResp, SerializerFeature.PrettyFormat,
					SerializerFeature.WriteMapNullValue));
		} else {
			logger.info("{}-发送消息成功！", oprMsg);
		}
	}


	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
