package com.ejianc.business.zdsmaterial.sub.subvisa.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zdsmaterial.sub.subvisa.mapper.SignatureChangeDetailMapper;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.SignatureChangeDetailEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.service.ISignatureChangeDetailService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包签章变更-事项清单
 * 
 * @author generator
 * 
 */
@Service("signatureChangeDetailService")
public class SignatureChangeDetailServiceImpl extends BaseServiceImpl<SignatureChangeDetailMapper, SignatureChangeDetailEntity> implements ISignatureChangeDetailService{

    @Override
    public Map<Long, List<SignatureChangeDetailEntity>> getAllByPids(List<Long> pIds) {
        Map<Long, List<SignatureChangeDetailEntity>> resp = new HashMap<>();
        QueryWrapper<SignatureChangeDetailEntity> query = new QueryWrapper<>();
        query.in("signature_id", pIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<SignatureChangeDetailEntity> dbList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            return dbList.stream().collect(Collectors.groupingBy(SignatureChangeDetailEntity::getSignatureId));
        }

        return resp;
    }
}
