package com.ejianc.business.zdsmaterial.asynchandler.service.impl;

import com.ejianc.business.zdsmaterial.asynchandler.bean.SyncJobExecRecordsEntity;
import com.ejianc.business.zdsmaterial.asynchandler.mapper.SyncJobExecRecordMapper;
import com.ejianc.business.zdsmaterial.asynchandler.service.ISyncJobExecRecordService;
import com.ejianc.business.zdsmaterial.erp.vo.LinkerAccCooVO;
import com.ejianc.business.zdssupplier.material.api.IMatLinkerApi;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.business.zdssupplier.sub.api.ISubLinkerApi;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author CJ
 * @Description:
 * @date 2024/8/15 11:15
 */
@Service(value = "syncJobExecRecordService")
public class SyncJobExecRecordServiceImpl extends BaseServiceImpl<SyncJobExecRecordMapper, SyncJobExecRecordsEntity> implements ISyncJobExecRecordService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMatLinkerApi matLinkerApi;

    @Autowired
    private ISubLinkerApi subLinkerApi;

    @Async(value = "maContextCommonTask")
    @Override
    public String linkerAccCoo(String linkerType, Long linkerId) {

        logger.info("*********INFO*********联系人系统账号开通，联系人类型:{}，联系人ID:{}********INFO********",linkerType, linkerId.toString());
        String execErrMsg = null;
        SyncJobExecRecordsEntity records = new SyncJobExecRecordsEntity();

        try {
            records.setReqParam(linkerId.toString());
            records.setExecTime(new Date());

            if(LinkerAccCooVO.LINKER_TYPE_MAT.equals(linkerType)) {
                records.setReqUrl( "/api/matLinkerApi/accCoordination");
                MatLinkerVO matLinkerVO = new MatLinkerVO();
                matLinkerVO.setId(linkerId);
                CommonResponse<MatLinkerVO> resp = matLinkerApi.accCoordination(matLinkerVO);
                records.setExecResult(resp.isSuccess() ? "2" : "1"); //2-执行成功，1-执行失败
                records.setErpErrResult(resp.getMsg());
                if(!resp.isSuccess()) {
                    execErrMsg = StringUtils.isNotBlank(resp.getMsg()) ? resp.getMsg() : "网络问题，协同账号开通失败！";
                }
            } else {
                records.setReqUrl("/api/subLinkerApi/accCoordination");
                LinkerVO linkerVO = new LinkerVO();
                linkerVO.setId(linkerId);
                CommonResponse<LinkerVO> resp = subLinkerApi.accCoordination(linkerVO);
                records.setExecResult(resp.isSuccess() ? "2" : "1"); //2-执行成功，1-执行失败
                records.setErpErrResult(resp.getMsg());
                if(!resp.isSuccess()) {
                    execErrMsg = StringUtils.isNotBlank(resp.getMsg()) ? resp.getMsg() : "网络问题，协同账号开通失败！";
                }
            }
        } catch (Exception e) {
            logger.error("*********ERROR*********联系人系统账号开通 异常，联系人类型:{}，联系人ID:{}********ERROR********",linkerType, linkerId.toString());
            logger.error("*********ERROR*********联系人系统账号开通 异常，********ERROR********", e);
            execErrMsg = "网络问题，协同账号开通失败！";
        }

        super.saveOrUpdate(records, false);
        return execErrMsg;
    }
}
