/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.erp.bean.SubTypeEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.SubTypeMapper;
import com.ejianc.business.zdsmaterial.erp.service.ISubTypeService;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subTypeService")
public class SubTypeServiceImpl
extends BaseServiceImpl<SubTypeMapper, SubTypeEntity>
implements ISubTypeService {
    @Autowired
    private SubTypeMapper mapper;

    @Override
    public List<SubTypeEntity> getAllBySourceIds(List<String> sourceIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"source_id", sourceIds);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return super.list((Wrapper)query);
    }

    @Override
    public JSONObject querySubTypeTree(QueryParam param) {
        JSONObject jsonObject = new JSONObject();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : param.getParams().entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<SubTypeVO> dataList = this.mapper.querySubTypeTree(condition);
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l -> {
            if (l.get("leafFlag").equals(false)) {
                l.put("children", new ArrayList());
            }
        });
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return jsonObject;
    }

    @Override
    public List<SubTypeVO> getAllByIds(List<Long> ids) {
        List<Object> resp = new ArrayList<SubTypeVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        List dbList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            resp = BeanMapper.mapList((Iterable)dbList, SubTypeVO.class);
        }
        return resp;
    }
}

