/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategorySettingsEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MaterialCategorySettingsMapper;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategorySettingsService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategorySettingsVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialCategorySettingsService")
public class MaterialCategorySettingsServiceImpl
extends BaseServiceImpl<MaterialCategorySettingsMapper, MaterialCategorySettingsEntity>
implements IMaterialCategorySettingsService {
    @Autowired
    private MaterialCategorySettingsMapper mapper;
    @Autowired
    private IMaterialCategoryService categoryService;

    @Override
    public CommonResponse<MaterialCategorySettingsVO> saveOrUpdate(MaterialCategorySettingsVO saveOrUpdateVO) {
        CommonResponse<Boolean> booleanCommonResponse = this.betweenMinAndMaxRation(saveOrUpdateVO);
        if (!booleanCommonResponse.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38 \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff01");
        }
        if (!((Boolean)booleanCommonResponse.getData()).booleanValue()) {
            throw new BusinessException("\u63a7\u5236\u8303\u56f4\u5f00\u59cb\u548c\u7ed3\u675f\u533a\u95f4\u4e0d\u5141\u8bb8\u51fa\u73b0\u5728\u5df2\u6709\u533a\u95f4\u5185!");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null != saveOrUpdateVO.getId()) {
            queryWrapper.ne((Object)"id", (Object)saveOrUpdateVO.getId());
        }
        if (null == saveOrUpdateVO.getCategoryId()) {
            throw new BusinessException("\u7269\u6599\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        queryWrapper.eq((Object)"category_id", (Object)saveOrUpdateVO.getCategoryId());
        queryWrapper.eq((Object)"control_mode", (Object)saveOrUpdateVO.getControlMode());
        MaterialCategorySettingsEntity entity = (MaterialCategorySettingsEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialCategorySettingsEntity.class));
        super.saveOrUpdate((Object)entity, false);
        MaterialCategorySettingsVO vo = (MaterialCategorySettingsVO)BeanMapper.map((Object)((Object)entity), MaterialCategorySettingsVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<JSONObject> queryCategoryList(QueryParam param) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : param.getParams().entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<MaterialCategoryVO> dataList = this.categoryService.queryListAndRuledFlag(condition);
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l -> {
            if (l.get("leafFlag").equals(false)) {
                l.put("children", new ArrayList());
            }
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)jsonObject);
    }

    @Override
    public CommonResponse<Boolean> betweenMinAndMaxRation(MaterialCategorySettingsVO vo) {
        long l = this.mapper.betweenMinAndMaxRation(vo);
        return CommonResponse.success((Object)(l > 0L ? Boolean.FALSE : Boolean.TRUE));
    }

    @Override
    public Map<Long, List<MaterialCategorySettingsEntity>> returnSettings(List<Long> ids) {
        List<MaterialCategoryVO> categoryList = this.categoryService.queryCategoryListByIds(ids);
        ArrayList<String> allCategoryIds = new ArrayList<String>();
        List collect = categoryList.stream().map(e -> e.getInnerCode()).collect(Collectors.toList());
        for (String e2 : collect) {
            List<String> strings = Arrays.asList(e2.split("\\|"));
            allCategoryIds.addAll(strings);
        }
        QueryWrapper categoryAllQueryWrapper = new QueryWrapper();
        categoryAllQueryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        categoryAllQueryWrapper.in((Object)"id", allCategoryIds);
        List materialCategoryEntities = this.categoryService.list((Wrapper)categoryAllQueryWrapper);
        Map<Long, MaterialCategoryEntity> allCategory = materialCategoryEntities.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.in((Object)"category_id", allCategoryIds);
        List oneSettings = super.list((Wrapper)queryWrapper);
        HashMap<Long, List<MaterialCategorySettingsEntity>> endMaps = new HashMap<Long, List<MaterialCategorySettingsEntity>>();
        if (null != oneSettings && CollectionUtils.isNotEmpty((Collection)oneSettings)) {
            Map<Long, List<MaterialCategorySettingsEntity>> collect1 = oneSettings.stream().collect(Collectors.groupingBy(e -> e.getCategoryId()));
            Map<String, MaterialCategorySettingsEntity> allSettings = oneSettings.stream().collect(Collectors.toMap(e -> e.getCategoryId() + "_" + e.getControlMode(), e -> e));
            for (Map.Entry<Long, MaterialCategoryEntity> entry : allCategory.entrySet()) {
                entry.getValue().setRuledFlag(collect1.keySet().contains(entry.getKey()) ? 1 : 0);
            }
            for (Long l : ids) {
                List<MaterialCategorySettingsEntity> materialCategorySettingsEntity = this.checkCategoryId(allCategory, allSettings, l);
                if (null == materialCategorySettingsEntity) continue;
                endMaps.put(l, materialCategorySettingsEntity);
            }
        }
        return endMaps;
    }

    public List<MaterialCategorySettingsEntity> checkCategoryId(Map<Long, MaterialCategoryEntity> allCategory, Map<String, MaterialCategorySettingsEntity> allSettings, Long checkId) {
        if (allCategory.containsKey(checkId)) {
            MaterialCategoryEntity entity = allCategory.get(checkId);
            if (1 == entity.getRuledFlag()) {
                ArrayList<MaterialCategorySettingsEntity> list = new ArrayList<MaterialCategorySettingsEntity>();
                if (allSettings.containsKey(checkId + "_1")) {
                    list.add(allSettings.get(checkId + "_1"));
                }
                if (allSettings.containsKey(checkId + "_2")) {
                    list.add(allSettings.get(checkId + "_2"));
                }
                if (allSettings.containsKey(checkId + "_3")) {
                    list.add(allSettings.get(checkId + "_3"));
                }
                return list;
            }
            if (null != entity.getParentId()) {
                return this.checkCategoryId(allCategory, allSettings, entity.getParentId());
            }
        }
        return null;
    }
}

