package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.asynchandler.QueueUtils;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.BusinessContractEntity;
import com.ejianc.business.zdsmaterial.erp.bean.FeePackageEntity;
import com.ejianc.business.zdsmaterial.erp.service.IBusinessContractService;
import com.ejianc.business.zdsmaterial.erp.service.IFeePackageService;
import com.ejianc.business.zdsmaterial.erp.vo.BusinessContractVO;
import com.ejianc.business.zdsmaterial.erp.vo.FeePackageVO;
import com.ejianc.business.zdsmaterial.erp.vo.SyncJobExecRecordsVO;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.security.MessageDigest;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2024/1/17 10:16
 */
@RestController
@RequestMapping("/erpRef/")
public class FeePackageController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${erp.appId}")
    private String appId;

    @Value("${erp.secret}")
    private String secret;

    @Value("${erp.reqHost}")
    private String reqHost;

    @Autowired
    private IFeePackageService feePackageService;

    @Autowired
    private IBusinessContractService businessContractService;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IMaterialCategoryService categoryService;

    @Autowired
    private QueueUtils queueUtils;

    private final String ERP_CACHE_PROJECT_PREFIX = "erp::project::";

    private final String FEE_PACKAGE_ERP_REQ_URL = "/cefoc/yql/getContractLimited_SubAList";
    private final String BUSINESS_CONTRACT_ERP_REQ_URL = "/cefoc/yql/getContractLimitedList";

    @Value("${spring.cloud.config.profile}")
    private String profile;

    /**
     * ERP费用包同步
     *
     * @param params: start:开始日期 end:结束日期
     * @return
     */
    @PostMapping(value = "syncZDSFeePackage")
    public CommonResponse<String> syncZDSFeePackage(@RequestBody Map<String, String> params) {
        logger.info("*********************中电四-费用包信息同步任务 开始*********************");

        Map<String,BusinessContractEntity> contractCache = new HashMap<>();
        Map<String, Long> projectCache = new HashMap<>();


        Map<String, Object> param = new HashMap<>();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + FEE_PACKAGE_ERP_REQ_URL;
        JSONObject reqJson = null;
        JSONArray pageData = null;

        Integer pageNum = null != params.get("pageNum") ? Integer.valueOf(params.get("pageNum")) : 0;
        Integer pageSize = null != params.get("pageSize") ? Integer.valueOf(params.get("pageSize")) :
                Integer.valueOf(ZDSInterfaceCommonUtil.getErpDataBatchSize());
        String startDate= params.get("startDate");
        String endDate= params.get("endDate");
        boolean noDate = null != params && null != params.get("noDate") ? "true".equals(params.get("noDate")) : false;
        String reqDateStr = null;
        boolean hasNext = true;
        String reqResp = null;
        //请求连续失败次数，连续两次请求失败时 任务终止
        Integer reqErrorTimes = null != params && null != params.get("reqErrorTimes") ? Integer.valueOf(params.get("reqErrorTimes")) : 0;

        if(!noDate) {
            //获取从今天往前2天内的数据
            reqDateStr = DateFormatUtil.formatDate("yyyy-MM-dd", new Date());
            String startDateStr = DateFormatUtil.formatDate("yyyy-MM-dd", DateUtils.addDays(new Date(), -2)) + " 00:00:00";
            String endDateStr = reqDateStr + " 23:59:59";
            param.put("BeginDateTime", StringUtils.isNotBlank(startDate) ? startDate : startDateStr);
            param.put("EndDateTime", StringUtils.isNotBlank(endDate) ? endDate : endDateStr);
        }

        if(null != params.get("projectCode") && StringUtils.isNotBlank(params.get("projectCode"))) {
            CommonResponse<ProjectPoolSetVO> projectResp = projectPoolApi.getOneByCode(params.get("projectCode"));
            if(!projectResp.isSuccess()) {
                logger.error("同步任务执行失败，根据项目编码-{}查询项目信息失败！", params.get("projectCode"));
                return CommonResponse.error("同步任务执行失败，根据项目编码查询项目信息失败！");
            }
            if(null == projectResp.getData()) {
                logger.error("同步任务执行失败，根据项目编码-{}查询项目信息为空！", params.get("projectCode"));
                return CommonResponse.error("同步任务执行失败，根据项目编码查询项目信息为空！");
            }
            reqUrl = reqUrl + "?ProjectOID="+projectResp.getData().getSourceId();
        }

        if(null != params.get("businessContractId") && StringUtils.isNotBlank(params.get("businessContractId"))) {
            Long businessContractId = Long.valueOf(params.get("businessContractId"));
            BusinessContractEntity businessContract = businessContractService.selectById(businessContractId);
            if(null == businessContract) {
                logger.error("同步任务执行失败，根据商务合同id-{}查询商务合同信息为空！", businessContractId);
                return CommonResponse.error("同步任务执行失败，查询商务合同信息为空！");
            }
            reqUrl = reqUrl + (reqUrl.indexOf("?") > 0 ? "&" : "?") +"ContractLimitedOID="+businessContract.getSourceId();
        }

        try {
            Map<String, String> headers = null;
            param.put("PageSize", pageSize);

            while (hasNext) {
                headers = ZDSInterfaceCommonUtil.getErpHeaders();
                param.put("PageNum", ++pageNum);
                reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers,
                        ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
                reqJson = JSONObject.parseObject(reqResp);

                if ("ok".equals(reqJson.getString("status"))) {
                    pageData = reqJson.getJSONArray("data");
                    if (null != pageData && pageData.size() > 0) {
                        logger.info("中电四费用包同步，处理第{}页, {}条数据", pageNum, pageData.size());
                        handleFeePackageErpData(pageData, contractCache, projectCache);
                    } else {
                        logger.info("中电四费用包同步 处理数据完成！！！总共{}页数据！", pageNum);
                        hasNext = false;
                    }
                } else {
                    logger.error("请求中电四获取费用包结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
                    hasNext = false;
                    queueUtils.sendMq(SyncJobExecRecordsVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(
                            new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), PlanConstant.STRING_YES, reqResp, null)));
                }
            }

        } catch (Exception e) {
            logger.error("获取中电四费用包信息异常, 请求地址：{}, 请求参数：{},e:", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat),e);

            queueUtils.sendMq(SyncJobExecRecordsVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(
                    new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), PlanConstant.STRING_YES, reqResp, e.getMessage())));

            reqErrorTimes++;
            if(reqErrorTimes >= 5) {
                return CommonResponse.error("同步中电四费用包信息异常");
            }
            try {
                logger.info("同步中电四费用包信息异常，5s后重试.........,当前已同步{}页数据", pageNum-1);
                //休息1.5s
                Thread.sleep(5000);
                Map<String, String> reqParam = new HashMap<>();
                reqParam.put("pageSize", pageSize+"");
                reqParam.put("pageNum", (pageNum < 1 ? pageNum : pageNum-1)+"");
                reqParam.put("reqErrorTimes", reqErrorTimes+"");
                reqParam.put("noDate", noDate+"");
                return syncZDSFeePackage(reqParam);
            } catch (Exception e1) {
                logger.error("重启中电四银行支行同步接口异常,", e1);
                return CommonResponse.error("同步中电四银行信息异常");
            }
        }

        logger.info("*********************中电四-费用包信息同步任务 结束*********************");
        queueUtils.sendMq(SyncJobExecRecordsVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), PlanConstant.STRING_YES)));
        return CommonResponse.success("中电四费用包任务执行结束！");
    }

    private void handleFeePackageErpData(JSONArray pageData, Map<String, BusinessContractEntity> contractCache, Map<String, Long> projectCache) {
        JSONObject tmp = null;
        FeePackageEntity tmpEntity = null;
        Map<String, FeePackageEntity> sourceIdMap = new HashMap<>();
        List<FeePackageEntity> saveList = new ArrayList<>();

        for (Object obj : pageData) {
            tmp = (JSONObject) obj;
            tmpEntity = new FeePackageEntity();
            tmpEntity.setSourceId(tmp.getString("C_PCM_ContractLimited_SubAOID"));
            tmpEntity.setProjectName(tmp.getString("Account_Project_shortname"));
            tmpEntity.setProjectCode(tmp.getString("Account_Project_id"));
            tmpEntity.setProjectSid(tmp.getString("C_CM_AccountingProjectSetOID"));
            tmpEntity.setBusinessContractName(tmp.getString("Title"));
            tmpEntity.setBusinessContractCode(tmp.getString("CommerceCode"));
            tmpEntity.setBusinessContractSid(tmp.getString("ContractLimited_FK"));
            tmpEntity.setMaterialPackageCode(tmp.getString("MaterialPackageCode"));
            tmpEntity.setInventoryClassifyName(tmp.getString("InventoryClassifyName"));
            tmpEntity.setChargeTypeName(tmp.getString("ChargeTypeName"));
            tmpEntity.setContractMoney(tmp.getString("ContractMoney"));
            tmpEntity.setExecuteLimited(tmp.getString("ExecuteLimited"));
            tmpEntity.setSystemClassifyName(tmp.getString("SystemClassifyName"));
            tmpEntity.setSystemClassifyCode(tmp.getString("SystemClassifyCode"));
            tmpEntity.setInventoryClassifySid(tmp.getString("InventoryClassifySid"));
            tmpEntity.setInventoryClassifyCode(tmp.getString("InventoryClassifyCode"));
            tmpEntity.setPackageScope(tmp.getString("PackageScope")); //包范围
            ProjectPoolSetVO projectVo = getProject(tmp.getString("C_CM_AccountingProjectSetOID"));
            if(null!=projectVo){
                tmpEntity.setProjectId(projectVo.getId());
            }
            BusinessContractEntity businessContractEntity =  getBusinessContract(tmp.getString("ContractLimited_FK"));
            if(null!=businessContractEntity){
                tmpEntity.setBusinessContractId(businessContractEntity.getId());
            }
            sourceIdMap.put(tmpEntity.getSourceId(), tmpEntity);
        }

        //记录需要查询的项目
        List<String> projectSourceIds = new ArrayList<>();
        //记录需要查询的商务合同
        List<String> businessSourceIds = new ArrayList<>();


        List<FeePackageEntity> dbListBySourceId = feePackageService.getAllBySourceIds(new ArrayList<>(sourceIdMap.keySet()));
        if (CollectionUtils.isNotEmpty(dbListBySourceId)) {
            //更新列表
            for (FeePackageEntity dbEntity : dbListBySourceId) {
                tmpEntity = sourceIdMap.get(dbEntity.getSourceId());

                if(null == tmpEntity) {
                    logger.error("没有匹配的费用包：{}", dbEntity.getSourceId());
                    continue;
                }
                if(null==dbEntity.getProjectId()|| !StringUtils.equals(tmpEntity.getProjectSid(), dbEntity.getProjectSid())){
                    projectSourceIds.add(dbEntity.getProjectSid());
                    //项目信息变化
                    dbEntity.setProjectSid(tmpEntity.getProjectSid());
                    dbEntity.setProjectCode(tmpEntity.getProjectCode());
                    dbEntity.setProjectName(tmpEntity.getProjectName());
                    dbEntity.setProjectId(null);
                }
                if (null==dbEntity.getBusinessContractId()|| !StringUtils.equals(tmpEntity.getBusinessContractSid(), dbEntity.getBusinessContractSid())) {
                    businessSourceIds.add(dbEntity.getBusinessContractSid());
                    //商务合同信息变化
                    dbEntity.setBusinessContractId(null);
                    dbEntity.setBusinessContractSid(tmpEntity.getBusinessContractSid());
                    dbEntity.setBusinessContractCode(tmpEntity.getBusinessContractCode());
                    dbEntity.setBusinessContractName(tmpEntity.getBusinessContractName());
                }
                dbEntity.setMaterialPackageCode(tmpEntity.getMaterialPackageCode());
                dbEntity.setInventoryClassifyName(tmpEntity.getInventoryClassifyName());
                dbEntity.setChargeTypeName(tmpEntity.getChargeTypeName());
                dbEntity.setContractMoney(tmpEntity.getContractMoney());
                dbEntity.setExecuteLimited(tmpEntity.getExecuteLimited());
                dbEntity.setSystemClassifyName(tmpEntity.getSystemClassifyName());
                dbEntity.setSystemClassifyCode(tmpEntity.getSystemClassifyCode());
                dbEntity.setInventoryClassifySid(tmpEntity.getInventoryClassifySid());
                dbEntity.setInventoryClassifyCode(tmpEntity.getInventoryClassifyCode());
                dbEntity.setPackageScope(tmpEntity.getPackageScope());
                saveList.add(dbEntity);
                sourceIdMap.remove(dbEntity.getSourceId());
            }
        }

        if (!sourceIdMap.isEmpty()) {
            saveList.addAll(sourceIdMap.values());
        }
        //查询项目信息
        if (CollectionUtils.isNotEmpty(projectSourceIds)) {
            QueryParam qm = new QueryParam();
            qm.getParams().put("sourceId", new Parameter(QueryParam.IN, projectSourceIds));
            CommonResponse<JSONArray> prjResp = projectPoolApi.getProjectPoolList(qm);
            if (!prjResp.isSuccess()) {
                logger.error("根据项目sourceId列表-{}，获取项目信息失败", JSONObject.toJSONString(projectSourceIds));
            }
            for (ProjectPoolSetVO project : JSONArray.parseArray(JSONObject.toJSONString(prjResp.getData()), ProjectPoolSetVO.class)) {
                projectCache.put(project.getSourceId(), project.getId());
            }
        }
        List<BusinessContractEntity> upBusinessList = new ArrayList<>();
        //查询项目信息
        if (CollectionUtils.isNotEmpty(businessSourceIds)) {

            List<BusinessContractEntity> businessList =  businessContractService.getAllBySourceIds(businessSourceIds);
            for (BusinessContractEntity business : businessList) {
                contractCache.put(business.getSourceId(), business);
            }
        }
        saveList.stream().forEach(item -> {
            //设置项目信息
            if (null == item.getProjectId()) {
                if (projectCache.containsKey(item.getProjectSid())) {
                    item.setProjectId(projectCache.get(item.getProjectSid()));
                }
            }
            //设置合同信息
            if (null == item.getBusinessContractId()) {
                if (contractCache.containsKey(item.getBusinessContractSid())) {
                    BusinessContractEntity businessContractEntity = contractCache.get(item.getBusinessContractSid());

                    item.setBusinessContractId(businessContractEntity.getId());
                    String contractMoney = item.getContractMoney();
                    String executeLimited = item.getExecuteLimited();
                    businessContractEntity.setContractMoney(contractMoney==null? BigDecimal.ZERO:new BigDecimal(contractMoney));
                    businessContractEntity.setExecuteLimited(executeLimited==null? BigDecimal.ZERO:new BigDecimal(executeLimited));
                    upBusinessList.add(businessContractEntity);

                }
            }
        });
        //保存
        feePackageService.saveOrUpdateBatch(saveList, saveList.size(), false);
        if (CollectionUtils.isNotEmpty(upBusinessList)){
            businessContractService.saveOrUpdateBatch(upBusinessList, upBusinessList.size(), false);
        }
    }


    @PostMapping(value = "feePackage/pageList")
    public CommonResponse<JSONObject> feePackagePageList(@RequestBody Map<String, Object> param) throws Exception {
        JSONObject resp = new JSONObject();
        StringBuilder reqUrl = new StringBuilder();
        Map<String, Object> params = new HashMap<>();
        params.put("PageSize", param.get("pageSize"));
        params.put("PageNum", param.get("pageNum"));
        reqUrl.append(reqHost).append(FEE_PACKAGE_ERP_REQ_URL);
        String nowStr = DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date());
        if (param.containsKey("condition")) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject((String) param.get("condition"));
            if (_con.containsKey("projectId")) {
                reqUrl.append("?ProjectOID=").append(getProjectSid(Long.valueOf(_con.getString("projectId"))));
            }
            if (_con.containsKey("contractId")) {
                reqUrl.append("?ContractLimitedOID=").append(_con.getString("contractId"));
            }
        }
        Map<String, String> headers = new HashMap<>();
        headers.put("appid", toMD5(appId));
        headers.put("ticket", nowStr);
        headers.put("sign", toMD5(secret + toMD5(appId) + toMD5(nowStr)));

        String feePackageResp = HttpTookit.postByJson(reqUrl.toString(), JSONObject.toJSONString(params), headers, 10000, 10000);
        logger.info("url:{},params:{},headers:{},费用包数据：{}", reqUrl, JSONObject.toJSONString(params), JSONObject.toJSONString(headers), feePackageResp);
        JSONObject result = JSONObject.parseObject(feePackageResp);
        if (!"ok".equals(result.getString("status"))) {
            return CommonResponse.error("获取ERP费用包信息失败");
        }
        resp.put("total", result.getString("allCount"));
        resp.put("current", param.get("pageNum"));
        resp.put("size", param.get("pageSize"));
        resp.put("records", result.getJSONArray("data"));
        return CommonResponse.success(resp);
    }

    /**
     * ERP费用包同步
     *
     * @param params: start:开始日期 end:结束日期
     * @return
     */
    @PostMapping(value = "syncZDSBusinessContract")
    public CommonResponse<String> syncZDSBusinessContract(@RequestBody Map<String, String> params) {
        logger.info("*********************中电四-费用包同步任务 开始*********************");

        Map<String, Long> projectCache = new HashMap<>();

        Map<String, Object> param = new HashMap<>();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + BUSINESS_CONTRACT_ERP_REQ_URL;
        JSONObject reqJson = null;
        JSONArray pageData = null;
        Integer pageNum = null != params.get("pageNum") ? Integer.valueOf(params.get("pageNum").toString()) : 0;
        Integer pageSize = null != params.get("pageSize") ? Integer.valueOf(params.get("pageSize").toString()) : Integer.valueOf(ZDSInterfaceCommonUtil.getErpDataBatchSize());

        String reqDateStr = null;
        boolean hasNext = true;
        String reqResp = null;

        if(null != params.get("projectCode") && StringUtils.isNotBlank(params.get("projectCode"))) {
            CommonResponse<ProjectPoolSetVO> projectResp = projectPoolApi.getOneByCode(params.get("projectCode"));
            if(!projectResp.isSuccess()) {
                logger.error("同步任务执行失败，根据项目编码-{}查询项目信息失败！", params.get("projectCode"));
                return CommonResponse.error("同步任务执行失败，根据项目编码查询项目信息失败！");
            }
            if(null == projectResp.getData()) {
                logger.error("同步任务执行失败，根据项目编码-{}查询项目信息为空！", params.get("projectCode"));
                return CommonResponse.error("同步任务执行失败，根据项目编码查询项目信息为空！");
            }
            reqUrl = reqUrl + "?ProjectOID="+projectResp.getData().getSourceId();
        } else {
            param.put("BeginDateTime", DateFormatUtil.formatDate("yyyy-MM-dd", DateUtil.addDays(new Date(), -2)) + " 00:00:00");
            param.put("EndDateTime", DateFormatUtil.formatDate("yyyy-MM-dd", new Date()) + " 23:59:59");
        }

        try {
            Map<String, String> headers = null;
            param.put("PageSize", pageSize);

            while (hasNext) {
                headers = ZDSInterfaceCommonUtil.getErpHeaders();
                param.put("PageNum", ++pageNum);
                reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers,
                        ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
                reqJson = JSONObject.parseObject(reqResp);

                if ("ok".equals(reqJson.getString("status"))) {
                    pageData = reqJson.getJSONArray("data");
                    if (null != pageData && pageData.size() > 0) {
                        logger.info("中电四商务合同同步，处理第{}页, {}条数据", pageNum, pageData.size());
                        handleBusinessErpData(pageData, projectCache);
                        if(pageData.size() < pageSize) {
                            hasNext = false;
                        }
                    } else {
                        logger.info("中电四商务合同同步 处理数据完成！！！总共{}页数据！", pageNum);
                        hasNext = false;
                    }
                } else {
                    logger.error("请求中电四获取商务合同结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
                    hasNext = false;
                    queueUtils.sendMq(SyncJobExecRecordsVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(
                            new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), PlanConstant.STRING_YES, reqResp, null)));
                }
            }

        } catch (Exception e) {
            logger.error("获取中电四商务合同信息异常, 请求地址：{}, 请求参数：{},e:{}", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat),e);
            queueUtils.sendMq(SyncJobExecRecordsVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(
                    new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), PlanConstant.STRING_YES, reqResp, e.getMessage())));
            return CommonResponse.error("同步中电商务合信息异常");
        }

        logger.info("*********************中电四-商务合同信息同步任务 结束*********************");
        queueUtils.sendMq(SyncJobExecRecordsVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), PlanConstant.STRING_YES)));
        return CommonResponse.success("中电四商务合同任务执行结束！");
    }

    private void handleBusinessErpData(JSONArray pageData, Map<String, Long> projectCache) {
        JSONObject tmp = null;
        BusinessContractEntity tmpEntity = null;
        Map<String, BusinessContractEntity> sourceIdMap = new HashMap<>();
        List<BusinessContractEntity> saveList = new ArrayList<>();
        //记录需要查询的项目
//        List<String> projectSourceIds = new ArrayList<>();
        Set<String> projectSourceIds = new HashSet<>();

        for (Object obj : pageData) {
            tmp = (JSONObject) obj;
            tmpEntity = BeanMapper.map(tmp, BusinessContractEntity.class);
            tmpEntity.setPcmContractOid(tmp.getString("C_PCM_ContractLimitedOID"));
            tmpEntity.setSourceId(tmp.getString("ContractInfo_FK"));
            tmpEntity.setProjectName(tmp.getString("Account_Project_shortname"));
            tmpEntity.setProjectCode(tmp.getString("Account_Project_id"));
            tmpEntity.setProjectSid(tmp.getString("C_CM_AccountingProjectSetOID"));
            tmpEntity.setContractName(tmp.getString("ContractName"));
            tmpEntity.setContractCode(tmp.getString("CommerceCode"));
            tmpEntity.setContractFlag(tmp.getInteger("ContractFlag"));
            tmpEntity.setParentContractSid(tmp.getString("Contract_PrarentSid"));
            projectSourceIds.add(tmp.getString("C_CM_AccountingProjectSetOID"));
//            ProjectPoolSetVO projectPoolSetVO = getProject(tmp.getString("C_CM_AccountingProjectSetOID"));
//            if (projectPoolSetVO!=null){
//                tmpEntity.setProjectId(projectPoolSetVO.getId());
//            }
            sourceIdMap.put(tmpEntity.getSourceId(), tmpEntity);
        }
        //
        List<BusinessContractEntity> dbListBySourceId = businessContractService.getAllBySourceIds(new ArrayList<>(sourceIdMap.keySet()));
        if (CollectionUtils.isNotEmpty(dbListBySourceId)) {
            //更新列表
            for (BusinessContractEntity dbEntity : dbListBySourceId) {
                tmpEntity = sourceIdMap.get(dbEntity.getSourceId());
                if(null == tmpEntity) {
                    continue;
                }
                dbEntity.setPcmContractOid(tmpEntity.getPcmContractOid());
                dbEntity.setSourceId(tmpEntity.getSourceId());
                dbEntity.setContractFlag(tmpEntity.getContractFlag());
                if(StringUtils.isNotBlank(tmpEntity.getParentContractSid())) {
                    dbEntity.setParentContractSid(tmpEntity.getParentContractSid());
                }
                if(StringUtils.isBlank(dbEntity.getProjectSid())) {
                    dbEntity.setProjectSid(tmpEntity.getProjectSid());
                }
                //更新项目 原项目为空
                if(null==dbEntity.getProjectId()||!tmpEntity.getProjectSid().equals(dbEntity.getProjectSid())){
                    projectSourceIds.add(dbEntity.getProjectSid());
                    dbEntity.setProjectSid(tmpEntity.getProjectSid());
                    dbEntity.setProjectName(tmpEntity.getProjectName());
                    dbEntity.setProjectCode(tmpEntity.getProjectCode());
                    dbEntity.setProjectId(null);
                }else{
                    projectSourceIds.remove(dbEntity.getProjectSid());
                }
                dbEntity.setContractCode(tmpEntity.getContractCode());
                dbEntity.setContractName(tmpEntity.getContractName());
                saveList.add(dbEntity);
                sourceIdMap.remove(dbEntity.getSourceId());
            }
        }

        if (!sourceIdMap.isEmpty()) {
            saveList.addAll(sourceIdMap.values());
        }
        //查询项目信息
        if (CollectionUtils.isNotEmpty(projectSourceIds)) {
            QueryParam qm = new QueryParam();
            qm.getParams().put("sourceId", new Parameter(QueryParam.IN, new ArrayList<>(projectSourceIds)));
            CommonResponse<JSONArray> prjResp = projectPoolApi.getProjectPoolList(qm);
            if (!prjResp.isSuccess()) {
                logger.error("根据项目sourceId列表-{}，获取项目信息失败", JSONObject.toJSONString(projectSourceIds));
            }
            for (ProjectPoolSetVO project : JSONArray.parseArray(JSONObject.toJSONString(prjResp.getData()), ProjectPoolSetVO.class)) {
                projectCache.put(project.getSourceId(), project.getId());
            }
        }
        //设置项目信息
        saveList.stream().forEach(item -> {
            if (null == item.getProjectId()) {
                if (projectCache.containsKey(item.getProjectSid())) {
                    item.setProjectId(projectCache.get(item.getProjectSid()));
                }
            }
        });
        logger.info("待保存数据：{}", saveList.size());
        businessContractService.saveOrUpdateBatch(saveList, saveList.size(), false);
    }

    @PostMapping(value = "businessContract/pageList")
    public CommonResponse<JSONObject> contractPageList(@RequestBody Map<String, Object> param) throws Exception {
        JSONObject resp = new JSONObject();
        StringBuilder reqUrl = new StringBuilder();
        Map<String, Object> params = new HashMap<>();
        params.put("PageSize", param.get("pageSize"));
        params.put("PageNum", param.get("pageNum"));
        reqUrl.append(reqHost).append(BUSINESS_CONTRACT_ERP_REQ_URL);
        String nowStr = DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date());
        if (param.containsKey("condition")) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject((String) param.get("condition"));
            if (_con.containsKey("projectId")) {
                reqUrl.append("?ProjectOID=").append(getProjectSid(Long.valueOf(_con.getString("projectId"))));
            }
        }
        Map<String, String> headers = new HashMap<>();
        headers.put("appid", toMD5(appId));
        headers.put("ticket", nowStr);
        headers.put("sign", toMD5(secret + toMD5(appId) + toMD5(nowStr)));
        logger.info("商务合同接口：{}", reqUrl);
        String feePackageResp = HttpTookit.postByJson(reqUrl.toString(), JSONObject.toJSONString(params), headers, 10000, 10000);
        logger.info("商务合同数据：{}", feePackageResp);
        logger.info("商务合同数据url：{},params:{},headers{}", reqUrl, JSONObject.toJSONString(params), JSONObject.toJSONString(headers));
        JSONObject result = JSONObject.parseObject(feePackageResp);
        if (!"ok".equals(result.getString("status"))) {
            return CommonResponse.error("获取ERP商务合同信息失败");
        }
        resp.put("total", result.getString("allCount"));
        resp.put("current", param.get("pageNum"));
        resp.put("size", param.get("pageSize"));
        resp.put("records", result.getJSONArray("data"));

        return CommonResponse.success(resp);
    }


    private String getProjectSid(Long projectId) {
        String cachcKey = ERP_CACHE_PROJECT_PREFIX + projectId.toString();
        if (null != cacheManager.get(cachcKey)) {
            return cacheManager.get(cachcKey);
        }
        CommonResponse<JSONArray> prjResp = projectPoolApi.queryProjectPoolById(projectId);
        if (!prjResp.isSuccess()) {
            throw new BusinessException("根据项目Id获取项目信息异常！");
        }
        ProjectPoolSetVO vo = prjResp.getData().getObject(0, ProjectPoolSetVO.class);
        cacheManager.set(cachcKey, vo.getSourceId());
        return vo.getSourceId();
    }

    public static String toMD5(String plainText) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hashBytes = digest.digest(plainText.getBytes());

        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xff) + 0x100, 16).substring(1));
        }

        return sb.toString().toLowerCase();
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/businessContract/refData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BusinessContractVO>> refContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("projectId")) {
                CommonResponse<ProjectPoolSetVO> projectResp = projectPoolApi.getById(_con.getLong("projectId"));
                if(!projectResp.isSuccess()) {
                    logger.error("根据项目编码-{}查询项目信息失败！", _con.getLong("projectId"));
                    param.getParams().put("projectId", new Parameter(QueryParam.EQ, String.valueOf(_con.get("projectId"))));
                } else {
                    ComplexParam c1 = new ComplexParam();
                    c1.setLogic("and");

                    ComplexParam c2 = new ComplexParam();
                    c2.setLogic("or");
                    c2.getParams().put("projectId", new Parameter(QueryParam.EQ, String.valueOf(_con.get("projectId"))));

                    ComplexParam c3 = new ComplexParam();
                    c3.setLogic("or");
                    c3.getParams().put("projectSid", new Parameter(QueryParam.EQ, projectResp.getData().getSourceId()));

                    c1.getComplexParams().add(c2);
                    c1.getComplexParams().add(c3);
                    param.getComplexParams().add(c1);
                }
            }
            if(_con.containsKey("contractFlag")) {
                param.getParams().put("contractFlag", new Parameter(QueryParam.EQ, _con.getInteger("contractFlag")));
            }
        }
        param.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<BusinessContractEntity> page = businessContractService.queryPage(param,false);
        IPage<BusinessContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BusinessContractVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/feePackage/refData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FeePackageVO>> refFeePackageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                    String condition,
                                                                    String searchObject,
                                                                    String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("projectId")) {

                //查询项目信息
                CommonResponse<ProjectPoolSetVO> projectResp = projectPoolApi.getById(_con.getLong("projectId"));
                if(!projectResp.isSuccess() || null == projectResp.getData()) {
                    logger.error("获取项目信息异常, {}", JSONObject.toJSONString(projectResp, SerializerFeature.PrettyFormat));
                    param.getParams().put("projectId", new Parameter(QueryParam.EQ, String.valueOf(_con.get("projectId"))));
                } else {
                    ProjectPoolSetVO project = projectResp.getData();
                    if( "2".equals(project.getBudgetVer()) && _con.containsKey("categoryCode")) {
                        String categoryCode = _con.getString("categoryCode");
                        //编码查询二级分类
                        String code = categoryService.queryPidCodeByCode(categoryCode);
//                  param.getParams().put("materialPackageCode", new Parameter(QueryParam.LIKE, code));
                        param.getParams().put("", new Parameter(QueryParam.SQL,"( (material_package_code like '%"+ code +"%' and charge_type_name = '采购主材费' ) or material_package_code like '%F-LX-1%')"));

                    } else {
                        param.getParams().put("", new Parameter(QueryParam.SQL,"(material_package_code like '%.3' or material_package_code like '%.4' or material_package_code like '%.5')"));
                    }

                    ComplexParam c1 = new ComplexParam();
                    c1.setLogic("and");

                    ComplexParam c2 = new ComplexParam();
                    c2.setLogic("or");
                    c2.getParams().put("projectId", new Parameter(QueryParam.EQ, project.getId()));

                    ComplexParam c3 = new ComplexParam();
                    c3.setLogic("or");
                    c3.getParams().put("projectSid", new Parameter(QueryParam.EQ, project.getSourceId()));

                    c1.getComplexParams().add(c2);
                    c1.getComplexParams().add(c3);
                    param.getComplexParams().add(c1);
                }
            }
            if (_con.containsKey("businessContractId")) {
                param.getParams().put("businessContractId", new Parameter(QueryParam.EQ, String.valueOf(_con.get("businessContractId"))));
            }
            if(_con.containsKey("contractId")) {
                List<BusinessContractEntity> contracts = businessContractService.getAllContractsBySourceId(_con.getString("contractId"));
                param.getParams().put("business_contract_sid", new Parameter(QueryParam.IN,
                        contracts.stream().map(BusinessContractEntity::getPcmContractOid).collect(Collectors.toList())));
            }
        }
        param.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<FeePackageEntity> page = feePackageService.queryPage(param,false);
        IPage<FeePackageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FeePackageVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    private ProjectPoolSetVO getProject(String projectSourceId) {
        String cacheKey = "ERP_CACHE_PROJECT_PREFIX"+projectSourceId;
        if(null != cacheManager.get(cacheKey)) {
            return cacheManager.get(cacheKey);
        }
        CommonResponse<ProjectPoolSetVO> projectResp = projectPoolApi.getOneBySourceId(projectSourceId);
        if(!projectResp.isSuccess()) {
            throw new BusinessException("根据项目来源Id{"+projectSourceId+"}获取项目信息异常！");
        }
        ProjectPoolSetVO vo = projectResp.getData();
        cacheManager.set(cacheKey, vo);
        return vo;
    }

    private BusinessContractEntity getBusinessContract(String contractId) {
        String cacheKey = "ERP_CACHE_BUSINESS_CONTRACT_PREFIX"+contractId;
        if(null != cacheManager.get(cacheKey)) {
            return cacheManager.get(cacheKey);
        }
        BusinessContractEntity entity =  businessContractService.getBySourceId(contractId);
        if(entity!=null) {
            cacheManager.set(cacheKey, entity);
            return entity;
        }
       return null;
    }




}
