package com.ejianc.business.zdsmaterial.erp.service;

import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.vo.ContractVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 物资合同
 * 
 * @author generator
 * 
 */
public interface IContractService extends IBaseService<ContractEntity> {

    /**
     * 根据合同来源Id查询匹配的合同
     *
     * @param sourceContractId
     * @return
     */
    ContractVO getOneBySourceContractId(String sourceContractId);

    /**
     * 根据合同编码查询匹配的合同
     *
     * @param contractCode
     * @return
     */
    ContractVO getOneByCode(String contractCode);

    /**
     * 保存同步的合同信息
     *
     * @param saveContractInfo
     * @return
     */
    ContractVO saveContract(ContractVO saveContractInfo);

    List<ContractEntity> getBySourceIds(List<String> sourceIds);

    /**
     * 履约中
     * @return
     */
     Integer performanceNum(Long linkerId, String linkerSid, Long supplierId);
    /**
     * 已结束
     * @return
     */
    Integer finishedNum(Long linkerId, String linkerSid, Long supplierId);
    /**
     * 本年度新签合
     * @return
     */
    String thisYearContract(Long linkerId, String linkerSid, Long supplierId);

    int countContractAndOrder(Map<String, Object> queryParam);

    List<Map> pageContractAndOrder(Map<String, Object> queryParam);

    /**
     * 本年度新签合同额
     *  总价合同（主合同+附加合同）+单价合同（所有订单的金额，根据订单的签署日期，不统计单价合同金额，只统计订单金额）；
     * @param linkerId
     * @param linkerSid
     * @param supplierId
     * @return
     */
    BigDecimal thisYearContractMny(Long linkerId, String linkerSid, Long supplierId);

    /**
     * ERP合同作废
     *
     * @param delContractIds
     */
    void cancelBill(List<Long> delContractIds);

    List<String> getSyncList();

    void updateSyncResult(String sourceContractId, String syncFlag);

    List<Long> getAllTransferContractIds(Long userId);
}
