package com.ejianc.business.zdsmaterial.plan.control.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 物资总控计划明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_control_plan_detail")
public class ControlPlanDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="plan_id")
    private Long planId; // 主表主键ID
    @TableField(value="material_id")
    private Long materialId; // 物资主键
    @TableField(value="material_code")
    private String materialCode; // 物料编码
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资类别
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资类别名称
    @TableField(value="property")
    private String property; // 属性
    @TableField(value="property_value")
    private String propertyValue; // 属性值
    @TableField(value="unit_id")
    private Long unitId; // 计量单位Id
    @TableField(value="unit_name")
    private String unitName; // 单位
    @TableField(value="num")
    private BigDecimal num; // 总控量
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="source_type")
    private Integer sourceType; // 来源：1-档案，2-新增
    @TableField(value="row_type")
    private Integer rowType; // 行类型：1-新增，2-变更
    @TableField(value="reason")
    private String reason; // 超量原因
    @TableField(value="before_num")
    private BigDecimal beforeNum; // 变更前总控量
    @TableField(value="after_num")
    private BigDecimal afterNum; // 变更后总控量
    @TableField(value="purchase_num")
    private BigDecimal purchaseNum; // 累计采购量
    @TableField(value="parent_material_type_id")
    private Long parentMaterialTypeId; // 二级分类主键
    @TableField(value="has_new_property_val")
    private Integer hasNewPropertyVal; // 是否新增属性值：0-否，1-是
    @TableField(value = "product_code")
    private String productCode; // 产品代码
    @TableField(value="material_type_code")
    private String materialTypeCode; // 物资分类编码
    @TableField(value="brand_id")
    private Long brandId; //品牌主键
    @TableField(value="brand_name")
    private String brandName; // 品牌名称
    @TableField(value="description")
    private String description; // 描述
    @TableField(value="parent_material_type_code")
    private String parentMaterialTypeCode; // 二级分类编码
    @TableField(value="parent_material_type_name")
    private String parentMaterialTypeName; // 二级分类名称
    @TableField(value="detail_index")
    private String detailIndex; // 序号

    @TableField(value = "identification_id")
    private String identificationId; // 物料识别唯一标识

    @TableField(value = "original_in_material_name")
    private String originalInMaterialName; //初始导入物料名称
    @TableField(value = "original_in_material_spec")
    private String originalInMaterialSpec; //初始导入物料规格型号
    @TableField(value = "original_in_material_unit_name")
    private String originalInMaterialUnitName; //初始导入物料单位

    /**
     * 切包改造====
     */
    @TableField(value = "material_pack_id")
    private Long materialPackId; // 切包情况-材料包id，二级物料类别
    @TableField(value = "material_pack_code")
    private String materialPackCode; // 切包情况-材料包编码
    @TableField(value = "material_pack_name")
    private String materialPackName; // 切包情况-材料包名称
    @TableField(value = "item_code")
    private String itemCode; // 清单编码
    @TableField(value = "item_name")
    private String itemName; // 清单名称
    @TableField(value = "budget_type")
    private String budgetType; // 1:切包请单内2：切包清单外
    @TableField(value = "budget_detail_id")
    private Long budgetDetailId; // 清单子表ID


    /**
     * 切包改造end=====
     */
    public Long getBudgetDetailId() {
        return budgetDetailId;
    }

    public void setBudgetDetailId(Long budgetDetailId) {
        this.budgetDetailId = budgetDetailId;
    }
    public Long getMaterialPackId() {
        return materialPackId;
    }

    public void setMaterialPackId(Long materialPackId) {
        this.materialPackId = materialPackId;
    }

    public String getMaterialPackCode() {
        return materialPackCode;
    }

    public void setMaterialPackCode(String materialPackCode) {
        this.materialPackCode = materialPackCode;
    }

    public String getMaterialPackName() {
        return materialPackName;
    }

    public void setMaterialPackName(String materialPackName) {
        this.materialPackName = materialPackName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getBudgetType() {
        return budgetType;
    }

    public void setBudgetType(String budgetType) {
        this.budgetType = budgetType;
    }

    public String getIdentificationId() {
        return identificationId;
    }

    public void setIdentificationId(String identificationId) {
        this.identificationId = identificationId;
    }

    public String getOriginalInMaterialName() {
        return originalInMaterialName;
    }

    public void setOriginalInMaterialName(String originalInMaterialName) {
        this.originalInMaterialName = originalInMaterialName;
    }

    public String getOriginalInMaterialSpec() {
        return originalInMaterialSpec;
    }

    public void setOriginalInMaterialSpec(String originalInMaterialSpec) {
        this.originalInMaterialSpec = originalInMaterialSpec;
    }

    public String getOriginalInMaterialUnitName() {
        return originalInMaterialUnitName;
    }

    public void setOriginalInMaterialUnitName(String originalInMaterialUnitName) {
        this.originalInMaterialUnitName = originalInMaterialUnitName;
    }

    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }

    public String getParentMaterialTypeCode() {
        return parentMaterialTypeCode;
    }

    public void setParentMaterialTypeCode(String parentMaterialTypeCode) {
        this.parentMaterialTypeCode = parentMaterialTypeCode;
    }

    public String getParentMaterialTypeName() {
        return parentMaterialTypeName;
    }

    public void setParentMaterialTypeName(String parentMaterialTypeName) {
        this.parentMaterialTypeName = parentMaterialTypeName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public String getProperty() {
        return property;
    }

    public void setProperty(String property) {
        this.property = property;
    }
    public String getPropertyValue() {
        return propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Integer getRowType() {
        return rowType;
    }

    public void setRowType(Integer rowType) {
        this.rowType = rowType;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public BigDecimal getBeforeNum() {
        return beforeNum;
    }

    public void setBeforeNum(BigDecimal beforeNum) {
        this.beforeNum = beforeNum;
    }

    public BigDecimal getAfterNum() {
        return afterNum;
    }

    public void setAfterNum(BigDecimal afterNum) {
        this.afterNum = afterNum;
    }

    public BigDecimal getPurchaseNum() {
        return purchaseNum;
    }

    public void setPurchaseNum(BigDecimal purchaseNum) {
        this.purchaseNum = purchaseNum;
    }

    public Long getParentMaterialTypeId() {
        return parentMaterialTypeId;
    }

    public void setParentMaterialTypeId(Long parentMaterialTypeId) {
        this.parentMaterialTypeId = parentMaterialTypeId;
    }

    public Integer getHasNewPropertyVal() {
        return hasNewPropertyVal;
    }

    public void setHasNewPropertyVal(Integer hasNewPropertyVal) {
        this.hasNewPropertyVal = hasNewPropertyVal;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }
}
