package com.ejianc.business.zdsmaterial.pricelib.engine.impl;

import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertyService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertySubItemService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertyVO;
import com.ejianc.business.zdsmaterial.pricelib.engine.PricingEngine;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceSubConditionDetailVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceLibVO;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author: caojie
 * @CreateTime:2025-07-04 13:51
 * @Version: 1.0
 */
abstract class BasePricingEngine implements PricingEngine {

    public MaterialPriceCalcSubConditionVO findMatchingCondition(PriceLibVO p, List<MaterialPriceCalcSubConditionVO> conditions) {
        if(CollectionUtils.isEmpty(conditions)) {
            p.setCalcContent("未计算: 【计算规则条件】为空");
            return null;
        }

        return conditions.stream().filter(c -> CollectionUtils.isNotEmpty(c.getDetailList()) && matches(p, c.getDetailList())).max(Comparator.comparingInt(MaterialPriceCalcSubConditionVO::getSequence)).orElse(null);
    }

    public boolean matches(PriceLibVO p, List<MaterialPriceSubConditionDetailVO> detailList) {
        if(CollectionUtils.isEmpty(detailList)) {
            return false;
        }

        IMaterialCategoryPropertySubItemService itemService = null;
        IMaterialCategoryPropertyService propertyService = null;
        Map<Long, MaterialCategoryPropertySubItemVO> itemMap = new HashMap<>();
        Map<Long, MaterialCategoryPropertyVO> propertyMap = new HashMap<>();

        Set<String> eleTypes = detailList.stream().map(MaterialPriceSubConditionDetailVO::getElemType).collect(Collectors.toSet());
        if(eleTypes.contains("propertyItemDoc")) {
            itemService = ContextUtil.getBean("materialCategoryPropertySubItemService", IMaterialCategoryPropertySubItemService.class);
            propertyService = ContextUtil.getBean("materialCategoryPropertyService", IMaterialCategoryPropertyService.class);

            List<MaterialCategoryPropertySubItemVO> itemVOS = itemService.getAllByCategoryId(p.getMaterialTypeId());
            itemMap.putAll(itemVOS.stream().collect(Collectors.toMap(item -> item.getId(), item ->item)));

            List<MaterialCategoryPropertyVO> propertyVOS = propertyService.getAllByCategoryId(p.getMaterialTypeId(), 1);
            propertyMap.putAll(propertyVOS.stream().collect(Collectors.toMap(item -> item.getId(), item ->item)));
        }


        return detailList.stream().allMatch(c -> {
            boolean matchFlag = false;
            switch (c.getElemType()) {
                case "brandDoc":
                    //0-等于,1-大于，2-小于，3-大于等于,4-小于等于,5-不等于，6-包含
                    switch (c.getCondType()) {
                        case "0":
                            matchFlag = StringUtils.equals(p.getBrand(), c.getElemName());
                            break;
                        case "1":
                        case "2":
                        case "5":
                            matchFlag =  !StringUtils.equals(p.getBrand(), c.getElemName());
                            break;
                        case "3":
                        case "4":
                        case "6":
                            matchFlag =  p.getBrand().indexOf(c.getElemName()) >= 0;
                            break;
                    }
                    break;
                case "categoryDoc":
                    //0-等于,1-大于，2-小于，3-大于等于,4-小于等于,5-不等于，6-包含
                    switch (c.getCondType()) {
                        case "0":
                            matchFlag = null != p.getMaterialTypeId() && StringUtils.isNotBlank(c.getElemDocId())
                                    && StringUtils.equals(p.getMaterialTypeId().toString(), c.getElemDocId());
                            break;
                        case "1":
                        case "2":
                        case "3":
                        case "4":
                        case "5":
                        case "6":
                            matchFlag = !(null != p.getMaterialTypeId() && StringUtils.isNotBlank(c.getElemDocId())
                                    && StringUtils.equals(p.getMaterialTypeId().toString(), c.getElemDocId()));
                            break;
                    }
                    break;
                case "propertyDoc":
                    //TODO
                    break;
                case "propertyItemDoc":
                    MaterialCategoryPropertySubItemVO tmpItem = itemMap.get(Long.valueOf(c.getElemDocId()));
                    if(null == tmpItem) {
                        return false;
                    }
                    MaterialCategoryPropertyVO tmpProperty = propertyMap.get(tmpItem.getPropertyId());
                    String materialSpec = p.getSpec();
                    String materialItemName= null;
                    for(String propertyItemStr : materialSpec.split("；")) {
                        if(tmpProperty.getName().equals(propertyItemStr.split("：")[0])) {
                            materialItemName = propertyItemStr.split("：")[1];
                            break;
                        }
                    }

                    //0-等于,1-大于，2-小于，3-大于等于,4-小于等于,5-不等于，6-包含
                    switch (c.getCondType()) {
                        case "0":
                            matchFlag = StringUtils.equals(materialItemName, c.getElemName());
                            break;
                        case "1":
                        case "2":
                        case "5":
                            matchFlag = !StringUtils.equals(materialItemName, c.getElemName());
                            break;
                        case "3":
                        case "4":
                        case "6":
                            matchFlag = StringUtils.isNotBlank(materialItemName) && materialItemName.indexOf(c.getElemName()) >= 0;
                            break;
                    }

                    break;
                case "material":
                    //0-等于,1-大于，2-小于，3-大于等于,4-小于等于,5-不等于，6-包含
                    switch (c.getCondType()) {
                        case "0":
                            matchFlag = StringUtils.equals(p.getBaseMaterialName(), c.getElemName());
                            break;
                        case "1":
                        case "2":
                        case "5":
                            matchFlag = !StringUtils.equals(p.getBaseMaterialName(), c.getElemName());
                            break;
                        case "3":
                        case "4":
                        case "6":
                            matchFlag = StringUtils.isNotBlank(p.getBaseMaterialName()) && p.getBaseMaterialName().indexOf(c.getElemName()) >= 0;
                            break;
                    }
                    break;
                default:
                    return false;
            }

            return matchFlag;
        });
    }

}
