package com.ejianc.business.zdsmaterial.sub.invoice.vo;

import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 分包发票登记
 *
 * @author generator
 *
 */
public class SubInvoiceVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long contractId; // 合同主键
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private String sourceContractId; // 合同来源主键
    private Long supplierId; // 供应商id
    private String supplierCode; // 供应商编码
    private String supplierName; // 供应商名称
    private String execCode; // 执行编码
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 单据组织id
    private String orgCode; // 单据组织编码
    private String orgName; // 单据组织名称
    private Long parentOrgId; // 上级组织id
    private String parentOrgCode; // 上级组织编码
    private String parentOrgName; // 上级组织名称
    private String execHeadquarters; // 执行总部
    private String billCode; // 单据编码
    private Date billDate; // 单据日期
    private Integer billState; // 单据状态（审批必须字段）
    private Long createUserId; // 制单人Id
    private String contractType; // 合同类型
    private BigDecimal mainContMny; // 主合同额
    private BigDecimal childContMny; // 附加合同额
    private String invoiceType; // 合同约定发票类型
    private BigDecimal orderMny; // 订单金额
    private BigDecimal contRate; // 合同税率
    private String invoiceHeader; // 发票抬头
    private Integer taxCreateState; // 是否税务局代开
    private String invoiceCty; // 发票种类：1-增值税专用发票2-增值税普通发票3-其他
    private Long taxCtyId; // 税收分类
    private String taxCtyCode; // 税收分类编码
    private String taxCtyName; // 税收分类名称
    private BigDecimal invoiceRate; // 发票税率
    private BigDecimal totalMny; // 发票金额
    private BigDecimal totalTaxMny; // 发票金额(含税)
    private BigDecimal totalTax; // 税额
    private String adminId; // 发票管理员
    private String adminCode; // 发票管理员编码
    private String adminName; // 发票管理员名称
    private String createUserName; // 创建者名称
    private String memo; // 备注
    private Integer signState; // 申请状态0-待审核1-已审核2-已驳回
    private Long sourceId; // 来源主键
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date operateTime; // 操作时间
    private Long operateId; // 操作人id
    private String operateName; // 操作人名称
    private String systemId; // 来源系统主键
    private String billPushFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方

    private String rejectReason;//驳回原因
    private String pushErpFlag; //推送ERP标识 0-未推送，1-已推送, 2-发票引用不推送
    private Integer sourceType; // 来源方式：1-自制，2-供方发起
    private String openOcrState; // 是否开启OCR识别：0-未开启，1-已开启

    private Long chiefAccountantId; //主管会计Id
    private String chiefAccountantName; //主管会计名称

    private List<SubInvoiceDetailVO> detailList = new ArrayList<>(); // 分包发票登记-明细
    private List<SubInvoiceFileVO> fileList = new ArrayList<>(); // 分包发票登记-附件
    private List<SubInvoiceOcrVO> ocrList = new ArrayList<>(); // 分包发票登记-OCR附件
    private List<AttachmentVO> files = new ArrayList<>();// 上传附件

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人编码
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectiveDate; // 生效日期
    private Integer printFlag; //单据是否已打印标识：0-否，1-是

    private Long lastPrintUserId; // 最近打印人id
    private String lastPrintUserName; // 最近打印人名称
    private String lastPrintUserCode; // 最近打印人编码

    private Long finalApproveUserId; // 最终审核人id
    private String finalApproveUserName; // 最终审核人名称
    private String finalApproveUserCode; // 最终审核人编码

    public Long getLastPrintUserId() {
        return lastPrintUserId;
    }

    public void setLastPrintUserId(Long lastPrintUserId) {
        this.lastPrintUserId = lastPrintUserId;
    }

    public String getLastPrintUserName() {
        return lastPrintUserName;
    }

    public void setLastPrintUserName(String lastPrintUserName) {
        this.lastPrintUserName = lastPrintUserName;
    }

    public String getLastPrintUserCode() {
        return lastPrintUserCode;
    }

    public void setLastPrintUserCode(String lastPrintUserCode) {
        this.lastPrintUserCode = lastPrintUserCode;
    }

    public Long getFinalApproveUserId() {
        return finalApproveUserId;
    }

    public void setFinalApproveUserId(Long finalApproveUserId) {
        this.finalApproveUserId = finalApproveUserId;
    }

    public String getFinalApproveUserName() {
        return finalApproveUserName;
    }

    public void setFinalApproveUserName(String finalApproveUserName) {
        this.finalApproveUserName = finalApproveUserName;
    }

    public String getFinalApproveUserCode() {
        return finalApproveUserCode;
    }

    public void setFinalApproveUserCode(String finalApproveUserCode) {
        this.finalApproveUserCode = finalApproveUserCode;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Integer getPrintFlag() {
        return printFlag;
    }

    public void setPrintFlag(Integer printFlag) {
        this.printFlag = printFlag;
    }

    public Long getChiefAccountantId() {
        return chiefAccountantId;
    }

    public void setChiefAccountantId(Long chiefAccountantId) {
        this.chiefAccountantId = chiefAccountantId;
    }

    public String getChiefAccountantName() {
        return chiefAccountantName;
    }

    public void setChiefAccountantName(String chiefAccountantName) {
        this.chiefAccountantName = chiefAccountantName;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getPushErpFlag() {
        return pushErpFlag;
    }

    public void setPushErpFlag(String pushErpFlag) {
        this.pushErpFlag = pushErpFlag;
    }

    public String getRejectReason() {
        return rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getSourceContractId() {
        return sourceContractId;
    }

    public void setSourceContractId(String sourceContractId) {
        this.sourceContractId = sourceContractId;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getExecCode() {
        return execCode;
    }

    public void setExecCode(String execCode) {
        this.execCode = execCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getExecHeadquarters() {
        return execHeadquarters;
    }

    public void setExecHeadquarters(String execHeadquarters) {
        this.execHeadquarters = execHeadquarters;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    public BigDecimal getMainContMny() {
        return mainContMny;
    }

    public void setMainContMny(BigDecimal mainContMny) {
        this.mainContMny = mainContMny;
    }
    public BigDecimal getChildContMny() {
        return childContMny;
    }

    public void setChildContMny(BigDecimal childContMny) {
        this.childContMny = childContMny;
    }
    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }
    public BigDecimal getOrderMny() {
        return orderMny;
    }

    public void setOrderMny(BigDecimal orderMny) {
        this.orderMny = orderMny;
    }
    public BigDecimal getContRate() {
        return contRate;
    }

    public void setContRate(BigDecimal contRate) {
        this.contRate = contRate;
    }
    public String getInvoiceHeader() {
        return invoiceHeader;
    }

    public void setInvoiceHeader(String invoiceHeader) {
        this.invoiceHeader = invoiceHeader;
    }
    public Integer getTaxCreateState() {
        return taxCreateState;
    }

    public void setTaxCreateState(Integer taxCreateState) {
        this.taxCreateState = taxCreateState;
    }
    public String getInvoiceCty() {
        return invoiceCty;
    }

    public void setInvoiceCty(String invoiceCty) {
        this.invoiceCty = invoiceCty;
    }
    public Long getTaxCtyId() {
        return taxCtyId;
    }

    public void setTaxCtyId(Long taxCtyId) {
        this.taxCtyId = taxCtyId;
    }
    public String getTaxCtyCode() {
        return taxCtyCode;
    }

    public void setTaxCtyCode(String taxCtyCode) {
        this.taxCtyCode = taxCtyCode;
    }
    public String getTaxCtyName() {
        return taxCtyName;
    }

    public void setTaxCtyName(String taxCtyName) {
        this.taxCtyName = taxCtyName;
    }
    public BigDecimal getInvoiceRate() {
        return invoiceRate;
    }

    public void setInvoiceRate(BigDecimal invoiceRate) {
        this.invoiceRate = invoiceRate;
    }
    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }

    public BigDecimal getTotalTaxMny() {
        return totalTaxMny;
    }

    public void setTotalTaxMny(BigDecimal totalTaxMny) {
        this.totalTaxMny = totalTaxMny;
    }

    public BigDecimal getTotalTax() {
        return totalTax;
    }

    public void setTotalTax(BigDecimal totalTax) {
        this.totalTax = totalTax;
    }
    public String getAdminId() {
        return adminId;
    }

    public void setAdminId(String adminId) {
        this.adminId = adminId;
    }
    public String getAdminCode() {
        return adminCode;
    }

    public void setAdminCode(String adminCode) {
        this.adminCode = adminCode;
    }
    public String getAdminName() {
        return adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getSignState() {
        return signState;
    }

    public void setSignState(Integer signState) {
        this.signState = signState;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Date getOperateTime() {
        return operateTime;
    }

    public void setOperateTime(Date operateTime) {
        this.operateTime = operateTime;
    }
    public Long getOperateId() {
        return operateId;
    }

    public void setOperateId(Long operateId) {
        this.operateId = operateId;
    }
    public String getOperateName() {
        return operateName;
    }

    public void setOperateName(String operateName) {
        this.operateName = operateName;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getOpenOcrState() {
        return openOcrState;
    }

    public void setOpenOcrState(String openOcrState) {
        this.openOcrState = openOcrState;
    }

    public List<SubInvoiceDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<SubInvoiceDetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<SubInvoiceFileVO> getFileList() {
        return fileList;
    }

    public void setFileList(List<SubInvoiceFileVO> fileList) {
        this.fileList = fileList;
    }

    public List<SubInvoiceOcrVO> getOcrList() {
        return ocrList;
    }

    public void setOcrList(List<SubInvoiceOcrVO> ocrList) {
        this.ocrList = ocrList;
    }

    public List<AttachmentVO> getFiles() {
        return files;
    }

    public void setFiles(List<AttachmentVO> files) {
        this.files = files;
    }
}
