/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.subvisa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.SignatureChangeEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.enums.InstructionStatusEnum;
import com.ejianc.business.zdsmaterial.sub.subvisa.service.IInstructionSetService;
import com.ejianc.business.zdsmaterial.sub.subvisa.service.ISignatureChangeService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="signatureChange")
public class SignatureChangeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private ISignatureChangeService service;
    @Autowired
    private IInstructionSetService instructionSetService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        SignatureChangeEntity entity = (SignatureChangeEntity)((Object)this.service.selectById(billId));
        if (entity.getSourceType().equals(InstructionStatusEnum.\u76f4\u63a5\u65b0\u589e.getStatus())) {
            Integer integer = this.instructionSetService.queryInstructionSetStatus(entity.getSetId());
            if (InstructionStatusEnum.\u5df2\u5f15\u7528.getStatus().equals(integer)) {
                throw new BusinessException("\u5f53\u524d\u6307\u4ee4\u5355\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4!");
            }
        }
        if (entity.getDetailList().size() > 0 || CollectionUtils.isNotEmpty(entity.getDetailList())) {
            if (entity.getReceiveStatus().equals(InstructionStatusEnum.\u5df2\u9a73\u56de.getStatus())) {
                return CommonResponse.error((String)"\u5df2\u9a73\u56de\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff01");
            }
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u4e8b\u9879\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff01");
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        SignatureChangeEntity entity = (SignatureChangeEntity)((Object)this.service.selectById(billId));
        entity.setReceiveStatus(InstructionStatusEnum.\u5ba1\u6838\u4e2d.getStatus());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SignatureChangeEntity entity = (SignatureChangeEntity)((Object)this.service.selectById(billId));
        if (entity.getSourceType().equals(InstructionStatusEnum.\u76f4\u63a5\u65b0\u589e.getStatus())) {
            this.instructionSetService.changeInstructionSetStatus(entity.getSetId(), InstructionStatusEnum.\u5df2\u5f15\u7528.getStatus());
        }
        entity.setReceiveStatus(InstructionStatusEnum.\u5df2\u5ba1\u6838.getStatus());
        String s = this.service.pushBill(entity);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            throw new BusinessException(s);
        }
        this.service.saveOrUpdate((Object)entity, false);
        this.logger.info("\u53d8\u66f4\u7b7e\u8bc1\u6307\u4ee4\u5355\u5411\u4e59\u65b9\u8054\u7cfb\u4ebaid-{}\u53d1\u9001\u6d88\u606f", (Object)entity.getPartyBContactId().toString());
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setSubject("\u3010\u53d8\u66f4\u7b7e\u8bc1\u6307\u4ee4\u5355\u3011\uff1a\u3010" + entity.getBillCode() + "\u3011\uff0c\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u53d1\u8d27\u5355\u5df2\u9a8c\u6536\uff0c\u8bf7\u67e5\u770b\uff01");
        StringBuilder content = new StringBuilder();
        content.append("\u3010").append(entity.getSupplierName()).append("\u3011\uff0c\u3010").append(entity.getProjectName()).append("\u3011\uff0c\u3010").append(entity.getSubContractName()).append("\u3011\u8fdb\u884c\u53d8\u66f4\u7b7e\u8bc1\uff0c\u3010").append(entity.getBillCode()).append("\u3011\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01");
        parameter.setContent(content.toString());
        parameter.setPcUrl(this.BASE_HOST + "ejc-zdsmaterial-frontend/#/signatureChange/card?id=" + entity.getId().toString());
        String[] recIds = new String[]{entity.getPartyBContactId().toString()};
        parameter.setReceivers(recIds);
        this.sendMsg(parameter, entity.getId(), "\u53d8\u66f4\u7b7e\u8bc1\u6307\u4ee4\u5355\u5411\u4e59\u65b9\u8054\u7cfb\u4eba\u53d1\u9001\u6d88\u606f");
        return CommonResponse.success();
    }

    public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{"sys", "email"});
        CommonResponse sendResp = this.pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            this.logger.error("{}-\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u5355\u636eId-{}\uff0c\u53d1\u9001\u6d88\u606f\u7ed3\u679c-{}", new Object[]{oprMsg, billId, JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
        } else {
            this.logger.info("{}-\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01", (Object)oprMsg);
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

